/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.view.CalendarFXControl;
import impl.com.calendarfx.view.print.ZoomPaneSkin;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;

public class ZoomPane
extends CalendarFXControl {
    public static final double MIN_ZOOM_VALUE = 1.0;
    public static final double MAX_ZOOM_VALUE = 5.0;
    public static final String DEFAULT_STYLE = "zoom-pane";
    private final ObjectProperty<Region> content = new SimpleObjectProperty<Region>((Object)this, "content"){

        public void set(Region newValue) {
            Objects.requireNonNull(newValue);
            ZoomPane.this.setZoom(1.0);
            super.set((Object)newValue);
        }
    };
    private final DoubleProperty zoom = new SimpleDoubleProperty((Object)this, "zoom", 1.0);

    public ZoomPane() {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        this.zoomProperty().addListener(obs -> {
            if (this.getZoom() < 1.0 || this.getZoom() > 5.0) {
                throw new IndexOutOfBoundsException("The new value is out of bounds!");
            }
        });
        this.setPrefSize(700.0, 700.0);
    }

    public ZoomPane(Region content) {
        this();
        this.setContent(content);
    }

    protected Skin<?> createDefaultSkin() {
        return new ZoomPaneSkin(this);
    }

    public final ObjectProperty<Region> contentProperty() {
        return this.content;
    }

    public final Region getContent() {
        return (Region)this.contentProperty().get();
    }

    public final void setContent(Region content) {
        this.contentProperty().set((Object)content);
    }

    public final DoubleProperty zoomProperty() {
        return this.zoom;
    }

    public final double getZoom() {
        return this.zoomProperty().get();
    }

    public final void setZoom(double zoom) {
        this.zoomProperty().set(zoom);
    }
}

