/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.ButtonBar;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;

public class ButtonBarSkin
extends SkinBase<ButtonBar> {
    private static final String ONLY_BUTTON = "only-button";
    private static final String LEFT_PILL = "left-pill";
    private static final String CENTER_PILL = "center-pill";
    private static final String RIGHT_PILL = "right-pill";
    private final HBox container = new HBox();

    public ButtonBarSkin(ButtonBar control) {
        super((Control)control);
        this.container.getStyleClass().add((Object)"container");
        this.container.setFillHeight(true);
        this.getChildren().add((Object)this.container);
        this.updateButtons();
        this.getButtons().addListener(observable -> this.updateButtons());
    }

    private ObservableList<Button> getButtons() {
        return ((ButtonBar)this.getSkinnable()).getButtons();
    }

    private void updateButtons() {
        ObservableList<Button> buttons = this.getButtons();
        this.container.getChildren().clear();
        for (int i = 0; i < this.getButtons().size(); ++i) {
            Button button = (Button)buttons.get(i);
            button.getStyleClass().removeAll((Object[])new String[]{ONLY_BUTTON, LEFT_PILL, CENTER_PILL, RIGHT_PILL});
            button.setMaxHeight(Double.MAX_VALUE);
            this.container.getChildren().add((Object)button);
            if (i == buttons.size() - 1) {
                if (i == 0) {
                    button.getStyleClass().add((Object)ONLY_BUTTON);
                    continue;
                }
                button.getStyleClass().add((Object)RIGHT_PILL);
                continue;
            }
            if (i == 0) {
                button.getStyleClass().add((Object)LEFT_PILL);
                continue;
            }
            button.getStyleClass().add((Object)CENTER_PILL);
        }
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ButtonBar)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ButtonBar)this.getSkinnable()).prefHeight(width);
    }
}

