/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DeveloperConsole;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.SearchResultView;
import com.calendarfx.view.SourceView;
import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.page.PageBase;
import com.calendarfx.view.popover.ZoneIdComparator;
import com.calendarfx.view.print.PrintView;
import com.calendarfx.view.print.PrintablePage;
import com.calendarfx.view.print.ViewType;
import impl.com.calendarfx.view.ZoneIdStringConverter;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.textfield.CustomTextField;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome.FontAwesome;
import org.kordamp.ikonli.javafx.FontIcon;

public class CalendarViewSkin
extends SkinBase<CalendarView> {
    private final MasterDetailPane leftMasterDetailPane;
    private final ToggleButton trayButton;
    private final Button addCalendarButton;
    private final Button printButton;
    private final SearchResultView searchResultView;
    private final StackPane stackPane;
    private final ToggleButton showYear;
    private final ToggleButton showMonth;
    private final ToggleButton showWeek;
    private final ToggleButton showDay;
    private final HBox leftToolBarBox;
    private final SegmentedButton switcher;
    private SourceView sourceView;
    private final InvalidationListener entriesVisibilityListener = obs -> this.updateCalendarVisibility();
    private final InvalidationListener weakEntriesVisibilityListener = new WeakInvalidationListener(this.entriesVisibilityListener);
    private final InvalidationListener printEntriesVisibilityListener = obs -> this.updatePrintVisibility();
    private final InvalidationListener weakPrintEntriesVisibilityListener = new WeakInvalidationListener(this.printEntriesVisibilityListener);
    private PrintView printView;

    public CalendarViewSkin(CalendarView view) {
        super((Control)view);
        if (Boolean.getBoolean("calendarfx.developer")) {
            view.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.isMetaDown() && evt.getCode().equals((Object)KeyCode.D)) {
                    view.setShowDeveloperConsole(!view.isShowDeveloperConsole());
                }
            });
        }
        view.addEventHandler(RequestEvent.REQUEST_DATE, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> view.showDate(evt.getDate())));
        view.addEventHandler(RequestEvent.REQUEST_DATE_TIME, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> view.showDateTime(evt.getDateTime())));
        view.addEventHandler(RequestEvent.REQUEST_WEEK, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> view.showWeek(evt.getYear(), evt.getWeekOfYear())));
        view.addEventHandler(RequestEvent.REQUEST_YEAR_MONTH, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> view.showYearMonth(evt.getYearMonth())));
        view.addEventHandler(RequestEvent.REQUEST_YEAR, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> view.showYear(evt.getYear())));
        view.addEventHandler(RequestEvent.REQUEST_ENTRY, evt -> this.maybeRunAndConsume((RequestEvent)evt, e -> view.getSelectedPageView().editEntry(evt.getEntry())));
        view.getAvailablePages().addListener(it -> this.buildSwitcher());
        TrayPane trayPane = new TrayPane();
        this.trayButton = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SOURCE_TRAY"));
        this.trayButton.setId("show-tray-button");
        this.trayButton.setMaxHeight(Double.MAX_VALUE);
        FontIcon addIcon = new FontIcon((Ikon)FontAwesome.PLUS);
        addIcon.getStyleClass().addAll((Object[])new String[]{"button-icon", "add-calendar-button-icon"});
        this.addCalendarButton = new Button();
        this.addCalendarButton.setId("add-calendar-button");
        this.addCalendarButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.addCalendarButton.setMaxHeight(Double.MAX_VALUE);
        this.addCalendarButton.setGraphic((Node)addIcon);
        this.addCalendarButton.setOnAction(evt -> view.createCalendarSource());
        FontIcon printIcon = new FontIcon((Ikon)FontAwesome.PRINT);
        printIcon.getStyleClass().addAll((Object[])new String[]{"button-icon", "print-button-icon"});
        this.printButton = new Button();
        this.printButton.setId("print-button");
        this.printButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.printButton.setOnAction(evt -> this.print());
        this.printButton.setMaxHeight(Double.MAX_VALUE);
        this.printButton.setGraphic((Node)printIcon);
        this.leftMasterDetailPane = new MasterDetailPane(Side.LEFT);
        if (view.isShowSourceTray()) {
            this.openTray();
        } else {
            this.closeTray();
        }
        Bindings.bindBidirectional((Property)this.trayButton.selectedProperty(), (Property)view.showSourceTrayProperty());
        view.showSourceTrayProperty().addListener(it -> {
            if (view.isShowSourceTray()) {
                this.openTray();
            } else {
                this.closeTray();
            }
        });
        Platform.runLater(() -> this.sourceView.getCalendarVisibilityMap().keySet().forEach(calendar -> this.sourceView.getCalendarVisibilityProperty((Calendar)calendar).addListener(this.weakEntriesVisibilityListener)));
        view.selectedPageProperty().addListener(this.weakEntriesVisibilityListener);
        ColumnConstraints leftColumn = new ColumnConstraints();
        ColumnConstraints centerColumn = new ColumnConstraints();
        ColumnConstraints rightColumn = new ColumnConstraints();
        leftColumn.setPercentWidth(35.0);
        centerColumn.setPercentWidth(30.0);
        rightColumn.setPercentWidth(35.0);
        GridPane toolBarGridPane = new GridPane();
        toolBarGridPane.setMinWidth(0.0);
        toolBarGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{leftColumn, centerColumn, rightColumn});
        toolBarGridPane.setId("toolbar");
        toolBarGridPane.getStyleClass().add((Object)"tool-bar");
        this.leftToolBarBox = new HBox();
        this.leftToolBarBox.getStyleClass().add((Object)"left-toolbar-container");
        this.leftToolBarBox.setSpacing(5.0);
        this.buildLeftToolBarBox();
        InvalidationListener buildLeftToolBarBoxListener = it -> this.buildLeftToolBarBox();
        view.showSourceTrayButtonProperty().addListener(buildLeftToolBarBoxListener);
        view.showAddCalendarButtonProperty().addListener(buildLeftToolBarBoxListener);
        view.showPrintButtonProperty().addListener(buildLeftToolBarBoxListener);
        view.showPageToolBarControlsProperty().addListener(buildLeftToolBarBoxListener);
        view.selectedPageProperty().addListener(buildLeftToolBarBoxListener);
        toolBarGridPane.add((Node)this.leftToolBarBox, 0, 0);
        this.showDay = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_DAY"));
        this.showWeek = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_WEEK"));
        this.showMonth = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_MONTH"));
        this.showYear = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_YEAR"));
        this.showDay.setOnAction(evt -> {
            view.showDayPage();
            this.updateToggleButtons();
        });
        this.showWeek.setOnAction(evt -> {
            view.showWeekPage();
            this.updateToggleButtons();
        });
        this.showMonth.setOnAction(evt -> {
            view.showMonthPage();
            this.updateToggleButtons();
        });
        this.showYear.setOnAction(evt -> {
            view.showYearPage();
            this.updateToggleButtons();
        });
        this.switcher = new SegmentedButton();
        this.switcher.setId("switcher");
        this.switcher.visibleProperty().bind((ObservableValue)view.showPageSwitcherProperty());
        this.buildSwitcher();
        GridPane centerToolBarBox = new GridPane();
        GridPane.setHalignment((Node)this.switcher, (HPos)HPos.CENTER);
        GridPane.setValignment((Node)this.switcher, (VPos)VPos.CENTER);
        centerToolBarBox.add((Node)this.switcher, 0, 0);
        centerToolBarBox.setAlignment(Pos.CENTER);
        toolBarGridPane.add((Node)centerToolBarBox, 1, 0);
        this.trayButton.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SOURCE_TRAY")));
        this.addCalendarButton.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_ADD_CALENDAR")));
        this.printButton.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_PRINT")));
        this.showDay.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_DAY")));
        this.showWeek.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_WEEK")));
        this.showMonth.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_MONTH")));
        this.showYear.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_YEAR")));
        FontIcon searchIcon = new FontIcon((Ikon)FontAwesome.SEARCH);
        searchIcon.setId("search-icon");
        SortedList sortedZones = new SortedList(view.getAvailableZoneIds());
        sortedZones.setComparator((Comparator)new ZoneIdComparator());
        ChoiceBox zoneIdBox = new ChoiceBox();
        zoneIdBox.setItems((ObservableList)sortedZones);
        zoneIdBox.valueProperty().bindBidirectional(view.zoneIdProperty());
        zoneIdBox.setConverter((StringConverter)new ZoneIdStringConverter());
        zoneIdBox.visibleProperty().bind((ObservableValue)view.enableTimeZoneSupportProperty());
        zoneIdBox.managedProperty().bind((ObservableValue)view.enableTimeZoneSupportProperty());
        CustomTextField searchField = view.getSearchField();
        searchField.setPrefColumnCount(20);
        searchField.setLeft((Node)searchIcon);
        searchField.setId("search-field");
        searchField.setPromptText(Messages.getString("CalendarViewSkin.PROMPT_SEARCH_FIELD"));
        searchField.getStylesheets().add((Object)CalendarFXControl.class.getResource("calendar.css").toExternalForm());
        GridPane.setFillWidth((Node)searchField, (Boolean)false);
        GridPane.setHalignment((Node)searchField, (HPos)HPos.RIGHT);
        HBox rightToolbarContainer = new HBox(new Node[]{zoneIdBox, searchField});
        rightToolbarContainer.setAlignment(Pos.CENTER_RIGHT);
        rightToolbarContainer.getStyleClass().add((Object)"right-toolbar-container");
        toolBarGridPane.add((Node)rightToolbarContainer, 2, 0);
        BorderPane borderPane1 = new BorderPane();
        borderPane1.topProperty().bind(view.headerProperty());
        this.stackPane = new StackPane();
        borderPane1.setCenter((Node)this.stackPane);
        borderPane1.bottomProperty().bind(view.footerProperty());
        view.selectedPageProperty().addListener(it -> this.changePage());
        this.leftMasterDetailPane.setMasterNode((Node)borderPane1);
        this.leftMasterDetailPane.setDetailNode((Node)trayPane);
        this.leftMasterDetailPane.setId("tray-pane");
        this.leftMasterDetailPane.animatedProperty().bindBidirectional((Property)view.traysAnimatedProperty());
        this.leftMasterDetailPane.getStylesheets().add((Object)CalendarFXControl.class.getResource("calendar.css").toExternalForm());
        MasterDetailPane rightMasterDetailPane = new MasterDetailPane(Side.RIGHT);
        this.searchResultView = view.getSearchResultView();
        Bindings.bindContentBidirectional(this.searchResultView.getCalendarSources(), view.getCalendarSources());
        this.searchResultView.zoneIdProperty().bind(view.zoneIdProperty());
        this.searchResultView.searchTextProperty().bind((ObservableValue)searchField.textProperty());
        this.searchResultView.selectedEntryProperty().addListener(evt -> this.showSelectedSearchResult());
        view.showSearchResultsTrayProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)Bindings.isEmpty(this.searchResultView.getSearchResults())));
        rightMasterDetailPane.setDetailNode((Node)this.searchResultView);
        rightMasterDetailPane.setMasterNode((Node)this.leftMasterDetailPane);
        rightMasterDetailPane.showDetailNodeProperty().bind((ObservableValue)view.showSearchResultsTrayProperty());
        BorderPane borderPane = new BorderPane();
        if (view.isShowToolBar()) {
            borderPane.setTop((Node)toolBarGridPane);
        }
        view.showToolBarProperty().addListener(it -> {
            if (view.isShowToolBar()) {
                borderPane.setTop((Node)toolBarGridPane);
            } else {
                borderPane.setTop(null);
            }
        });
        borderPane.setCenter((Node)rightMasterDetailPane);
        if (Boolean.getBoolean("calendarfx.developer")) {
            DeveloperConsole developerConsole = view.getDeveloperConsole();
            MasterDetailPane developerConsoleMasterDetailPane = new MasterDetailPane(Side.BOTTOM);
            developerConsoleMasterDetailPane.setDividerPosition(0.6);
            developerConsoleMasterDetailPane.animatedProperty().bind((ObservableValue)view.traysAnimatedProperty());
            developerConsoleMasterDetailPane.getStyleClass().add((Object)"developer-master-detail-pane");
            developerConsoleMasterDetailPane.setDetailSide(Side.BOTTOM);
            developerConsoleMasterDetailPane.setMasterNode((Node)borderPane);
            developerConsoleMasterDetailPane.setDetailNode((Node)developerConsole);
            developerConsoleMasterDetailPane.setShowDetailNode(true);
            developerConsoleMasterDetailPane.showDetailNodeProperty().bind((ObservableValue)view.showDeveloperConsoleProperty());
            developerConsoleMasterDetailPane.getStylesheets().add((Object)CalendarFXControl.class.getResource("calendar.css").toExternalForm());
            this.getChildren().add((Object)developerConsoleMasterDetailPane);
        } else {
            this.getChildren().add((Object)borderPane);
        }
        PageBase selectedPage = view.getSelectedPageView();
        selectedPage.toFront();
        this.updateToggleButtons();
    }

    private void maybeRunAndConsume(RequestEvent evt, Consumer<RequestEvent> consumer) {
        if (!evt.isConsumed()) {
            consumer.accept(evt);
            evt.consume();
        }
    }

    private void openTray() {
        this.leftMasterDetailPane.resetDividerPosition();
        this.leftMasterDetailPane.setShowDetailNode(true);
    }

    private void closeTray() {
        this.leftMasterDetailPane.setShowDetailNode(false);
    }

    private void updateCalendarVisibility() {
        CalendarView view = (CalendarView)this.getSkinnable();
        if (view.getSelectedPage().equals((Object)CalendarView.Page.DAY)) {
            view.getDayPage().refreshData();
        } else if (view.getSelectedPage().equals((Object)CalendarView.Page.WEEK)) {
            view.getWeekPage().refreshData();
        }
    }

    private void updatePrintVisibility() {
        PrintablePage printablePage = this.printView.getPreviewPane().getPrintablePage();
        if (printablePage.getViewType() == ViewType.DAY_VIEW) {
            printablePage.getDayView().refreshData();
        } else if (printablePage.getViewType() == ViewType.WEEK_VIEW) {
            printablePage.getWeekView().refreshData();
        }
    }

    private void buildSwitcher() {
        CalendarView view = (CalendarView)this.getSkinnable();
        this.switcher.getButtons().clear();
        if (view.getAvailablePages().contains((Object)CalendarView.Page.DAY)) {
            this.switcher.getButtons().add((Object)this.showDay);
        }
        if (view.getAvailablePages().contains((Object)CalendarView.Page.WEEK)) {
            this.switcher.getButtons().add((Object)this.showWeek);
        }
        if (view.getAvailablePages().contains((Object)CalendarView.Page.MONTH)) {
            this.switcher.getButtons().add((Object)this.showMonth);
        }
        if (view.getAvailablePages().contains((Object)CalendarView.Page.YEAR)) {
            this.switcher.getButtons().add((Object)this.showYear);
        }
        if (this.switcher.getButtons().size() == 1) {
            this.switcher.getButtons().clear();
        }
    }

    private void buildLeftToolBarBox() {
        this.leftToolBarBox.getChildren().clear();
        if (((CalendarView)this.getSkinnable()).isShowSourceTrayButton()) {
            this.leftToolBarBox.getChildren().add((Object)this.trayButton);
        }
        if (((CalendarView)this.getSkinnable()).isShowAddCalendarButton()) {
            this.leftToolBarBox.getChildren().add((Object)this.addCalendarButton);
        }
        if (!this.leftToolBarBox.getChildren().isEmpty() && ((CalendarView)this.getSkinnable()).isShowPrintButton()) {
            this.leftToolBarBox.getChildren().add((Object)new Separator(Orientation.VERTICAL));
        }
        if (((CalendarView)this.getSkinnable()).isShowPrintButton()) {
            this.leftToolBarBox.getChildren().add((Object)this.printButton);
        }
        if (((CalendarView)this.getSkinnable()).isShowPageToolBarControls()) {
            CalendarView.Page page = ((CalendarView)this.getSkinnable()).getSelectedPage();
            Node toolBarControls = ((CalendarView)this.getSkinnable()).getPageView(page).getToolBarControls();
            if (!(toolBarControls == null || toolBarControls instanceof Pane && ((Pane)toolBarControls).getChildrenUnmodifiable().isEmpty())) {
                if (!this.leftToolBarBox.getChildren().isEmpty()) {
                    this.leftToolBarBox.getChildren().add((Object)new Separator(Orientation.VERTICAL));
                }
                this.leftToolBarBox.getChildren().add((Object)toolBarControls);
            }
        }
    }

    private void changePage() {
        CalendarView view = (CalendarView)this.getSkinnable();
        this.updateToggleButtons();
        this.stackPane.getChildren().setAll((Object[])new Node[]{view.getSelectedPageView()});
    }

    private void updateToggleButtons() {
        CalendarView view = (CalendarView)this.getSkinnable();
        CalendarView.Page page = view.getSelectedPage();
        if (page.equals((Object)CalendarView.Page.DAY)) {
            this.showDay.setSelected(true);
        } else if (page.equals((Object)CalendarView.Page.WEEK)) {
            this.showWeek.setSelected(true);
        } else if (page.equals((Object)CalendarView.Page.MONTH)) {
            this.showMonth.setSelected(true);
        } else if (page.equals((Object)CalendarView.Page.YEAR)) {
            this.showYear.setSelected(true);
        }
        this.stackPane.getChildren().setAll((Object[])new Node[]{view.getSelectedPageView()});
    }

    private void showSelectedSearchResult() {
        Entry<?> result = this.searchResultView.getSelectedEntry();
        if (result != null) {
            ((CalendarView)this.getSkinnable()).showEntry(result);
        }
    }

    private void print() {
        if (this.printView == null) {
            this.printView = ((CalendarView)this.getSkinnable()).getPrintView();
            this.printView.dateProperty().bind(((CalendarView)this.getSkinnable()).dateProperty());
            this.printView.zoneIdProperty().bind(((CalendarView)this.getSkinnable()).zoneIdProperty());
        }
        this.printView.setToday(((CalendarView)this.getSkinnable()).getToday());
        this.printView.getPreviewPane().getPrintablePage().setPageStartDate(((CalendarView)this.getSkinnable()).getDate());
        this.printView.setWeekFields(((CalendarView)this.getSkinnable()).getWeekFields());
        this.printView.getCalendarSources().setAll(((CalendarView)this.getSkinnable()).getCalendarSources());
        this.printView.setLayout(((CalendarView)this.getSkinnable()).getSelectedPageView().getLayout());
        this.printView.setViewType(((CalendarView)this.getSkinnable()).getSelectedPageView().getPrintViewType());
        this.printView.loadDropDownValues(((CalendarView)this.getSkinnable()).getDate());
        this.printView.show(((CalendarView)this.getSkinnable()).getScene().getWindow());
        Platform.runLater(() -> {
            SourceView printSource = this.printView.getSettingsView().getSourceView();
            for (Calendar calendar : printSource.getCalendarVisibilityMap().keySet()) {
                printSource.getCalendarVisibilityProperty(calendar).removeListener(this.weakPrintEntriesVisibilityListener);
                printSource.getCalendarVisibilityProperty(calendar).addListener(this.weakPrintEntriesVisibilityListener);
            }
        });
    }

    class TrayPane
    extends BorderPane {
        private final YearMonthView yearMonthView;

        public TrayPane() {
            CalendarViewSkin.this.sourceView = ((CalendarView)CalendarViewSkin.this.getSkinnable()).getSourceView();
            CalendarViewSkin.this.sourceView.bind((DateControl)CalendarViewSkin.this.getSkinnable());
            this.yearMonthView = ((CalendarView)CalendarViewSkin.this.getSkinnable()).getYearMonthView();
            this.yearMonthView.setShowToday(true);
            this.yearMonthView.setShowTodayButton(false);
            this.yearMonthView.setId("date-picker");
            this.yearMonthView.setSelectionMode(SelectionMode.SINGLE);
            this.yearMonthView.setClickBehaviour(YearMonthView.ClickBehaviour.PERFORM_SELECTION);
            this.yearMonthView.getSelectedDates().add((Object)((CalendarView)CalendarViewSkin.this.getSkinnable()).getDate());
            this.yearMonthView.getSelectedDates().addListener(evt -> {
                if (!this.yearMonthView.getSelectedDates().isEmpty()) {
                    this.yearMonthView.setDate((LocalDate)this.yearMonthView.getSelectedDates().iterator().next());
                }
            });
            ((CalendarView)CalendarViewSkin.this.getSkinnable()).dateProperty().addListener(it -> {
                this.yearMonthView.getSelectedDates().clear();
                this.yearMonthView.getSelectedDates().add((Object)((CalendarView)CalendarViewSkin.this.getSkinnable()).getDate());
            });
            Bindings.bindBidirectional(this.yearMonthView.todayProperty(), ((CalendarView)CalendarViewSkin.this.getSkinnable()).todayProperty());
            Bindings.bindBidirectional(this.yearMonthView.dateProperty(), ((CalendarView)CalendarViewSkin.this.getSkinnable()).dateProperty());
            this.yearMonthView.weekFieldsProperty().bind(((CalendarView)CalendarViewSkin.this.getSkinnable()).weekFieldsProperty());
            ScrollPane scrollPane = new ScrollPane((Node)CalendarViewSkin.this.sourceView);
            scrollPane.getStyleClass().add((Object)"source-view-scroll-pane");
            this.setCenter((Node)scrollPane);
            this.setBottom((Node)this.yearMonthView);
        }
    }
}

