/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.model.LoadEvent;
import com.calendarfx.util.LoggingDomain;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.event.Event;

public final class DataLoader {
    private final LoadDataSettingsProvider provider;

    public DataLoader(LoadDataSettingsProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public void loadEntries(Map<LocalDate, List<Entry<?>>> result) {
        long time = System.currentTimeMillis();
        LocalDate startDate = this.provider.getLoadStartDate();
        LocalDate endDate = this.provider.getLoadEndDate();
        ZoneId zoneId = this.provider.getZoneId();
        for (CalendarSource calendarSource : this.provider.getCalendarSources()) {
            for (Calendar calendar : calendarSource.getCalendars().stream().filter(c -> this.provider.isCalendarVisible((Calendar)c)).collect(Collectors.toList())) {
                try {
                    Map<LocalDate, List<Entry<?>>> entries = calendar.findEntries(startDate, endDate, zoneId);
                    for (LocalDate date : entries.keySet()) {
                        List list = result.computeIfAbsent(date, it -> new ArrayList());
                        List<Entry<?>> dateEntries = entries.get(date);
                        if (dateEntries == null) continue;
                        for (Entry<?> entry : dateEntries) {
                            if (entry == null) {
                                if (!LoggingDomain.MODEL.isLoggable(Level.SEVERE)) continue;
                                LoggingDomain.MODEL.severe("the calendar " + calendar.getName() + " (source " + calendarSource.getName() + ") returned a NULL entry");
                                continue;
                            }
                            list.add(entry);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (List list : result.values()) {
            Collections.sort(list);
        }
        LoggingDomain.PERFORMANCE.fine("data load time: " + (System.currentTimeMillis() - time) + ", view = " + this.provider.getClass().getSimpleName());
        this.provider.getControl().fireEvent((Event)new LoadEvent(LoadEvent.LOAD, this.provider.getLoaderName(), this.provider.getCalendarSources(), startDate, endDate, zoneId));
    }
}

