/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DraggedEntry;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.util.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;

public abstract class DateControlSkin<C extends DateControl>
extends SkinBase<C> {
    private final InvalidationListener calendarVisibilityListener = it -> this.calendarVisibilityChanged();
    private final WeakInvalidationListener weakCalendarVisibilityListener = new WeakInvalidationListener(this.calendarVisibilityListener);
    private final EventHandler<CalendarEvent> calendarListener = this::calendarChanged;
    private final WeakEventHandler<CalendarEvent> weakCalendarListener = new WeakEventHandler(this.calendarListener);

    public DateControlSkin(C control) {
        super(control);
        ((DateControl)((Object)control)).zoneIdProperty().addListener(it -> this.zoneIdChanged());
        control.addEventHandler(MouseEvent.MOUSE_PRESSED, evt -> control.clearSelection());
        ((DateControl)((Object)control)).getCalendars().addListener(this::calendarListChanged);
        for (Calendar calendar : ((DateControl)((Object)control)).getCalendars()) {
            calendar.addEventHandler((EventHandler<CalendarEvent>)this.weakCalendarListener);
        }
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded() && change.getKey().equals("refresh.data")) {
                LoggingDomain.VIEW.fine("data refresh was requested by the application");
                control.getProperties().remove((Object)"refresh.data");
                this.refreshData();
            }
        };
        control.getProperties().addListener(propertiesListener);
        for (Calendar calendar : ((DateControl)((Object)control)).getCalendars()) {
            ((DateControl)((Object)control)).getCalendarVisibilityProperty(calendar).addListener((InvalidationListener)this.weakCalendarVisibilityListener);
        }
        ((DateControl)((Object)control)).getCalendars().addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Calendar calendar : change.getAddedSubList()) {
                        control.getCalendarVisibilityProperty(calendar).addListener((InvalidationListener)this.weakCalendarVisibilityListener);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (Calendar calendar : change.getRemoved()) {
                    control.getCalendarVisibilityProperty(calendar).removeListener((InvalidationListener)this.weakCalendarVisibilityListener);
                }
            }
        });
    }

    protected void refreshData() {
    }

    protected void calendarVisibilityChanged() {
    }

    private void calendarListChanged(ListChangeListener.Change<? extends Calendar> change) {
        DateControl dateControl = (DateControl)this.getSkinnable();
        while (change.next()) {
            if (change.wasAdded()) {
                for (Calendar calendar : change.getAddedSubList()) {
                    calendar.addEventHandler((EventHandler<CalendarEvent>)this.weakCalendarListener);
                    dateControl.getCalendarVisibilityProperty(calendar).addListener((InvalidationListener)this.weakCalendarVisibilityListener);
                }
                continue;
            }
            if (!change.wasRemoved()) continue;
            for (Calendar calendar : change.getRemoved()) {
                calendar.removeEventHandler((EventHandler<CalendarEvent>)this.weakCalendarListener);
                dateControl.getCalendarVisibilityProperty(calendar).removeListener((InvalidationListener)this.weakCalendarVisibilityListener);
            }
        }
    }

    protected void zoneIdChanged() {
    }

    private void calendarChanged(CalendarEvent evt) {
        if (LoggingDomain.EVENTS.isLoggable(Level.FINE) && !(evt.getEntry() instanceof DraggedEntry)) {
            LoggingDomain.EVENTS.fine("calendar event in " + ((Object)((Object)((DateControl)this.getSkinnable()))).getClass().getSimpleName() + ": " + evt.getEventType() + ", details: " + evt);
        }
        if (((DateControl)this.getSkinnable()).isSuspendUpdates()) {
            return;
        }
        if (evt.getEventType().getSuperType().equals(CalendarEvent.ENTRY_CHANGED) && evt.getEntry().isRecurrence()) {
            return;
        }
        Util.runInFXThread(() -> {
            EventType eventType = evt.getEventType();
            if (eventType.equals(CalendarEvent.ENTRY_INTERVAL_CHANGED)) {
                this.entryIntervalChanged(evt);
            } else if (eventType.equals(CalendarEvent.ENTRY_FULL_DAY_CHANGED)) {
                this.entryFullDayChanged(evt);
            } else if (eventType.equals(CalendarEvent.ENTRY_RECURRENCE_RULE_CHANGED)) {
                this.entryRecurrenceRuleChanged(evt);
            } else if (eventType.equals(CalendarEvent.ENTRY_CALENDAR_CHANGED)) {
                this.entryCalendarChanged(evt);
            } else if (eventType.equals(CalendarEvent.ENTRY_TITLE_CHANGED)) {
                this.entryTitleChanged(evt);
            } else if (eventType.equals(CalendarEvent.ENTRY_LOCATION_CHANGED)) {
                this.entryLocationChanged(evt);
            } else if (eventType.equals(CalendarEvent.ENTRY_USER_OBJECT_CHANGED)) {
                this.entryUserObjectChanged(evt);
            } else if (eventType.equals(CalendarEvent.CALENDAR_CHANGED)) {
                this.calendarChanged(evt.getCalendar());
            }
        });
    }

    protected void entryIntervalChanged(CalendarEvent evt) {
    }

    protected void entryFullDayChanged(CalendarEvent evt) {
    }

    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
    }

    protected void entryCalendarChanged(CalendarEvent evt) {
    }

    protected void entryTitleChanged(CalendarEvent evt) {
    }

    protected void entryLocationChanged(CalendarEvent evt) {
    }

    protected void entryUserObjectChanged(CalendarEvent evt) {
    }

    protected void calendarChanged(Calendar calendar) {
    }

    protected boolean isRelevant(Entry<?> entry) {
        if (this instanceof LoadDataSettingsProvider) {
            DateControl dateControl = (DateControl)this.getSkinnable();
            if (!(entry instanceof DraggedEntry) && !dateControl.isCalendarVisible(entry.getCalendar())) {
                return false;
            }
            LoadDataSettingsProvider provider = (LoadDataSettingsProvider)((Object)this);
            ZoneId zoneId = ((DateControl)this.getSkinnable()).getZoneId();
            LocalDate loadStartDate = provider.getLoadStartDate();
            LocalDate loadEndDate = provider.getLoadEndDate();
            return entry.isShowing(loadStartDate, loadEndDate, zoneId);
        }
        return false;
    }

    protected boolean isRelevant(Interval interval) {
        LoadDataSettingsProvider provider = (LoadDataSettingsProvider)((Object)this);
        ZoneId zoneId = ((DateControl)this.getSkinnable()).getZoneId();
        LocalDate loadStartDate = provider.getLoadStartDate();
        LocalDate loadEndDate = provider.getLoadEndDate();
        ZonedDateTime st = ZonedDateTime.of(loadStartDate, LocalTime.MIN, zoneId);
        ZonedDateTime et = ZonedDateTime.of(loadEndDate, LocalTime.MAX, zoneId);
        return Util.intersect(interval.getStartZonedDateTime(), interval.getEndZonedDateTime(), st, et);
    }
}

