/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DraggedEntry;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.FlowPane;
import javafx.scene.shape.Rectangle;

public class DayEntryViewSkin
extends SkinBase<DayEntryView> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
    protected Label startTimeLabel;
    protected Label titleLabel;
    private final InvalidationListener updateStylesListener = it -> this.updateStyles();
    private final WeakInvalidationListener weakUpdateStylesListener = new WeakInvalidationListener(this.updateStylesListener);
    private final InvalidationListener updateLabelsListener = it -> this.updateLabels();
    private final WeakInvalidationListener weakUpdateLabelsListener = new WeakInvalidationListener(this.updateLabelsListener);
    private Map<Pos, FlowPane> nodePanes;

    public DayEntryViewSkin(DayEntryView view) {
        super((Control)view);
        this.startTimeLabel = this.createStartTimeLabel();
        this.startTimeLabel.setManaged(false);
        this.startTimeLabel.setMouseTransparent(true);
        this.titleLabel = this.createTitleLabel();
        this.titleLabel.setManaged(false);
        this.titleLabel.setMouseTransparent(true);
        this.getChildren().addAll((Object[])new Node[]{this.startTimeLabel, this.titleLabel});
        Entry<?> entry = this.getEntry();
        entry.intervalProperty().addListener((InvalidationListener)this.weakUpdateLabelsListener);
        entry.calendarProperty().addListener((InvalidationListener)this.weakUpdateStylesListener);
        entry.titleProperty().addListener((InvalidationListener)this.weakUpdateLabelsListener);
        ((DayEntryView)this.getSkinnable()).positionProperty().addListener((InvalidationListener)this.weakUpdateLabelsListener);
        this.updateLabels();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)view.widthProperty());
        clip.heightProperty().bind((ObservableValue)view.heightProperty());
        view.setClip((Node)clip);
        view.nodesProperty().addListener(it -> this.updateNodes());
        this.updateStyles();
        this.updateNodes();
    }

    private void updateNodes() {
        DayEntryView view = (DayEntryView)this.getSkinnable();
        ObservableMap<Pos, List<Node>> nodes = view.getNodes();
        if (nodes != null) {
            Set<Pos> previouslyUsedPositions = null;
            if (this.nodePanes != null) {
                previouslyUsedPositions = this.nodePanes.keySet();
            }
            Set currentlyUsedPositions = nodes.keySet();
            if (previouslyUsedPositions != null) {
                previouslyUsedPositions.removeAll(currentlyUsedPositions);
                for (Pos next : previouslyUsedPositions) {
                    FlowPane removedPane = this.nodePanes.remove(next);
                    this.getChildren().remove((Object)removedPane);
                }
            }
            currentlyUsedPositions.forEach(pos -> this.createPosition((Pos)pos, (List)nodes.get(pos)));
        }
        if (this.nodePanes != null && this.nodePanes.isEmpty()) {
            this.nodePanes = null;
        }
    }

    private void createPosition(Pos pos, List<Node> nodes) {
        if (this.nodePanes == null) {
            this.nodePanes = new HashMap<Pos, FlowPane>();
        }
        FlowPane flowPane = this.nodePanes.computeIfAbsent(pos, p -> {
            FlowPane pane = new FlowPane();
            pane.getStyleClass().add((Object)"icon-flow-pane");
            pane.setPrefWidth(-1.0);
            pane.setPrefHeight(-1.0);
            pane.setManaged(false);
            pane.setMouseTransparent(true);
            switch (pos) {
                case TOP_CENTER: 
                case BOTTOM_LEFT: 
                case BASELINE_LEFT: 
                case BOTTOM_CENTER: 
                case BASELINE_CENTER: 
                case BOTTOM_RIGHT: 
                case BASELINE_RIGHT: 
                case CENTER: {
                    pane.setOrientation(Orientation.HORIZONTAL);
                    pane.prefWrapLengthProperty().bind((ObservableValue)((DayEntryView)this.getSkinnable()).widthProperty());
                    break;
                }
                case TOP_LEFT: 
                case TOP_RIGHT: 
                case CENTER_LEFT: 
                case CENTER_RIGHT: {
                    pane.setOrientation(Orientation.VERTICAL);
                    pane.prefWrapLengthProperty().bind((ObservableValue)((DayEntryView)this.getSkinnable()).heightProperty());
                }
            }
            pane.setAlignment(pos);
            this.getChildren().add((Object)pane);
            return pane;
        });
        flowPane.getChildren().setAll(nodes);
    }

    protected Entry<?> getEntry() {
        Entry<?> entry = ((DayEntryView)this.getSkinnable()).getEntry();
        if (entry.isRecurrence()) {
            entry = entry.getRecurrenceSourceEntry();
        }
        return entry;
    }

    protected void updateStyles() {
        DayEntryView view = (DayEntryView)this.getSkinnable();
        Entry<?> entry = this.getEntry();
        Calendar calendar = entry.getCalendar();
        if (entry instanceof DraggedEntry) {
            calendar = ((DraggedEntry)entry).getOriginalCalendar();
        }
        if (calendar == null) {
            return;
        }
        view.getStyleClass().setAll((Object[])new String[]{"default-style-entry", calendar.getStyle() + "-entry"});
        if (entry.isRecurrence()) {
            view.getStyleClass().add((Object)"recurrence");
        }
        view.getStyleClass().addAll(entry.getStyleClass());
        this.startTimeLabel.getStyleClass().setAll((Object[])new String[]{"start-time-label", "default-style-entry-time-label", calendar.getStyle() + "-entry-time-label"});
        this.titleLabel.getStyleClass().setAll((Object[])new String[]{"title-label", "default-style-entry-title-label", calendar.getStyle() + "-entry-title-label"});
    }

    protected Label createStartTimeLabel() {
        Label label = new Label();
        label.setMinSize(0.0, 0.0);
        return label;
    }

    protected String formatTime(ZonedDateTime time, ZoneId zoneId) {
        return this.formatter.format(time.withZoneSameInstant(zoneId));
    }

    protected String formatTitle(String title) {
        return title;
    }

    protected Label createTitleLabel() {
        Label label = new Label();
        label.setWrapText(true);
        label.setMinSize(0.0, 0.0);
        return label;
    }

    protected void updateLabels() {
        Entry<?> entry = this.getEntry();
        DayView dateControl = (DayView)((DayEntryView)this.getSkinnable()).getDateControl();
        ZonedDateTime startTime = entry.getStartAsZonedDateTime();
        if (!Objects.equals(dateControl.getZoneId(), entry.getZoneId())) {
            this.startTimeLabel.setText(this.formatTime(startTime, dateControl.getZoneId()) + " (" + this.formatTime(startTime, entry.getZoneId()) + " " + entry.getZoneId().getDisplayName(TextStyle.SHORT, Locale.getDefault()) + ")");
        } else {
            this.startTimeLabel.setText(this.formatTime(startTime, dateControl.getZoneId()));
        }
        this.titleLabel.setText(this.formatTitle(entry.getTitle()));
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double titleHeight = this.titleLabel.prefHeight(contentWidth);
        this.titleLabel.resizeRelocate(this.snapPositionX(contentX), this.snapPositionY(contentY), this.snapSizeX(contentWidth), this.snapSizeY(titleHeight));
        double timeLabelHeight = this.startTimeLabel.prefHeight(contentWidth);
        if (contentHeight - titleHeight > timeLabelHeight) {
            this.startTimeLabel.setVisible(true);
            this.startTimeLabel.resizeRelocate(this.snapPositionX(contentX), this.snapPositionY(contentY + titleHeight), this.snapSizeX(contentWidth), this.snapSizeY(timeLabelHeight));
        } else {
            this.startTimeLabel.setVisible(false);
        }
        if (this.nodePanes != null) {
            this.nodePanes.keySet().forEach(pos -> this.layoutNodesPane((Pos)pos, this.nodePanes.get(pos), contentX, contentY, contentWidth, contentHeight));
        }
    }

    private void layoutNodesPane(Pos pos, FlowPane flowPane, double x, double y, double w, double h) {
        double pw = flowPane.prefWidth(-1.0);
        double ph = flowPane.prefHeight(-1.0);
        switch (pos) {
            case TOP_LEFT: {
                flowPane.resizeRelocate(x, y, pw, ph);
                break;
            }
            case TOP_CENTER: {
                flowPane.resizeRelocate(x + w / 2.0 - pw / 2.0, y, pw, ph);
                break;
            }
            case TOP_RIGHT: {
                flowPane.resizeRelocate(x + w - pw, y, pw, ph);
                break;
            }
            case BOTTOM_LEFT: 
            case BASELINE_LEFT: {
                flowPane.resizeRelocate(x, h - ph, pw, ph);
                break;
            }
            case BOTTOM_CENTER: 
            case BASELINE_CENTER: {
                flowPane.resizeRelocate(x + w / 2.0 - pw / 2.0, h - ph, pw, ph);
                break;
            }
            case BOTTOM_RIGHT: 
            case BASELINE_RIGHT: {
                flowPane.resizeRelocate(x + w - pw, h - ph, pw, ph);
                break;
            }
            case CENTER_LEFT: {
                flowPane.resizeRelocate(x, y + h / 2.0 - ph / 2.0, pw, ph);
                break;
            }
            case CENTER: {
                flowPane.resizeRelocate(x + w / 2.0 - pw / 2.0, y + h / 2.0 - ph / 2.0, pw, ph);
                break;
            }
            case CENTER_RIGHT: {
                flowPane.resizeRelocate(x + w - pw, y + h / 2.0 - ph / 2.0, pw, ph);
            }
        }
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.titleLabel != null && ((DayEntryView)this.getSkinnable()).isMinHeightEqualToTitleHeight()) {
            return this.titleLabel.prefHeight(-1.0) + topInset + bottomInset;
        }
        return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

