/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayViewBase;
import impl.com.calendarfx.view.DateControlSkin;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;

public class DayViewBaseSkin<T extends DayViewBase>
extends DateControlSkin<T> {
    private final InvalidationListener layoutListener = it -> ((DayViewBase)this.getSkinnable()).requestLayout();

    public DayViewBaseSkin(T view) {
        super(view);
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).timeProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).hourHeightProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).hourHeightCompressedProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).visibleHoursProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).earlyLateHoursStrategyProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).hoursLayoutStrategyProperty());
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).startTimeProperty());
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).endTimeProperty());
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).getCalendars());
        this.registerLayoutListener((Observable)((DayViewBase)view).enableCurrentTimeMarkerProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).entryWidthPercentageProperty());
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).showTodayProperty());
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).zoneIdProperty());
        this.registerLayoutListener((Observable)((DateControl)((Object)view)).editAvailabilityProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).scrollingEnabledProperty());
        this.registerLayoutListener((Observable)((DayViewBase)view).gridTypeProperty());
        view.setOnScroll(evt -> {
            double oldLocation = evt.getY();
            ZonedDateTime time = view.getZonedDateTimeAt(0.0, oldLocation, view.getZoneId());
            if (view.isScrollingEnabled()) {
                if (evt.isShortcutDown()) {
                    double delta = Math.max(-5.0, Math.min(5.0, evt.getDeltaY()));
                    view.setHourHeight(Math.min(((DayViewBase)this.getSkinnable()).getMaxHourHeight(), Math.max(((DayViewBase)this.getSkinnable()).getMinHourHeight(), view.getHourHeight() + delta)));
                    double newLocation = view.getLocation(time);
                    double locationDelta = newLocation - oldLocation;
                    ZonedDateTime newScrollTime = view.getZonedDateTimeAt(0.0, locationDelta, view.getZoneId());
                    view.setScrollTime(newScrollTime);
                } else {
                    view.setScrollTime(((DayViewBase)this.getSkinnable()).getZonedDateTimeAt(0.0, -evt.getDeltaY(), view.getZoneId()));
                }
            }
        });
    }

    private void registerLayoutListener(Observable obs) {
        obs.addListener(this.layoutListener);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((DayViewBase)this.getSkinnable()).isScrollingEnabled()) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        DayViewBase dayView = (DayViewBase)this.getSkinnable();
        double hourHeight = dayView.getHourHeight();
        DayViewBase.EarlyLateHoursStrategy strategy = dayView.getEarlyLateHoursStrategy();
        switch (strategy) {
            case HIDE: {
                long earlyHours = ChronoUnit.HOURS.between(LocalTime.MIN, dayView.getStartTime());
                long lateHours = ChronoUnit.HOURS.between(dayView.getEndTime(), LocalTime.MAX) + 1L;
                long hours = 24L - earlyHours - lateHours;
                return (double)hours * hourHeight;
            }
            case SHOW: {
                return 24.0 * hourHeight;
            }
            case SHOW_COMPRESSED: {
                long earlyHours = ChronoUnit.HOURS.between(LocalTime.MIN, dayView.getStartTime());
                long lateHours = ChronoUnit.HOURS.between(dayView.getEndTime(), LocalTime.MAX) + 1L;
                long hours = 24L - earlyHours - lateHours;
                double hourHeightCompressed = dayView.getHourHeightCompressed();
                return (double)hours * hourHeight + (double)(earlyHours + lateHours) * hourHeightCompressed;
            }
        }
        throw new IllegalArgumentException("unsupported early / late hours strategy: " + strategy);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((DayViewBase)this.getSkinnable()).isScrollingEnabled()) {
            return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((DayViewBase)this.getSkinnable()).isScrollingEnabled()) {
            return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

