/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.util.LoggingDomain;
import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.DayViewBase;
import java.time.LocalTime;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class DayViewScrollPane
extends Pane {
    private final DayViewBase dayView;
    private final ScrollBar scrollBar;
    private LocalTime cachedStartTime;
    private final InvalidationListener scrollBarListener = it -> this.getDayView().setTranslateY(this.getScrollBar().getValue() * -1.0);
    private final InvalidationListener translateYListener = it -> {
        this.updateVisibleTimeRange("translate-y changed");
        this.cachedStartTime = this.getStartTime();
        this.getScrollBar().setValue(-this.getDayView().getTranslateY());
    };
    private final InvalidationListener sceneChangedListener = it -> this.updateVisibleTimeRange("scene changed");
    private final InvalidationListener scrollPaneHeightChangedListener = it -> this.updateVisibleTimeRange("height of scrollpane changed");
    private final InvalidationListener dayViewHeightChangedListener = it -> this.updateVisibleTimeRange("height of day view changed");
    private final InvalidationListener visibleHoursChangedListener = it -> this.updateVisibleTimeRange("visible hours changed");
    private final InvalidationListener layoutListener = it -> this.requestLayout();
    private final WeakInvalidationListener weakScrollBarListener = new WeakInvalidationListener(this.scrollBarListener);
    private final WeakInvalidationListener weakTranslateYListener = new WeakInvalidationListener(this.translateYListener);
    private final WeakInvalidationListener weakSceneChangedListener = new WeakInvalidationListener(this.sceneChangedListener);
    private final WeakInvalidationListener weakScrollPaneHeightChangedListener = new WeakInvalidationListener(this.scrollPaneHeightChangedListener);
    private final WeakInvalidationListener weakDayViewHeightChangedListener = new WeakInvalidationListener(this.dayViewHeightChangedListener);
    private final WeakInvalidationListener weakVisibleHoursChangedListener = new WeakInvalidationListener(this.visibleHoursChangedListener);
    private final WeakInvalidationListener weakLayoutListener = new WeakInvalidationListener(this.layoutListener);
    private final ReadOnlyObjectWrapper<LocalTime> startTime = new ReadOnlyObjectWrapper((Object)this, "startTime", (Object)LocalTime.MIN);
    private final ReadOnlyObjectWrapper<LocalTime> endTime = new ReadOnlyObjectWrapper((Object)this, "endTime", (Object)LocalTime.MIN);
    private ScrollThread scrollThread;

    public DayViewScrollPane(DayViewBase dayView, ScrollBar scrollBar) {
        this.dayView = Objects.requireNonNull(dayView);
        this.dayView.setManaged(false);
        this.dayView.layoutBoundsProperty().addListener((InvalidationListener)this.weakLayoutListener);
        this.scrollBar = Objects.requireNonNull(scrollBar);
        scrollBar.setOrientation(Orientation.VERTICAL);
        scrollBar.maxProperty().bind((ObservableValue)dayView.heightProperty().subtract((ObservableNumberValue)this.heightProperty()));
        scrollBar.visibleAmountProperty().bind((ObservableValue)Bindings.multiply((ObservableNumberValue)scrollBar.maxProperty(), (ObservableNumberValue)Bindings.divide((ObservableNumberValue)this.heightProperty(), (ObservableNumberValue)dayView.heightProperty())));
        scrollBar.valueProperty().addListener((InvalidationListener)this.weakScrollBarListener);
        scrollBar.unitIncrementProperty().bind((ObservableValue)dayView.hourHeightProperty());
        scrollBar.blockIncrementProperty().bind((ObservableValue)this.heightProperty().divide(2));
        dayView.translateYProperty().addListener((InvalidationListener)this.weakTranslateYListener);
        this.getChildren().add((Object)dayView);
        this.heightProperty().addListener((InvalidationListener)this.weakScrollPaneHeightChangedListener);
        dayView.sceneProperty().addListener((InvalidationListener)this.weakSceneChangedListener);
        dayView.heightProperty().addListener((InvalidationListener)this.weakDayViewHeightChangedListener);
        dayView.visibleHoursProperty().addListener((InvalidationListener)this.weakVisibleHoursChangedListener);
        dayView.earlyLateHoursStrategyProperty().addListener((InvalidationListener)this.weakLayoutListener);
        dayView.hourHeightCompressedProperty().addListener((InvalidationListener)this.weakLayoutListener);
        dayView.hoursLayoutStrategyProperty().addListener((InvalidationListener)this.weakLayoutListener);
        dayView.hourHeightProperty().addListener((InvalidationListener)this.weakLayoutListener);
        this.updateVisibleTimeRange("initial call");
        this.addEventFilter(ScrollEvent.SCROLL, evt -> {
            this.scrollY(evt.getDeltaY());
            evt.consume();
        });
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::autoscrollIfNeeded);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_EXITED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_DROPPED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_DONE, evt -> this.stopAutoScrollIfNeeded());
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
    }

    private void scrollY(double deltaY) {
        Insets insets = this.getInsets();
        this.dayView.setTranslateY(Math.min(0.0, Math.max(this.dayView.getTranslateY() + deltaY, this.getMaxTranslateY(insets))));
    }

    public void scrollToTime(LocalTime time) {
        double y = ViewHelper.getTimeLocation(this.dayView, time, true);
        Insets insets = this.getInsets();
        if (y < Math.abs(this.dayView.getTranslateY()) || y > Math.abs(this.dayView.getTranslateY()) + this.getHeight()) {
            this.dayView.setTranslateY(Math.min(0.0, Math.max(-y + this.getHeight() / 3.0, this.getMaxTranslateY(insets))));
        }
    }

    private void updateVisibleTimeRange(String reason) {
        LoggingDomain.VIEW.fine("reason for updating visible time range: " + reason);
        if (this.dayView.getScene() == null || this.dayView.getHeight() == 0.0) {
            return;
        }
        LocalTime startTime = this.dayView.getZonedDateTimeAt(0.0, -this.dayView.getTranslateY()).toLocalTime();
        LocalTime endTime = this.dayView.getZonedDateTimeAt(0.0, -this.dayView.getTranslateY() + this.getHeight()).toLocalTime();
        this.startTime.set((Object)startTime);
        this.endTime.set((Object)endTime);
    }

    public final ReadOnlyObjectProperty<LocalTime> startTimeProperty() {
        return this.startTime.getReadOnlyProperty();
    }

    public final LocalTime getStartTime() {
        return (LocalTime)this.startTime.get();
    }

    public final ReadOnlyObjectProperty<LocalTime> endTimeProperty() {
        return this.endTime.getReadOnlyProperty();
    }

    public final LocalTime getEndTime() {
        return (LocalTime)this.endTime.get();
    }

    public final DayViewBase getDayView() {
        return this.dayView;
    }

    public final ScrollBar getScrollBar() {
        return this.scrollBar;
    }

    protected double computePrefWidth(double height) {
        return this.getDayView().prefWidth(-1.0);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        switch (this.dayView.getHoursLayoutStrategy()) {
            case FIXED_HOUR_COUNT: {
                double height = this.getHeight();
                int visibleHours = this.dayView.getVisibleHours();
                this.dayView.setHourHeight(Math.max(1.0, height / (double)visibleHours));
                break;
            }
        }
        Insets insets = this.getInsets();
        double ph = this.dayView.prefHeight(-1.0);
        this.dayView.resizeRelocate(this.snapPositionX(insets.getLeft()), this.snapPositionY(insets.getTop()), this.snapSizeX(this.getWidth() - insets.getLeft() - insets.getRight()), this.snapSizeY(Math.max(ph, this.getHeight() - insets.getTop() - insets.getBottom())));
        switch (this.dayView.getHoursLayoutStrategy()) {
            case FIXED_HOUR_COUNT: {
                if (this.cachedStartTime == null) break;
                this.dayView.setTranslateY(-ViewHelper.getTimeLocation(this.dayView, this.cachedStartTime, true));
                break;
            }
        }
        if (this.dayView.getTranslateY() + this.dayView.getHeight() < this.getHeight() - insets.getTop() - insets.getBottom()) {
            this.dayView.setTranslateY(this.getMaxTranslateY(insets));
        }
    }

    private double getMaxTranslateY(Insets insets) {
        return this.getHeight() - insets.getTop() - insets.getBottom() - this.dayView.getHeight();
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        double proximity;
        evt.acceptTransferModes(TransferMode.ANY);
        if (this.getBoundsInLocal().getWidth() < 1.0 && this.getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded();
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - this.localToScene(0.0, 0.0).getY();
        if (delta < (proximity = 20.0)) {
            yOffset = -(proximity - delta);
        }
        if ((delta = this.localToScene(0.0, 0.0).getY() + this.getHeight() - evt.getSceneY()) < proximity) {
            yOffset = proximity - delta;
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded();
        }
    }

    private void autoscrollIfNeeded(MouseEvent evt) {
        if (this.getBoundsInLocal().getWidth() < 1.0 && this.getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded();
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - this.localToScene(0.0, 0.0).getY();
        if (delta < 0.0) {
            yOffset = Math.max(delta / 2.0, -10.0);
        }
        if ((delta = this.localToScene(0.0, 0.0).getY() + this.getHeight() - evt.getSceneY()) < 0.0) {
            yOffset = Math.min(-delta / 2.0, 10.0);
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded();
        }
    }

    private void autoscroll(double yOffset) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
            this.scrollThread.start();
        }
        this.scrollThread.setDelta(yOffset);
    }

    private void stopAutoScrollIfNeeded() {
        if (this.scrollThread != null) {
            this.scrollThread.stopRunning();
            this.scrollThread = null;
        }
    }

    class ScrollThread
    extends Thread {
        private boolean running;
        private double yOffset;

        public ScrollThread() {
            super("Autoscrolling ScrollPane");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (this.running) {
                Platform.runLater(this::scrollToY);
                try {
                    ScrollThread.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void scrollToY() {
            DayViewScrollPane.this.scrollY(-this.yOffset);
        }

        public void stopRunning() {
            this.running = false;
        }

        public void setDelta(double yOffset) {
            this.yOffset = yOffset;
        }
    }
}

