/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.CalendarHeaderView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DetailedWeekView;
import com.calendarfx.view.Messages;
import com.calendarfx.view.WeekDayHeaderView;
import com.calendarfx.view.WeekTimeScaleView;
import com.calendarfx.view.WeekView;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.DayViewScrollPane;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class DetailedWeekViewSkin
extends DateControlSkin<DetailedWeekView> {
    private final Label allDayLabel;
    private final DayViewScrollPane weekViewScrollPane;
    private final DayViewScrollPane timeScaleScrollPane;
    private final GridPane weekViewContainer;
    private final AllDayView allDayView;
    private final CalendarHeaderView calendarHeaderView;
    private final WeekDayHeaderView weekdayHeaderView;
    private final ScrollBar scrollBar;
    private final Region weekdayFillerLeft;
    private final Region weekdayFillerRight;
    private final Region allDayFiller;

    public DetailedWeekViewSkin(DetailedWeekView view) {
        super(view);
        WeekView weekView = view.getWeekView();
        this.allDayView = view.getAllDayView();
        this.calendarHeaderView = view.getCalendarHeaderView();
        this.scrollBar = new ScrollBar();
        this.weekViewScrollPane = new DayViewScrollPane(weekView, this.scrollBar);
        this.weekViewScrollPane.getStyleClass().add((Object)"week-view-scroll-pane");
        this.allDayLabel = new Label(Messages.getString("DetailedWeekViewSkin.ALL_DAY"));
        this.allDayLabel.setTextOverrun(OverrunStyle.CLIP);
        this.allDayLabel.getStyleClass().add((Object)"all-day-label");
        this.allDayLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.weekdayFillerLeft = new Region();
        this.weekdayFillerLeft.getStyleClass().addAll((Object[])new String[]{"filler-left"});
        this.weekdayFillerRight = new Region();
        this.weekdayFillerRight.getStyleClass().addAll((Object[])new String[]{"filler-right"});
        this.allDayFiller = new Region();
        this.allDayFiller.getStyleClass().add((Object)"all-day-filler");
        WeekTimeScaleView timeScale = view.getTimeScaleView();
        timeScale.getProperties().put((Object)"week.view", (Object)view);
        this.timeScaleScrollPane = new DayViewScrollPane(timeScale, this.scrollBar);
        this.timeScaleScrollPane.getStyleClass().addAll((Object[])new String[]{"timescale-scroll-pane"});
        this.timeScaleScrollPane.setMinWidth(Double.NEGATIVE_INFINITY);
        Bindings.bindBidirectional((Property)timeScale.translateYProperty(), (Property)weekView.translateYProperty());
        this.weekdayHeaderView = view.getWeekDayHeaderView();
        RowConstraints row0 = new RowConstraints();
        row0.setFillHeight(true);
        row0.setPrefHeight(-1.0);
        row0.setVgrow(Priority.NEVER);
        RowConstraints row1 = new RowConstraints();
        row1.setFillHeight(true);
        row1.setPrefHeight(-1.0);
        row1.setVgrow(Priority.NEVER);
        RowConstraints row2 = new RowConstraints();
        row2.setFillHeight(true);
        row2.setPrefHeight(-1.0);
        row2.setVgrow(Priority.NEVER);
        RowConstraints row3 = new RowConstraints();
        row3.setFillHeight(true);
        row3.setPrefHeight(-1.0);
        row3.setVgrow(Priority.ALWAYS);
        ColumnConstraints col0 = new ColumnConstraints();
        col0.setFillWidth(true);
        col0.setHgrow(Priority.NEVER);
        col0.setPrefWidth(-1.0);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setFillWidth(true);
        col1.setHgrow(Priority.ALWAYS);
        col1.setPrefWidth(-1.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setFillWidth(true);
        col2.setHgrow(Priority.NEVER);
        col2.setPrefWidth(-1.0);
        this.weekViewContainer = new GridPane();
        this.weekViewContainer.getStyleClass().add((Object)"container");
        this.weekViewContainer.setGridLinesVisible(true);
        this.weekViewContainer.getRowConstraints().setAll((Object[])new RowConstraints[]{row0, row1, row2, row3});
        this.weekViewContainer.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col0, col1, col2});
        this.getChildren().add((Object)this.weekViewContainer);
        InvalidationListener visibilityListener = it -> this.updateVisibilities();
        view.showTimeScaleViewProperty().addListener(visibilityListener);
        view.showWeekDayHeaderViewProperty().addListener(visibilityListener);
        view.showAllDayViewProperty().addListener(visibilityListener);
        view.layoutProperty().addListener(visibilityListener);
        view.showScrollBarProperty().addListener(visibilityListener);
        Platform.runLater(() -> ViewHelper.scrollToRequestedTime(view, this.weekViewScrollPane));
        view.requestedTimeProperty().addListener(it -> ViewHelper.scrollToRequestedTime(view, this.weekViewScrollPane));
        this.updateVisibilities();
    }

    private void updateVisibilities() {
        this.weekViewContainer.getChildren().clear();
        DetailedWeekView view = (DetailedWeekView)this.getSkinnable();
        if (view.isShowTimeScaleView()) {
            this.weekViewContainer.add((Node)this.timeScaleScrollPane, 0, 3);
            if (view.isShowAllDayView()) {
                this.weekViewContainer.add((Node)this.allDayLabel, 0, 1);
            }
        }
        if (view.isShowWeekDayHeaderView()) {
            this.weekViewContainer.add((Node)this.weekdayFillerLeft, 0, 0);
            this.weekViewContainer.add((Node)this.weekdayHeaderView, 1, 0);
            this.weekViewContainer.add((Node)this.weekdayFillerRight, 2, 0);
        }
        if (view.isShowAllDayView()) {
            this.weekViewContainer.add((Node)this.allDayView, 1, 1);
            this.weekViewContainer.add((Node)this.allDayFiller, 2, 1);
        }
        if (view.getLayout().equals((Object)DateControl.Layout.SWIMLANE)) {
            this.weekViewContainer.add((Node)this.calendarHeaderView, 1, 2);
        }
        this.weekViewContainer.add((Node)this.weekViewScrollPane, 1, 3);
        if (view.isShowScrollBar()) {
            this.weekViewContainer.add((Node)this.scrollBar, 2, 3);
        }
    }
}

