/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.model.LoadEvent;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DeveloperConsole;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.TimeField;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;

public class DeveloperConsoleSkin
extends SkinBase<DeveloperConsole> {
    private final TableView<LogEntry> tableView;
    private final FilteredList<LogEntry> filteredList;
    private final ToggleButton showLoadEvents;
    private final ToggleButton showCalendarEvents;
    private final ToggleButton showRequestEvents;
    private final DatePicker datePicker;
    private final DatePicker todayPicker;
    private final TimeField timeField;
    private final ObservableList<LogEntry> masterData = FXCollections.observableArrayList();
    private final EventHandler<CalendarEvent> calendarListener = evt -> this.addEvent(evt, LogEntryType.CALENDAR_EVENT);
    private final WeakEventHandler<CalendarEvent> weakCalendarListener = new WeakEventHandler(this.calendarListener);

    public DeveloperConsoleSkin(DeveloperConsole view) {
        super((Control)view);
        TabPane tabPane = view.getTabPane();
        tabPane.setSide(Side.TOP);
        this.getChildren().add((Object)tabPane);
        this.tableView = new TableView();
        ToolBar toolbar = new ToolBar();
        this.datePicker = new DatePicker();
        this.todayPicker = new DatePicker();
        this.timeField = new TimeField();
        this.showCalendarEvents = new ToggleButton("Calendar Events");
        this.showCalendarEvents.setSelected(true);
        this.showCalendarEvents.setOnAction(evt -> this.filter());
        toolbar.getItems().add((Object)this.showCalendarEvents);
        this.showLoadEvents = new ToggleButton("Load Events");
        this.showLoadEvents.setSelected(false);
        this.showLoadEvents.setOnAction(evt -> this.filter());
        toolbar.getItems().add((Object)this.showLoadEvents);
        this.showRequestEvents = new ToggleButton("Request Events");
        this.showRequestEvents.setSelected(false);
        this.showRequestEvents.setOnAction(evt -> this.filter());
        toolbar.getItems().add((Object)this.showRequestEvents);
        toolbar.getItems().add((Object)new Separator());
        Button clearLog = new Button("Clear");
        clearLog.setOnAction(evt -> {
            this.masterData.clear();
            LogEntry.counter = 0;
        });
        toolbar.getItems().add((Object)clearLog);
        toolbar.getItems().add((Object)new Separator());
        toolbar.getItems().add((Object)new Label("Date:"));
        toolbar.getItems().add((Object)this.datePicker);
        toolbar.getItems().add((Object)new Label("Today:"));
        toolbar.getItems().add((Object)this.todayPicker);
        toolbar.getItems().add((Object)new Label("Time:"));
        toolbar.getItems().add((Object)this.timeField);
        BorderPane eventsBorderPane = new BorderPane();
        eventsBorderPane.setBottom((Node)toolbar);
        eventsBorderPane.setCenter(this.tableView);
        Tab tab = new Tab("Events", (Node)eventsBorderPane);
        tabPane.getTabs().add((Object)tab);
        TableColumn counterColumn = new TableColumn("#");
        counterColumn.setCellValueFactory((Callback)new PropertyValueFactory("counter"));
        counterColumn.setPrefWidth(50.0);
        TableColumn logEntryTypeColumn = new TableColumn("Event");
        logEntryTypeColumn.setCellValueFactory((Callback)new PropertyValueFactory("logEntryType"));
        logEntryTypeColumn.setPrefWidth(200.0);
        TableColumn eventTypeColumn = new TableColumn("Event Type");
        eventTypeColumn.setCellValueFactory((Callback)new PropertyValueFactory("eventType"));
        eventTypeColumn.setPrefWidth(200.0);
        TableColumn sourceColumn = new TableColumn("Source");
        sourceColumn.setCellValueFactory((Callback)new PropertyValueFactory("source"));
        sourceColumn.setPrefWidth(120.0);
        TableColumn targetColumn = new TableColumn("Target");
        targetColumn.setCellValueFactory((Callback)new PropertyValueFactory("target"));
        targetColumn.setPrefWidth(120.0);
        TableColumn newStartTimeColumn = new TableColumn("Start");
        newStartTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("newStartTime"));
        newStartTimeColumn.setPrefWidth(120.0);
        TableColumn newEndTimeColumn = new TableColumn("End");
        newEndTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("newEndTime"));
        newEndTimeColumn.setPrefWidth(120.0);
        TableColumn oldStartTimeColumn = new TableColumn("Old Start");
        oldStartTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("oldStartTime"));
        oldStartTimeColumn.setPrefWidth(120.0);
        TableColumn oldEndTimeColumn = new TableColumn("Old End");
        oldEndTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("oldEndTime"));
        oldEndTimeColumn.setPrefWidth(120.0);
        TableColumn timestampColumn = new TableColumn("Timestamp");
        timestampColumn.setCellValueFactory((Callback)new PropertyValueFactory("timestamp"));
        timestampColumn.setPrefWidth(120.0);
        TableColumn descriptionColumn = new TableColumn("Description");
        descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        descriptionColumn.setPrefWidth(700.0);
        this.tableView.getColumns().setAll((Object[])new TableColumn[]{counterColumn, logEntryTypeColumn, eventTypeColumn, sourceColumn, targetColumn, newStartTimeColumn, newEndTimeColumn, oldStartTimeColumn, oldEndTimeColumn, timestampColumn, descriptionColumn});
        this.filteredList = new FilteredList(this.masterData);
        this.tableView.setItems(this.filteredList);
        this.filter();
        this.updateSkin();
        view.dateControlProperty().addListener(it -> this.updateSkin());
    }

    private void updateSkin() {
        DeveloperConsole view = (DeveloperConsole)this.getSkinnable();
        if (view.getDateControl() != null) {
            this.setDateControl(view.getDateControl());
        }
    }

    private void setDateControl(DateControl control) {
        Objects.requireNonNull(control);
        control.addEventFilter(RequestEvent.REQUEST, evt -> this.addEvent(evt, LogEntryType.REQUEST_EVENT));
        control.addEventFilter(LoadEvent.LOAD, evt -> this.addEvent(evt, LogEntryType.LOAD_EVENT));
        for (Calendar calendar : control.getCalendars()) {
            calendar.addEventHandler((EventHandler<CalendarEvent>)this.weakCalendarListener);
        }
        ListChangeListener l = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Calendar c : change.getAddedSubList()) {
                        c.addEventHandler((EventHandler<CalendarEvent>)this.weakCalendarListener);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (Calendar c : change.getRemoved()) {
                    c.removeEventHandler((EventHandler<CalendarEvent>)this.weakCalendarListener);
                }
            }
        };
        control.getCalendars().addListener(l);
        Bindings.bindBidirectional((Property)this.datePicker.valueProperty(), control.dateProperty());
        Bindings.bindBidirectional((Property)this.todayPicker.valueProperty(), control.todayProperty());
        Bindings.bindBidirectional(this.timeField.valueProperty(), control.timeProperty());
        this.timeField.setDisable(false);
    }

    private void filter() {
        this.filteredList.setPredicate(item -> {
            switch (item.getLogEntryType()) {
                case CALENDAR_EVENT: {
                    return this.showCalendarEvents.isSelected();
                }
                case LOAD_EVENT: {
                    return this.showLoadEvents.isSelected();
                }
                case REQUEST_EVENT: {
                    return this.showRequestEvents.isSelected();
                }
            }
            return true;
        });
    }

    private void addEvent(Event evt, LogEntryType type) {
        LogEntry entry = new LogEntry(type, evt);
        this.masterData.add((Object)entry);
        this.limitListSize();
        this.tableView.scrollTo((Object)entry);
    }

    private void limitListSize() {
        if (this.masterData.size() > 100) {
            this.masterData.remove(0, 10);
        }
    }

    public static class LogEntry {
        private static int counter = 0;
        private final LocalDateTime timestamp = LocalDateTime.now();
        private final LogEntryType logEntryType;
        private final Event event;
        private final int count;

        public LogEntry(LogEntryType type, Event event) {
            this.logEntryType = type;
            this.event = event;
            this.count = ++counter;
        }

        public int getCounter() {
            return this.count;
        }

        public Object getSource() {
            return this.event.getSource().getClass().getSimpleName();
        }

        public Object getTarget() {
            return this.event.getTarget().getClass().getSimpleName();
        }

        public String getDescription() {
            return this.event.toString();
        }

        public String getTimestamp() {
            return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(this.timestamp);
        }

        public String getEventType() {
            return this.event.getEventType().getName();
        }

        public LogEntryType getLogEntryType() {
            return this.logEntryType;
        }

        public String getNewStartTime() {
            if (this.event instanceof CalendarEvent) {
                CalendarEvent evt = (CalendarEvent)this.event;
                Entry<?> entry = evt.getEntry();
                if (entry != null) {
                    return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(entry.getStartAsLocalDateTime());
                }
                return "";
            }
            if (this.event instanceof RequestEvent) {
                RequestEvent evt = (RequestEvent)this.event;
                if (evt.getDate() != null) {
                    return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).format(evt.getDate());
                }
                if (evt.getDateTime() != null) {
                    return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(evt.getDateTime());
                }
                if (evt.getYearMonth() != null) {
                    return evt.getYearMonth().toString();
                }
                if (evt.getYearMonth() != null) {
                    return evt.getYear().toString();
                }
            }
            return null;
        }

        public String getNewEndTime() {
            CalendarEvent evt;
            Entry<?> entry;
            if (this.event instanceof CalendarEvent && (entry = (evt = (CalendarEvent)this.event).getEntry()) != null) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(entry.getEndAsLocalDateTime());
            }
            return null;
        }

        public String getOldStartTime() {
            CalendarEvent evt;
            Interval oldInterval;
            if (this.event instanceof CalendarEvent && (oldInterval = (evt = (CalendarEvent)this.event).getOldInterval()) != null) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(LocalDateTime.of(oldInterval.getStartDate(), oldInterval.getStartTime()));
            }
            return null;
        }

        public String getOldEndTime() {
            CalendarEvent evt;
            Interval oldInterval;
            if (this.event instanceof CalendarEvent && (oldInterval = (evt = (CalendarEvent)this.event).getOldInterval()) != null) {
                return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(LocalDateTime.of(oldInterval.getEndDate(), oldInterval.getEndTime()));
            }
            return null;
        }
    }

    static enum LogEntryType {
        INFO,
        CALENDAR_EVENT,
        REQUEST_EVENT,
        LOAD_EVENT;

    }
}

