/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Marker;
import com.calendarfx.view.DayView;
import com.calendarfx.view.ResourceCalendarView;
import com.calendarfx.view.TimeScaleView;
import com.calendarfx.view.VirtualGrid;
import impl.com.calendarfx.view.DayViewBaseSkin;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.PlusMinusSlider;

public class ResourceCalendarViewSkin<T>
extends DayViewBaseSkin<ResourceCalendarView<T>> {
    private final GridPane gridPane = new GridPane();
    private final HeaderGridPane headerGridPane = new HeaderGridPane();
    private final BodyGridPane bodyGridPane = new BodyGridPane();
    private final TimeScaleView timeScaleView = new TimeScaleView();
    private PlusMinusSlider slider;

    public ResourceCalendarViewSkin(ResourceCalendarView view) {
        super(view);
        this.timeScaleView.setScrollingEnabled(true);
        this.timeScaleView.visibleProperty().bind((ObservableValue)view.showTimeScaleProperty());
        this.timeScaleView.managedProperty().bind((ObservableValue)view.showTimeScaleProperty());
        view.bind(this.timeScaleView, true);
        this.gridPane.getStyleClass().add((Object)"resource-calendar-container");
        this.getChildren().add((Object)this.gridPane);
        RowConstraints row1 = new RowConstraints();
        RowConstraints row2 = new RowConstraints();
        row1.setVgrow(Priority.NEVER);
        row2.setVgrow(Priority.ALWAYS);
        this.gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row1, row2});
        InvalidationListener updateGridPaneListener = it -> this.updateView();
        view.dayViewMapProperty().addListener(updateGridPaneListener);
        view.showScrollBarProperty().addListener(updateGridPaneListener);
        view.getMarkers().addListener(updateGridPaneListener);
        view.showScrollBarProperty().addListener(it -> this.updateColumnConstraints());
        this.updateColumnConstraints();
        this.updateView();
    }

    private void updateColumnConstraints() {
        ColumnConstraints con1 = new ColumnConstraints();
        con1.setPrefWidth(-1.0);
        con1.setFillWidth(true);
        ColumnConstraints con2 = new ColumnConstraints();
        con2.setFillWidth(true);
        con2.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{con1, con2});
        if (((ResourceCalendarView)this.getSkinnable()).isShowScrollBar()) {
            ColumnConstraints con3 = new ColumnConstraints();
            con3.setPrefWidth(-1.0);
            con3.setFillWidth(true);
            this.gridPane.getColumnConstraints().add((Object)con3);
        }
    }

    private void updateView() {
        this.gridPane.getChildren().clear();
        this.gridPane.add((Node)this.timeScaleView, 0, 1);
        Region header = new Region();
        header.getStyleClass().add((Object)"header-background");
        this.gridPane.add((Node)header, 0, 0);
        GridPane.setColumnSpan((Node)header, (Integer)3);
        this.headerGridPane.updateView();
        this.gridPane.add((Node)this.headerGridPane, 1, 0);
        GridPane.setFillWidth((Node)this.headerGridPane, (Boolean)true);
        this.bodyGridPane.updateView();
        this.gridPane.add((Node)this.bodyGridPane, 1, 1);
        GridPane.setFillWidth((Node)this.bodyGridPane, (Boolean)true);
        ResourceCalendarView resourceCalendarView = (ResourceCalendarView)this.getSkinnable();
        if (resourceCalendarView.isShowScrollBar()) {
            this.slider = new PlusMinusSlider();
            this.slider.setOrientation(Orientation.VERTICAL);
            this.slider.setOnValueChanged(evt -> {
                double base = this.slider.getValue();
                double pow = Math.signum(this.slider.getValue()) * Math.pow(base, 2.0);
                double pixel = pow * -100.0;
                resourceCalendarView.setScrollTime(resourceCalendarView.getZonedDateTimeAt(0.0, pixel, resourceCalendarView.getZoneId()));
            });
            this.gridPane.add((Node)this.slider, 2, 1);
        }
    }

    public class HeaderGridPane
    extends GridPane {
        private void updateView() {
            this.getChildren().clear();
            this.getColumnConstraints().clear();
            int columnCounts = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getResources().size();
            for (int i = 0; i < columnCounts; ++i) {
                ColumnConstraints con = new ColumnConstraints();
                con.setHalignment(HPos.CENTER);
                con.setFillWidth(true);
                con.setHgrow(Priority.ALWAYS);
                con.setPercentWidth(100.0 / (double)columnCounts);
                this.getColumnConstraints().add((Object)con);
                Object resource = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getResources().get(i);
                Node resourceHeader = (Node)((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getHeaderFactory().call(resource);
                GridPane.setFillHeight((Node)resourceHeader, (Boolean)true);
                GridPane.setVgrow((Node)resourceHeader, (Priority)Priority.ALWAYS);
                this.add(resourceHeader, i, 1);
                GridPane.setRowSpan((Node)resourceHeader, (Integer)1);
            }
        }
    }

    public class BodyGridPane
    extends GridPane {
        private MarkerLine draggedMarkerLine;
        private final InvalidationListener markerListener = it -> Platform.runLater(() -> ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).layout());
        private final WeakInvalidationListener weakMarkerListener = new WeakInvalidationListener(this.markerListener);
        private final ObservableMap<Marker, MarkerLine> markerLineMap = FXCollections.observableMap(new HashMap());
        private double startY;

        public BodyGridPane() {
            this.addEventFilter(MouseEvent.MOUSE_MOVED, evt -> {
                MarkerLine markerLine;
                if (evt.getTarget() instanceof MarkerLine && (markerLine = (MarkerLine)evt.getTarget()).getMarker().isMovable()) {
                    markerLine.setCursor(Cursor.HAND);
                }
            });
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, evt -> {
                MarkerLine markerLine;
                this.startY = evt.getScreenY();
                if (evt.getTarget() instanceof MarkerLine && (markerLine = (MarkerLine)evt.getTarget()).getMarker().isMovable()) {
                    this.draggedMarkerLine = (MarkerLine)evt.getTarget();
                    this.draggedMarkerLine.setCursor(Cursor.CLOSED_HAND);
                }
            });
            this.addEventFilter(MouseEvent.MOUSE_RELEASED, evt -> {
                if (this.draggedMarkerLine != null) {
                    this.draggedMarkerLine.setCursor(Cursor.HAND);
                    double y = this.draggedMarkerLine.getLayoutY();
                    this.adjustLineLocation(this.draggedMarkerLine, y);
                    this.draggedMarkerLine = null;
                }
            });
            this.addEventFilter(MouseEvent.MOUSE_DRAGGED, evt -> {
                if (this.draggedMarkerLine != null) {
                    double y = evt.getScreenY();
                    double delta = this.startY - y;
                    double newLocation = this.draggedMarkerLine.getLayoutY() - delta;
                    this.draggedMarkerLine.setLayoutY(newLocation);
                    this.startY = y;
                }
            });
            ListChangeListener l = change -> {
                while (change.next()) {
                    if (change.wasAdded()) {
                        change.getAddedSubList().forEach(marker -> this.addMarkerLine((Marker)marker));
                        continue;
                    }
                    if (!change.wasRemoved()) continue;
                    change.getRemoved().forEach(marker -> {
                        marker.timeProperty().removeListener((InvalidationListener)this.weakMarkerListener);
                        this.getChildren().remove(this.markerLineMap.get(marker));
                    });
                }
            };
            ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getMarkers().addListener(l);
            ObservableList<Marker> markers = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getMarkers();
            markers.forEach(marker -> this.addMarkerLine((Marker)marker));
            Rectangle clip = new Rectangle();
            clip.widthProperty().bind((ObservableValue)this.widthProperty());
            clip.heightProperty().bind((ObservableValue)this.heightProperty());
            this.setClip((Node)clip);
        }

        private void adjustLineLocation(MarkerLine markerLine, double y) {
            ZonedDateTime dropTime = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getZonedDateTimeAt(0.0, y, ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getZoneId());
            VirtualGrid virtualGrid = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getVirtualGrid();
            if (virtualGrid != null) {
                long secondsB;
                ZonedDateTime timeA = virtualGrid.adjustTime(dropTime, true, ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getFirstDayOfWeek());
                ZonedDateTime timeB = virtualGrid.adjustTime(dropTime, false, ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getFirstDayOfWeek());
                long secondsA = Math.abs(timeA.until(dropTime, ChronoUnit.SECONDS));
                dropTime = secondsA < (secondsB = Math.abs(timeB.until(dropTime, ChronoUnit.SECONDS))) ? timeA : timeB;
            }
            markerLine.getMarker().setTime(dropTime);
            double dropLocationY = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getLocation(dropTime);
            markerLine.setLayoutY(dropLocationY - markerLine.prefHeight(-1.0));
        }

        private void addMarkerLine(Marker marker) {
            marker.timeProperty().addListener((InvalidationListener)this.weakMarkerListener);
            MarkerLine markerLine = new MarkerLine(marker);
            this.markerLineMap.put((Object)marker, (Object)markerLine);
            markerLine.setManaged(false);
            this.getChildren().add((Object)markerLine);
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.markerLineMap.values().forEach(line -> {
                Marker marker = line.getMarker();
                if (line != this.draggedMarkerLine) {
                    ZonedDateTime time = marker.getTime();
                    double location = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getLocation(time);
                    MarkerLine markerLine = (MarkerLine)((Object)((Object)this.markerLineMap.get((Object)marker)));
                    double ph = markerLine.prefHeight(-1.0);
                    markerLine.toFront();
                    double x = this.getInsets().getLeft();
                    double w = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
                    markerLine.resizeRelocate(x, this.snapPositionY(location - ph / 2.0), this.snapSizeX(w), this.snapSizeY(ph));
                }
            });
        }

        private void updateView() {
            this.getChildren().removeIf(node -> !(node instanceof MarkerLine));
            this.getColumnConstraints().clear();
            int columnCounts = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getResources().size();
            for (int i = 0; i < columnCounts; ++i) {
                Object resource = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getResources().get(i);
                ColumnConstraints con = new ColumnConstraints();
                con.setHalignment(HPos.CENTER);
                con.setFillWidth(true);
                con.setHgrow(Priority.ALWAYS);
                con.setPercentWidth(100.0 / (double)columnCounts);
                this.getColumnConstraints().add((Object)con);
                DayView dayView = ((ResourceCalendarView)ResourceCalendarViewSkin.this.getSkinnable()).getDayView(resource);
                GridPane.setFillHeight((Node)dayView, (Boolean)true);
                GridPane.setVgrow((Node)dayView, (Priority)Priority.ALWAYS);
                this.add((Node)dayView, i, 1);
                GridPane.setRowSpan((Node)dayView, (Integer)1);
            }
        }
    }

    private static class MarkerLine
    extends StackPane {
        private final Marker marker;
        private final InvalidationListener updateStyleListener = it -> this.updateStyleClass();
        private final WeakInvalidationListener weakUpdateStyleListener = new WeakInvalidationListener(this.updateStyleListener);

        public MarkerLine(Marker marker) {
            this.marker = marker;
            this.styleProperty().bind((ObservableValue)marker.styleProperty());
            marker.getStyleClass().addListener((InvalidationListener)this.weakUpdateStyleListener);
            this.updateStyleClass();
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind((ObservableValue)marker.titleProperty());
            Tooltip.install((Node)this, (Tooltip)tooltip);
        }

        private void updateStyleClass() {
            this.getStyleClass().setAll((Object[])new String[]{"marker-line"});
            this.getStyleClass().addAll(this.marker.getStyleClass());
        }

        public Marker getMarker() {
            return this.marker;
        }
    }
}

