/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Resource;
import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.ResourcesView;
import com.calendarfx.view.TimeScaleView;
import com.calendarfx.view.WeekDayHeaderView;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.DayViewScrollPane;
import impl.com.calendarfx.view.ResourcesViewContainer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.PlusMinusSlider;

public class ResourcesViewSkin<T extends Resource<?>>
extends DateControlSkin<ResourcesView<T>> {
    private final GridPane gridPane;
    private final ScrollBar scrollBar = new ScrollBar();
    private final PlusMinusSlider plusMinusSlider;
    private DayViewScrollPane dayViewScrollPane;
    private final ResourcesViewContainer<T> resourcesViewContainer;
    private final TimeScaleView timeScaleView;

    public ResourcesViewSkin(ResourcesView<T> view) {
        super(view);
        this.scrollBar.setOrientation(Orientation.VERTICAL);
        this.scrollBar.visibleProperty().bind((ObservableValue)view.scrollingEnabledProperty().not());
        this.plusMinusSlider = new PlusMinusSlider();
        this.plusMinusSlider.setOrientation(Orientation.VERTICAL);
        this.plusMinusSlider.visibleProperty().bind((ObservableValue)view.scrollingEnabledProperty());
        this.plusMinusSlider.setOnValueChanged(evt -> {
            double base = this.plusMinusSlider.getValue();
            double pow = Math.signum(this.plusMinusSlider.getValue()) * Math.pow(base, 2.0);
            double pixel = pow * -100.0;
            view.setScrollTime(view.getZonedDateTimeAt(0.0, pixel, view.getZoneId()));
        });
        this.resourcesViewContainer = new ResourcesViewContainer<T>(view);
        this.resourcesViewContainer.setMinHeight(0.0);
        view.bind(this.resourcesViewContainer, true);
        this.timeScaleView = new TimeScaleView();
        view.bind(this.timeScaleView, true);
        InvalidationListener updateViewListener = it -> this.updateView();
        view.showAllDayViewProperty().addListener(updateViewListener);
        view.showTimeScaleViewProperty().addListener(updateViewListener);
        view.layoutProperty().addListener(updateViewListener);
        view.showScrollBarProperty().addListener(updateViewListener);
        view.showTimeScaleViewProperty().addListener(updateViewListener);
        view.numberOfDaysProperty().addListener(updateViewListener);
        view.typeProperty().addListener(updateViewListener);
        view.getResources().addListener(updateViewListener);
        view.scrollingEnabledProperty().addListener(updateViewListener);
        RowConstraints row0 = new RowConstraints();
        row0.setFillHeight(true);
        row0.setPrefHeight(-1.0);
        row0.setVgrow(Priority.NEVER);
        RowConstraints row1 = new RowConstraints();
        row1.setFillHeight(true);
        row1.setPrefHeight(-1.0);
        row1.setVgrow(Priority.ALWAYS);
        this.gridPane = new GridPane();
        this.gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row0, row1});
        this.gridPane.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.gridPane);
        this.updateView();
        Platform.runLater(() -> {
            if (this.dayViewScrollPane != null) {
                ViewHelper.scrollToRequestedTime(view, this.dayViewScrollPane);
            }
        });
        view.requestedTimeProperty().addListener(it -> {
            if (this.dayViewScrollPane != null) {
                ViewHelper.scrollToRequestedTime(view, this.dayViewScrollPane);
            }
        });
    }

    private void updateView() {
        this.gridPane.getChildren().clear();
        this.gridPane.getColumnConstraints().clear();
        this.dayViewScrollPane = null;
        ResourcesView resourcesView = (ResourcesView)this.getSkinnable();
        if (resourcesView.getType().equals((Object)ResourcesView.Type.RESOURCES_OVER_DATES)) {
            this.updateViewResourcesOverDates();
        } else {
            this.updateViewDatesOverResources();
        }
    }

    private void updateViewDatesOverResources() {
        ResourcesView resourcesView = (ResourcesView)this.getSkinnable();
        if (resourcesView.isShowTimeScaleView()) {
            ColumnConstraints timeScaleColumn = new ColumnConstraints();
            timeScaleColumn.setFillWidth(true);
            timeScaleColumn.setHgrow(Priority.NEVER);
            this.gridPane.getColumnConstraints().add((Object)timeScaleColumn);
            if (resourcesView.isScrollingEnabled()) {
                this.gridPane.add((Node)this.timeScaleView, 0, 1);
            } else {
                DayViewScrollPane timeScaleScrollPane = new DayViewScrollPane(this.timeScaleView, this.scrollBar);
                timeScaleScrollPane.getStyleClass().addAll((Object[])new String[]{"calendar-scroll-pane", "day-view-timescale-scroll-pane"});
                timeScaleScrollPane.setMinWidth(Double.NEGATIVE_INFINITY);
                this.gridPane.add((Node)timeScaleScrollPane, 0, 1);
            }
            Node upperLeftCorner = resourcesView.getUpperLeftCorner();
            upperLeftCorner.getStyleClass().add((Object)"upper-left-corner");
            this.gridPane.add(upperLeftCorner, 0, 0);
        }
        if (resourcesView.isShowScrollBar()) {
            Node upperRightCorner = resourcesView.getUpperRightCorner();
            upperRightCorner.getStyleClass().add((Object)"upper-right-corner");
            this.gridPane.add(upperRightCorner, 2, 0);
        }
        Callback resourceHeaderFactory = resourcesView.getResourceHeaderFactory();
        ObservableList resources = resourcesView.getResources();
        HBox headerBox = new HBox();
        headerBox.getStyleClass().add((Object)"header-box");
        this.gridPane.add((Node)headerBox, 1, 0);
        for (int dayIndex = 0; dayIndex < resourcesView.getNumberOfDays(); ++dayIndex) {
            Region separator;
            Callback separatorFactory;
            SimpleObjectProperty dateProperty = new SimpleObjectProperty((Object)this, "date");
            int additionalDays = dayIndex;
            dateProperty.bind((ObservableValue)Bindings.createObjectBinding(() -> resourcesView.getDate().plusDays(additionalDays), (Observable[])new Observable[]{resourcesView.dateProperty()}));
            VBox dayBox = new VBox();
            dayBox.getStyleClass().add((Object)"day-box");
            HBox.setHgrow((Node)dayBox, (Priority)Priority.ALWAYS);
            WeekDayHeaderView weekDayHeaderView = new WeekDayHeaderView(resourcesView.getNumberOfDays());
            resourcesView.bind(weekDayHeaderView, false);
            weekDayHeaderView.dateProperty().bind((ObservableValue)dateProperty);
            weekDayHeaderView.setNumberOfDays(1);
            weekDayHeaderView.setAdjustToFirstDayOfWeek(false);
            weekDayHeaderView.getStyleClass().removeAll((Object[])new String[]{"only", "first", "middle", "last"});
            if (resourcesView.getNumberOfDays() == 1) {
                weekDayHeaderView.getStyleClass().add((Object)"only");
            } else if (dayIndex == 0) {
                weekDayHeaderView.getStyleClass().add((Object)"first");
            } else if (dayIndex == resourcesView.getNumberOfDays() - 1) {
                weekDayHeaderView.getStyleClass().add((Object)"last");
            } else {
                weekDayHeaderView.getStyleClass().add((Object)"middle");
            }
            dayBox.getChildren().add((Object)weekDayHeaderView);
            HBox allResourcesBox = new HBox();
            VBox.setVgrow((Node)allResourcesBox, (Priority)Priority.ALWAYS);
            dayBox.getChildren().add((Object)allResourcesBox);
            headerBox.getChildren().add((Object)dayBox);
            if (dayIndex < resourcesView.getNumberOfDays() - 1 && (separatorFactory = resourcesView.getLargeSeparatorFactory()) != null && (separator = (Region)separatorFactory.call((Object)resourcesView)) != null) {
                headerBox.getChildren().add((Object)separator);
                HBox.setHgrow((Node)separator, (Priority)Priority.NEVER);
            }
            for (int resourceIndex = 0; resourceIndex < resources.size(); ++resourceIndex) {
                Region separator2;
                Callback separatorFactory2;
                Resource resource = (Resource)resources.get(resourceIndex);
                Node resourceHeaderNode = (Node)resourceHeaderFactory.call((Object)resource);
                VBox singleResourceBox = new VBox(new Node[]{resourceHeaderNode});
                HBox.setHgrow((Node)singleResourceBox, (Priority)Priority.ALWAYS);
                allResourcesBox.getChildren().add((Object)singleResourceBox);
                resourceHeaderNode.getStyleClass().removeAll((Object[])new String[]{"only", "first", "middle", "last"});
                if (resources.size() == 1) {
                    resourceHeaderNode.getStyleClass().add((Object)"only");
                } else if (resourceIndex == 0) {
                    resourceHeaderNode.getStyleClass().add((Object)"first");
                } else if (resourceIndex == resources.size() - 1) {
                    resourceHeaderNode.getStyleClass().add((Object)"last");
                } else {
                    resourceHeaderNode.getStyleClass().add((Object)"middle");
                }
                if (resourcesView.isShowAllDayView()) {
                    Callback allDayViewFactory = resourcesView.getAllDayViewFactory();
                    AllDayView allDayView = (AllDayView)allDayViewFactory.call((Object)resource);
                    allDayView.getStyleClass().removeAll((Object[])new String[]{"only", "first", "middle", "last"});
                    if (resources.size() == 1) {
                        allDayView.getStyleClass().add((Object)"only");
                    } else if (resourceIndex == 0) {
                        allDayView.getStyleClass().add((Object)"first");
                    } else if (resourceIndex == resources.size() - 1) {
                        allDayView.getStyleClass().add((Object)"last");
                    } else {
                        allDayView.getStyleClass().add((Object)"middle");
                    }
                    resourcesView.bind(allDayView, false);
                    Bindings.unbindBidirectional((Property)resourcesView.adjustToFirstDayOfWeekProperty(), (Property)allDayView.adjustToFirstDayOfWeekProperty());
                    Bindings.unbindBidirectional((Property)resourcesView.numberOfDaysProperty(), (Property)allDayView.numberOfDaysProperty());
                    allDayView.dateProperty().bind((ObservableValue)dateProperty);
                    allDayView.setAdjustToFirstDayOfWeek(false);
                    allDayView.setNumberOfDays(1);
                    Bindings.unbindBidirectional(resourcesView.defaultCalendarProviderProperty(), allDayView.defaultCalendarProviderProperty());
                    Bindings.unbindBidirectional(resourcesView.draggedEntryProperty(), allDayView.draggedEntryProperty());
                    Bindings.unbindContentBidirectional(resourcesView.getCalendarSources(), allDayView.getCalendarSources());
                    Bindings.bindContent(allDayView.getCalendarSources(), resource.getCalendarSources());
                    VBox.setVgrow((Node)allDayView, (Priority)Priority.ALWAYS);
                    singleResourceBox.getChildren().add((Object)allDayView);
                }
                singleResourceBox.setPrefWidth(0.0);
                HBox.setHgrow((Node)singleResourceBox, (Priority)Priority.ALWAYS);
                if (resourceIndex >= resources.size() - 1 || (separatorFactory2 = resourcesView.getSmallSeparatorFactory()) == null || (separator2 = (Region)separatorFactory2.call((Object)resourcesView)) == null) continue;
                allResourcesBox.getChildren().add((Object)separator2);
                HBox.setHgrow((Node)separator2, (Priority)Priority.NEVER);
            }
        }
        ColumnConstraints containerOrScrollPaneConstraints = new ColumnConstraints();
        containerOrScrollPaneConstraints.setFillWidth(true);
        containerOrScrollPaneConstraints.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().add((Object)containerOrScrollPaneConstraints);
        if (resourcesView.isScrollingEnabled()) {
            this.gridPane.add(this.resourcesViewContainer, 1, 1);
        } else {
            this.dayViewScrollPane = new DayViewScrollPane(this.resourcesViewContainer, this.scrollBar);
            this.gridPane.add((Node)this.dayViewScrollPane, 1, 1);
        }
        if (resourcesView.isShowScrollBar()) {
            ColumnConstraints scrollbarConstraint = new ColumnConstraints();
            scrollbarConstraint.setFillWidth(true);
            scrollbarConstraint.setHgrow(Priority.NEVER);
            scrollbarConstraint.setPrefWidth(-1.0);
            this.gridPane.getColumnConstraints().add((Object)scrollbarConstraint);
            if (resourcesView.isScrollingEnabled()) {
                this.gridPane.add((Node)this.plusMinusSlider, 2, 1);
            } else {
                this.gridPane.add((Node)this.scrollBar, 2, 1);
            }
        }
    }

    private void updateViewResourcesOverDates() {
        ResourcesView resourcesView = (ResourcesView)this.getSkinnable();
        if (resourcesView.isShowTimeScaleView()) {
            ColumnConstraints timeScaleColumn = new ColumnConstraints();
            timeScaleColumn.setFillWidth(true);
            timeScaleColumn.setHgrow(Priority.NEVER);
            this.gridPane.getColumnConstraints().add((Object)timeScaleColumn);
            if (resourcesView.isScrollingEnabled()) {
                this.gridPane.add((Node)this.timeScaleView, 0, 1);
            } else {
                DayViewScrollPane timeScaleScrollPane = new DayViewScrollPane(this.timeScaleView, this.scrollBar);
                timeScaleScrollPane.getStyleClass().addAll((Object[])new String[]{"calendar-scroll-pane", "day-view-timescale-scroll-pane"});
                timeScaleScrollPane.setMinWidth(Double.NEGATIVE_INFINITY);
                this.gridPane.add((Node)timeScaleScrollPane, 0, 1);
            }
            Node upperLeftCorner = resourcesView.getUpperLeftCorner();
            upperLeftCorner.getStyleClass().add((Object)"upper-left-corner");
            this.gridPane.add(upperLeftCorner, 0, 0);
        }
        if (resourcesView.isShowScrollBar()) {
            Node upperRightCorner = resourcesView.getUpperRightCorner();
            upperRightCorner.getStyleClass().add((Object)"upper-right-corner");
            this.gridPane.add(upperRightCorner, 2, 0);
        }
        HBox headerBox = new HBox();
        headerBox.getStyleClass().add((Object)"header-box");
        this.gridPane.add((Node)headerBox, 1, 0);
        Callback resourceHeaderFactory = resourcesView.getResourceHeaderFactory();
        ObservableList resources = resourcesView.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            Region separator;
            Callback separatorFactory;
            Resource resource = (Resource)resources.get(i);
            Node headerNode = (Node)resourceHeaderFactory.call((Object)resource);
            VBox resourceHeader = new VBox(new Node[]{headerNode});
            resourceHeader.getStyleClass().removeAll((Object[])new String[]{"only", "first", "middle", "last"});
            if (resources.size() == 1) {
                resourceHeader.getStyleClass().add((Object)"only");
            } else if (i == 0) {
                resourceHeader.getStyleClass().add((Object)"first");
            } else if (i == resources.size() - 1) {
                resourceHeader.getStyleClass().add((Object)"last");
            } else {
                resourceHeader.getStyleClass().add((Object)"middle");
            }
            if (resourcesView.isShowAllDayView()) {
                AllDayView allDayView = new AllDayView();
                allDayView.setAdjustToFirstDayOfWeek(false);
                resourcesView.bind(allDayView, true);
                allDayView.numberOfDaysProperty().bind((ObservableValue)resourcesView.numberOfDaysProperty());
                allDayView.adjustToFirstDayOfWeekProperty().bind((ObservableValue)resourcesView.adjustToFirstDayOfWeekProperty());
                Bindings.unbindBidirectional(resourcesView.defaultCalendarProviderProperty(), allDayView.defaultCalendarProviderProperty());
                Bindings.unbindBidirectional(resourcesView.draggedEntryProperty(), allDayView.draggedEntryProperty());
                Bindings.unbindContentBidirectional(resourcesView.getCalendarSources(), allDayView.getCalendarSources());
                Bindings.bindContent(allDayView.getCalendarSources(), resource.getCalendarSources());
                resourceHeader.getChildren().add((Object)allDayView);
            }
            resourceHeader.getStyleClass().add((Object)"resource-header-view");
            WeekDayHeaderView weekDayHeaderView = (WeekDayHeaderView)((Object)resourcesView.getWeekDayHeaderViewFactory().call((Object)resource));
            weekDayHeaderView.adjustToFirstDayOfWeekProperty().bind((ObservableValue)resourcesView.adjustToFirstDayOfWeekProperty());
            weekDayHeaderView.numberOfDaysProperty().bind((ObservableValue)resourcesView.numberOfDaysProperty());
            resourcesView.bind(weekDayHeaderView, true);
            resourceHeader.setPrefWidth(0.0);
            resourceHeader.getChildren().add((Object)weekDayHeaderView);
            headerBox.getChildren().add((Object)resourceHeader);
            HBox.setHgrow((Node)resourceHeader, (Priority)Priority.ALWAYS);
            if (i >= resources.size() - 1 || (separatorFactory = resourcesView.getLargeSeparatorFactory()) == null || (separator = (Region)separatorFactory.call((Object)resourcesView)) == null) continue;
            headerBox.getChildren().add((Object)separator);
            HBox.setHgrow((Node)separator, (Priority)Priority.NEVER);
        }
        ColumnConstraints dayViewsConstraints = new ColumnConstraints();
        dayViewsConstraints.setFillWidth(true);
        dayViewsConstraints.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().add((Object)dayViewsConstraints);
        if (resourcesView.isScrollingEnabled()) {
            this.resourcesViewContainer.setTranslateY(0.0);
            this.resourcesViewContainer.setManaged(true);
            this.gridPane.add(this.resourcesViewContainer, 1, 1);
        } else {
            this.dayViewScrollPane = new DayViewScrollPane(this.resourcesViewContainer, this.scrollBar);
            this.gridPane.add((Node)this.dayViewScrollPane, 1, 1);
        }
        if (resourcesView.isShowScrollBar()) {
            ColumnConstraints scrollbarConstraint = new ColumnConstraints();
            scrollbarConstraint.setFillWidth(true);
            scrollbarConstraint.setHgrow(Priority.NEVER);
            scrollbarConstraint.setPrefWidth(-1.0);
            this.gridPane.getColumnConstraints().add((Object)scrollbarConstraint);
            this.gridPane.add((Node)this.scrollBar, 2, 1);
        }
    }
}

