/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.SearchResultView;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Circle;
import javafx.util.Callback;

public class SearchResultViewSkin
extends SkinBase<SearchResultView> {
    private final ListView<Entry<?>> listView;

    public SearchResultViewSkin(SearchResultView view) {
        super((Control)view);
        Label placeholderLabel = new Label();
        placeholderLabel.getStyleClass().add((Object)"placeholder-label");
        this.listView = new ListView();
        this.listView.setItems(view.getSearchResults());
        this.listView.setCellFactory((Callback)new SearchResultCellFactory());
        this.listView.setPlaceholder((Node)placeholderLabel);
        this.listView.getSelectionModel().selectedItemProperty().addListener(it -> view.getProperties().put((Object)"selected.search.result", this.listView.getSelectionModel().getSelectedItem()));
        this.getChildren().add(this.listView);
    }

    public class SearchResultCellFactory
    implements Callback<ListView<Entry<?>>, ListCell<Entry<?>>> {
        public ListCell<Entry<?>> call(ListView<Entry<?>> param) {
            return new SearchResultListViewCell();
        }
    }

    public class SearchResultListViewCell
    extends ListCell<Entry<?>> {
        private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
        private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
        private final Circle colorCircle;
        private final Label titleLabel;
        private final Label dateLabel;
        private final Label timeLabel;
        private final BorderPane borderPane;

        public SearchResultListViewCell() {
            this.setPrefWidth(0.0);
            this.getStyleClass().add((Object)"search-result-cell");
            this.colorCircle = new Circle();
            this.colorCircle.setRadius(3.5);
            this.titleLabel = new Label();
            this.titleLabel.setMinWidth(0.0);
            this.titleLabel.setGraphic((Node)this.colorCircle);
            this.titleLabel.getStyleClass().add((Object)"title-label");
            this.dateLabel = new Label();
            this.dateLabel.setMinWidth(0.0);
            this.dateLabel.getStyleClass().add((Object)"date-label");
            this.timeLabel = new Label();
            this.timeLabel.setMinWidth(0.0);
            this.timeLabel.getStyleClass().add((Object)"time-label");
            BorderPane dateTimePane = new BorderPane();
            dateTimePane.getStyleClass().add((Object)"date-time-pane");
            dateTimePane.setLeft((Node)this.dateLabel);
            dateTimePane.setRight((Node)this.timeLabel);
            this.borderPane = new BorderPane();
            this.borderPane.getStyleClass().add((Object)"container");
            this.borderPane.setTop((Node)this.titleLabel);
            this.borderPane.setBottom((Node)dateTimePane);
            this.setGraphic((Node)this.borderPane);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setOnMouseClicked(evt -> {
                Entry entry;
                if (evt.getClickCount() == 2 && (entry = (Entry)this.getItem()) != null) {
                    this.fireEvent(new RequestEvent((Object)this, (EventTarget)this, entry));
                }
            });
        }

        protected void updateItem(Entry<?> entry, boolean empty) {
            super.updateItem(entry, empty);
            if (entry != null) {
                Calendar calendar = entry.getCalendar();
                this.borderPane.setVisible(true);
                this.colorCircle.getStyleClass().add((Object)(calendar.getStyle() + "-icon"));
                this.titleLabel.setText(entry.getTitle());
                this.titleLabel.setVisible(true);
                this.timeLabel.setText(this.getTimeText(entry));
                this.dateLabel.setText(this.dateFormatter.format(entry.getStartDate()));
            } else {
                this.borderPane.setVisible(false);
            }
        }

        private String getTimeText(Entry<?> entry) {
            LocalDate endDate;
            if (entry.isFullDay()) {
                return "all-day";
            }
            LocalDate startDate = entry.getStartDate();
            String text = startDate.equals(endDate = entry.getEndDate()) ? MessageFormat.format(Messages.getString("SearchResultViewSkin.FROM_UNTIL"), this.timeFormatter.format(entry.getStartTime()), this.timeFormatter.format(entry.getEndTime())) : MessageFormat.format(Messages.getString("SearchResultViewSkin.FROM_UNTIL_WITH_DATE"), this.timeFormatter.format(entry.getStartTime()), this.dateFormatter.format(entry.getStartDate()), this.timeFormatter.format(entry.getEndTime()), this.dateFormatter.format(entry.getEndDate()));
            return text;
        }
    }
}

