/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.TimeScaleView;
import impl.com.calendarfx.view.DayViewBaseSkin;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class TimeScaleViewSkin<T extends TimeScaleView>
extends DayViewBaseSkin<T> {
    private static final String EARLY_HOUR_LABEL = "early-hour-label";
    private static final String LATE_HOUR_LABEL = "late-hour-label";
    private final List<Label> timeLabels = new ArrayList<Label>();
    private final Label currentTimeLabel = new Label();

    public TimeScaleViewSkin(T view) {
        super(view);
        this.currentTimeLabel.getStyleClass().add((Object)"current-time-label");
        this.currentTimeLabel.setManaged(false);
        this.currentTimeLabel.setMaxWidth(Double.MAX_VALUE);
        this.currentTimeLabel.setAlignment(Pos.CENTER_RIGHT);
        this.currentTimeLabel.setOpacity(0.0);
        this.currentTimeLabel.setTextOverrun(OverrunStyle.CLIP);
        this.currentTimeLabel.visibleProperty().bind((ObservableValue)((DayViewBase)view).enableCurrentTimeMarkerProperty());
        this.getChildren().add((Object)this.currentTimeLabel);
        this.updateCurrentTimeMarkerVisibility();
        ((DayViewBase)view).showCurrentTimeMarkerProperty().addListener(it -> this.updateCurrentTimeMarkerVisibility());
        this.setupCurrentTimeMarkerSupport();
        this.updateShowMarkers();
        ((DayViewBase)view).scrollingEnabledProperty().addListener(it -> {
            this.timeLabels.clear();
            this.getChildren().clear();
            view.requestLayout();
        });
        ((DayViewBase)view).scrollTimeProperty().addListener(it -> {
            if (view.isScrollingEnabled()) {
                view.requestLayout();
            }
        });
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)view.widthProperty());
        clip.heightProperty().bind((ObservableValue)view.heightProperty());
        view.setClip((Node)clip);
    }

    private Label createTimeLabel() {
        Label label = new Label();
        label.setManaged(false);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER_RIGHT);
        label.setTextOverrun(OverrunStyle.CLIP);
        this.timeLabels.add(label);
        this.getChildren().add((Object)label);
        return label;
    }

    private void updateCurrentTimeMarkerVisibility() {
        double opacity = ((TimeScaleView)this.getSkinnable()).isShowCurrentTimeMarker() ? 1.0 : 0.0;
        FadeTransition lineTransition = new FadeTransition(Duration.millis((double)600.0), (Node)this.currentTimeLabel);
        lineTransition.setToValue(opacity);
        lineTransition.play();
        ((TimeScaleView)this.getSkinnable()).requestLayout();
    }

    protected void setupCurrentTimeMarkerSupport() {
        TimeScaleView view = (TimeScaleView)this.getSkinnable();
        ChangeListener listener = (obs, oldValue, newValue) -> this.updateShowMarkers();
        view.dateProperty().addListener(listener);
        view.todayProperty().addListener(listener);
    }

    private void updateShowMarkers() {
        TimeScaleView view = (TimeScaleView)this.getSkinnable();
        view.getProperties().put((Object)"show.current.time.marker", (Object)this.isShowingTimeMarker());
    }

    protected boolean isShowingTimeMarker() {
        return ((TimeScaleView)this.getSkinnable()).getDate().equals(((TimeScaleView)this.getSkinnable()).getToday());
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        if (((TimeScaleView)this.getSkinnable()).isScrollingEnabled()) {
            this.layoutChildrenInfiniteScrolling(contentX, contentY, contentWidth, contentHeight);
        } else {
            this.layoutChildrenStatic(contentX, contentY, contentWidth, contentHeight);
        }
    }

    private void layoutChildrenInfiniteScrolling(double contentX, double contentY, double contentWidth, double contentHeight) {
        TimeScaleView view = (TimeScaleView)this.getSkinnable();
        ZonedDateTime scrollTime = view.getScrollTime();
        Instant time = scrollTime.withHour(0).toInstant().truncatedTo(ChronoUnit.HOURS);
        double y = view.getLocation(time);
        int index = 0;
        BoundingBox lastBoundsUsed = null;
        do {
            boolean labelVisible;
            LocalTime localTime = LocalTime.ofInstant(time, view.getZoneId());
            boolean midnight = localTime.equals(LocalTime.MIN);
            Label label = index < this.timeLabels.size() ? this.timeLabels.get(index) : this.createTimeLabel();
            if (midnight) {
                label.getStyleClass().setAll((Object[])new String[]{"label", "date-label"});
            } else {
                label.getStyleClass().setAll((Object[])new String[]{"label", "time-label"});
            }
            double prefHeight = label.prefHeight(contentWidth);
            if (midnight) {
                ZonedDateTime dateTime = ZonedDateTime.ofInstant(time, view.getZoneId());
                label.setText(dateTime.toLocalDate().format(view.getDateFormatter()));
                label.setStyle(view.getDateStyleProvider().apply(dateTime.toLocalDateTime()));
            } else {
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(time, view.getZoneId());
                label.setText(zonedDateTime.toLocalTime().format(view.getTimeFormatter()));
                label.setStyle(view.getTimeStyleProvider().apply(zonedDateTime.toLocalDateTime()));
            }
            BoundingBox layoutBounds = new BoundingBox(this.snapPositionX(contentX), this.snapPositionY(y - prefHeight / 2.0), this.snapSizeX(contentWidth), this.snapSizeY(prefHeight));
            boolean bl = labelVisible = lastBoundsUsed == null || !layoutBounds.intersects(lastBoundsUsed);
            if (!labelVisible && midnight) {
                labelVisible = true;
            }
            label.setVisible(labelVisible);
            if (labelVisible) {
                label.resizeRelocate(layoutBounds.getMinX(), layoutBounds.getMinY(), layoutBounds.getWidth(), layoutBounds.getHeight());
                lastBoundsUsed = layoutBounds;
            }
            ++index;
        } while ((y = view.getLocation(time = time.plus(60L, ChronoUnit.MINUTES))) < contentY + contentHeight);
        for (int i = index; i < this.timeLabels.size(); ++i) {
            this.timeLabels.get(i).setVisible(false);
        }
    }

    private void layoutChildrenStatic(double contentX, double contentY, double contentWidth, double contentHeight) {
        LocalTime now = ((TimeScaleView)this.getSkinnable()).getTime();
        this.currentTimeLabel.setText(now.format(((TimeScaleView)this.getSkinnable()).getTimeFormatter()));
        this.placeLabel(this.currentTimeLabel, now, contentX, contentY, contentWidth, contentHeight);
        LocalTime startTime = ((TimeScaleView)this.getSkinnable()).getStartTime();
        LocalTime endTime = ((TimeScaleView)this.getSkinnable()).getEndTime();
        block4: for (int hour = 0; hour < 23; ++hour) {
            Label label;
            LocalTime time = LocalTime.of(hour + 1, 0);
            if (hour < this.timeLabels.size()) {
                label = this.timeLabels.get(hour);
            } else {
                label = this.createTimeLabel();
                label.getStyleClass().add((Object)"time-label");
            }
            label.getStyleClass().removeAll((Object[])new String[]{EARLY_HOUR_LABEL, LATE_HOUR_LABEL});
            label.setStyle(((TimeScaleView)this.getSkinnable()).getTimeStyleProvider().apply(time.atDate(((TimeScaleView)this.getSkinnable()).getDate())));
            this.placeLabel(label, time, contentX, contentY, contentWidth, contentHeight);
            Bounds localToParent1 = this.currentTimeLabel.localToParent(this.currentTimeLabel.getLayoutBounds());
            Bounds localToParent2 = label.localToParent(label.getLayoutBounds());
            label.setVisible(!this.currentTimeLabel.isVisible() || !((TimeScaleView)this.getSkinnable()).isShowCurrentTimeMarker() || !localToParent1.intersects(localToParent2));
            if (time.isBefore(startTime) && !label.getStyleClass().contains((Object)EARLY_HOUR_LABEL)) {
                label.getStyleClass().add((Object)EARLY_HOUR_LABEL);
            }
            if (time.isAfter(endTime) && !label.getStyleClass().contains((Object)LATE_HOUR_LABEL)) {
                label.getStyleClass().add((Object)LATE_HOUR_LABEL);
            }
            if (!label.isVisible()) continue;
            switch (((TimeScaleView)this.getSkinnable()).getEarlyLateHoursStrategy()) {
                case HIDE: 
                case SHOW_COMPRESSED: {
                    if (!time.isBefore(startTime) && !time.isAfter(endTime)) continue block4;
                    label.setVisible(false);
                    continue block4;
                }
                case SHOW: {
                    label.setVisible(true);
                    continue block4;
                }
            }
        }
        this.currentTimeLabel.toFront();
    }

    private void placeLabel(Label label, LocalTime time, double contentX, double contentY, double contentWidth, double contentHeight) {
        double prefHeight = label.prefHeight(contentWidth);
        double y = contentY + ViewHelper.getTimeLocation((DayViewBase)this.getSkinnable(), time, true);
        y = Math.min(contentHeight - label.getFont().getSize(), Math.max(0.0, (double)((int)(y - prefHeight / 2.0)) + 0.5));
        label.setText(time.format(((TimeScaleView)this.getSkinnable()).getTimeFormatter()));
        label.resizeRelocate(this.snapPositionX(contentX), this.snapPositionY(y), this.snapSizeX(contentWidth), this.snapSizeY(prefHeight));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double width = 0.0;
        for (Label label : this.timeLabels) {
            width = Math.max(width, label.prefWidth(-1.0));
        }
        return width + leftInset + rightInset;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }
}

