/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.WeekFieldsView;
import java.time.DayOfWeek;
import java.time.temporal.WeekFields;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.GridPane;

public class WeekFieldsViewSkin
extends SkinBase<WeekFieldsView> {
    private final ComboBox<DayOfWeek> dayOfWeekComboBox = new ComboBox();
    private final ComboBox<Integer> minimalDaysInFirstWeekComboBox;

    public WeekFieldsViewSkin(WeekFieldsView view) {
        super((Control)view);
        this.dayOfWeekComboBox.getItems().addAll((Object[])DayOfWeek.values());
        this.dayOfWeekComboBox.setValue((Object)view.getFirstDayOfWeek());
        this.minimalDaysInFirstWeekComboBox = new ComboBox();
        this.minimalDaysInFirstWeekComboBox.getItems().addAll((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
        this.minimalDaysInFirstWeekComboBox.setValue((Object)view.getMinimalDaysInFirstWeek());
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"content");
        pane.add((Node)new Label("First day:"), 0, 0);
        pane.add((Node)new Label("Minimum days:"), 0, 1);
        pane.add(this.dayOfWeekComboBox, 1, 0);
        pane.add(this.minimalDaysInFirstWeekComboBox, 1, 1);
        this.getChildren().add((Object)pane);
        InvalidationListener updateListener = it -> this.updateValues();
        this.dayOfWeekComboBox.valueProperty().addListener(updateListener);
        this.minimalDaysInFirstWeekComboBox.valueProperty().addListener(updateListener);
        view.weekFieldsProperty().addListener(it -> {
            WeekFields fields = view.getWeekFields();
            this.dayOfWeekComboBox.setValue((Object)fields.getFirstDayOfWeek());
            this.minimalDaysInFirstWeekComboBox.setValue((Object)fields.getMinimalDaysInFirstWeek());
        });
    }

    private void updateValues() {
        DayOfWeek dayOfWeek = (DayOfWeek)this.dayOfWeekComboBox.getValue();
        Integer minimumNumberOfDays = (Integer)this.minimalDaysInFirstWeekComboBox.getValue();
        ((WeekFieldsView)this.getSkinnable()).setWeekFields(WeekFields.of(dayOfWeek, minimumNumberOfDays));
    }
}

