/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.YearMonthView;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.util.Util;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.util.Callback;

public class YearMonthViewSkin
extends DateControlSkin<YearMonthView>
implements LoadDataSettingsProvider {
    private static final String DAY_OF_WEEK_LABEL = "day-of-week-label";
    private static final String CURRENT_DATE_LABEL = "current-date-label";
    private static final String CURRENT_DATE_BORDER = "current-date-border";
    private static final String USAGE_VERY_LOW = "usage-very-low";
    private static final String USAGE_LOW = "usage-low";
    private static final String USAGE_MEDIUM = "usage-medium";
    private static final String USAGE_HIGH = "usage-high";
    private static final String USAGE_VERY_HIGH = "usage-very-high";
    private static final String TODAY = "today";
    private static final String DAY_OF_MONTH_LABEL = "day-of-month-label";
    private static final String DAY_NOT_OF_MONTH_LABEL = "day-not-of-month-label";
    private static final String WEEKEND_DAY = "weekend-day";
    private static final String SELECTED_MONTH_DATE = "selected-month-date";
    private final GridPane gridPane;
    private final Label monthLabel;
    private final Label yearLabel;
    private final Map<String, YearMonthView.DateCell> cellsMap = new HashMap<String, YearMonthView.DateCell>();
    private final Label[] dayOfWeekLabels = new Label[7];
    private final Label[] weekNumberLabels = new Label[6];
    private final DataLoader dataLoader = new DataLoader(this);
    private YearMonth displayedYearMonth;
    private LocalDate lastSelectedDate;

    public YearMonthViewSkin(YearMonthView view) {
        super(view);
        this.gridPane = new GridPane();
        this.gridPane.setAlignment(Pos.CENTER);
        this.gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.gridPane.getStyleClass().add((Object)"container");
        this.monthLabel = new Label();
        this.monthLabel.getStyleClass().add((Object)"month-label");
        this.monthLabel.visibleProperty().bind((ObservableValue)view.showMonthProperty());
        this.yearLabel = new Label();
        this.yearLabel.getStyleClass().add((Object)"year-label");
        this.yearLabel.visibleProperty().bind((ObservableValue)view.showYearProperty());
        InvalidationListener updateViewListener = evt -> this.updateView();
        view.yearMonthProperty().addListener(evt -> {
            if (this.displayedYearMonth == null || !this.displayedYearMonth.equals(view.getYearMonth())) {
                this.updateView();
            }
        });
        InvalidationListener buildViewListener = evt -> this.buildView();
        view.showTodayProperty().addListener(updateViewListener);
        view.getSelectedDates().addListener(updateViewListener);
        view.showUsageColorsProperty().addListener(it -> this.updateUsageColors("show usage colors flag changed"));
        view.showWeekNumbersProperty().addListener(buildViewListener);
        view.showMonthArrowsProperty().addListener(buildViewListener);
        view.showMonthProperty().addListener(buildViewListener);
        view.showYearProperty().addListener(buildViewListener);
        view.cellFactoryProperty().addListener(buildViewListener);
        view.weekFieldsProperty().addListener(buildViewListener);
        view.showTodayButtonProperty().addListener(buildViewListener);
        view.showYearArrowsProperty().addListener(buildViewListener);
        view.getCalendars().addListener(it -> this.updateUsageColors("list of calendars changed"));
        view.dateProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue.getYear() != newValue.getYear()) {
                this.updateUsageColors("Year has changed.");
            }
        });
        view.suspendUpdatesProperty().addListener(it -> {
            if (!view.isSuspendUpdates()) {
                this.updateUsageColors("suspend update set to false");
            }
        });
        this.getChildren().add((Object)this.gridPane);
        this.updateHyperlinkSupport();
        view.enableHyperlinksProperty().addListener(it -> this.updateHyperlinkSupport());
        this.buildView();
        this.updateVisibility();
        this.updateUsageColors("initial creation of usage colors");
    }

    private void updateHyperlinkSupport() {
        YearMonthView view = (YearMonthView)this.getSkinnable();
        if (view.isEnableHyperlinks()) {
            this.monthLabel.setOnMouseClicked(evt -> {
                if (evt.getClickCount() == 1) {
                    view.fireEvent(new RequestEvent((Object)view, (EventTarget)view, ((YearMonthView)this.getSkinnable()).getYearMonth()));
                }
            });
            this.yearLabel.setOnMouseClicked(evt -> {
                if (evt.getClickCount() == 1) {
                    view.fireEvent(new RequestEvent((Object)view, (EventTarget)view, Year.of(((YearMonthView)this.getSkinnable()).getYearMonth().getYear())));
                }
            });
        } else {
            this.monthLabel.setOnMouseClicked(null);
            this.yearLabel.setOnMouseClicked(null);
        }
    }

    private void updateVisibility() {
        for (int row = 0; row < 6; ++row) {
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setFillHeight(true);
            rowConstraints.setMinHeight(Double.NEGATIVE_INFINITY);
            rowConstraints.setMaxHeight(-1.0);
            rowConstraints.setPrefHeight(-1.0);
            rowConstraints.setVgrow(Priority.ALWAYS);
            this.gridPane.getRowConstraints().add((Object)rowConstraints);
        }
        ColumnConstraints weekColumn = new ColumnConstraints();
        weekColumn.setHalignment(HPos.RIGHT);
        weekColumn.setMaxWidth(-1.0);
        weekColumn.setMinWidth(Double.NEGATIVE_INFINITY);
        weekColumn.setPrefWidth(-1.0);
        weekColumn.setFillWidth(true);
        weekColumn.setHgrow(Priority.NEVER);
        this.gridPane.getColumnConstraints().add((Object)weekColumn);
        for (int col = 0; col < 7; ++col) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setHalignment(HPos.CENTER);
            columnConstraints.setMaxWidth(-1.0);
            columnConstraints.setMinWidth(Double.NEGATIVE_INFINITY);
            columnConstraints.setPrefWidth(-1.0);
            columnConstraints.setFillWidth(true);
            columnConstraints.setHgrow(Priority.ALWAYS);
            this.gridPane.getColumnConstraints().add((Object)columnConstraints);
        }
    }

    @Override
    protected void refreshData() {
        this.updateView();
    }

    @Override
    protected void calendarVisibilityChanged() {
        this.updateUsageColors("calendar visibility changed");
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        this.updateUsageColors("changes in calendar " + calendar.getName());
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            this.updateUsageColors("entry calendar changed");
        }
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        Entry<?> entry;
        if (evt.isDayChange() && (this.isRelevant(entry = evt.getEntry()) || this.isRelevant(evt.getOldInterval()))) {
            this.updateUsageColors("entry interval changed");
        }
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            this.updateUsageColors("entry recurrence rule changed");
        }
    }

    private void buildView() {
        this.gridPane.getChildren().clear();
        YearMonthView view = (YearMonthView)this.getSkinnable();
        BorderPane header = new BorderPane();
        header.getStyleClass().add((Object)"header");
        BorderPane leftHeader = new BorderPane();
        leftHeader.getStyleClass().add((Object)"month-header");
        if (((YearMonthView)this.getSkinnable()).isShowMonth()) {
            if (((YearMonthView)this.getSkinnable()).isShowMonthArrows()) {
                Region prevMonthRegion = new Region();
                BorderPane.setAlignment((Node)prevMonthRegion, (Pos)Pos.CENTER);
                BorderPane.setMargin((Node)prevMonthRegion, (Insets)new Insets(0.0, 6.0, 0.0, 6.0));
                prevMonthRegion.getStyleClass().add((Object)"previous-button");
                leftHeader.setLeft((Node)prevMonthRegion);
                prevMonthRegion.setOnMouseClicked(evt -> ((YearMonthView)this.getSkinnable()).setDate(((YearMonthView)this.getSkinnable()).getDate().minusMonths(1L)));
            }
            leftHeader.setCenter((Node)this.monthLabel);
            if (((YearMonthView)this.getSkinnable()).isShowMonthArrows()) {
                Region nextMonthRegion = new Region();
                BorderPane.setAlignment((Node)nextMonthRegion, (Pos)Pos.CENTER);
                BorderPane.setMargin((Node)nextMonthRegion, (Insets)new Insets(0.0, 6.0, 0.0, 6.0));
                nextMonthRegion.getStyleClass().add((Object)"next-button");
                leftHeader.setRight((Node)nextMonthRegion);
                nextMonthRegion.setOnMouseClicked(evt -> ((YearMonthView)this.getSkinnable()).setDate(((YearMonthView)this.getSkinnable()).getDate().plusMonths(1L)));
            }
            header.setLeft((Node)leftHeader);
        }
        if (((YearMonthView)this.getSkinnable()).isShowYear()) {
            BorderPane rightHeader = new BorderPane();
            rightHeader.getStyleClass().add((Object)"year-header");
            if (((YearMonthView)this.getSkinnable()).isShowYearArrows()) {
                Region prevYearRegion = new Region();
                BorderPane.setAlignment((Node)prevYearRegion, (Pos)Pos.CENTER);
                BorderPane.setMargin((Node)prevYearRegion, (Insets)new Insets(0.0, 6.0, 0.0, 6.0));
                prevYearRegion.getStyleClass().add((Object)"previous-button");
                rightHeader.setLeft((Node)prevYearRegion);
                prevYearRegion.setOnMouseClicked(evt -> ((YearMonthView)this.getSkinnable()).setDate(((YearMonthView)this.getSkinnable()).getDate().minusYears(1L)));
            }
            rightHeader.setCenter((Node)this.yearLabel);
            if (((YearMonthView)this.getSkinnable()).isShowYearArrows()) {
                Region nextYearRegion = new Region();
                BorderPane.setAlignment((Node)nextYearRegion, (Pos)Pos.CENTER);
                BorderPane.setMargin((Node)nextYearRegion, (Insets)new Insets(0.0, 6.0, 0.0, 6.0));
                nextYearRegion.getStyleClass().add((Object)"next-button");
                rightHeader.setRight((Node)nextYearRegion);
                nextYearRegion.setOnMouseClicked(evt -> ((YearMonthView)this.getSkinnable()).setDate(((YearMonthView)this.getSkinnable()).getDate().plusYears(1L)));
            }
            header.setRight((Node)rightHeader);
        }
        GridPane.setColumnSpan((Node)header, (Integer)7);
        this.gridPane.add((Node)header, 1, 0);
        DayOfWeek dayOfWeek = view.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            this.dayOfWeekLabels[i] = new Label(dayOfWeek.getDisplayName(TextStyle.SHORT, Locale.getDefault()));
            this.dayOfWeekLabels[i].setAlignment(Pos.CENTER);
            this.dayOfWeekLabels[i].setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.dayOfWeekLabels[i].getStyleClass().add((Object)DAY_OF_WEEK_LABEL);
            this.gridPane.add((Node)this.dayOfWeekLabels[i], i + 1, 1);
            dayOfWeek = dayOfWeek.plus(1L);
        }
        DayOfWeek firstDayOfWeek = ((YearMonthView)this.getSkinnable()).getFirstDayOfWeek();
        LocalDate date = this.getLoadStartDate();
        date = Util.adjustToFirstDayOfWeek(date, firstDayOfWeek);
        if (((YearMonthView)this.getSkinnable()).isShowWeekNumbers()) {
            for (int i = 0; i < 6; ++i) {
                this.weekNumberLabels[i] = new Label();
                this.weekNumberLabels[i].setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                this.weekNumberLabels[i].setAlignment(Pos.CENTER_RIGHT);
                this.weekNumberLabels[i].getStyleClass().add((Object)"week-label");
                this.gridPane.add((Node)this.weekNumberLabels[i], 0, 2 + i);
                date = date.plusWeeks(1L);
            }
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                Callback<YearMonthView, YearMonthView.DateCell> cellFactory = view.getCellFactory();
                YearMonthView.DateCell cell = (YearMonthView.DateCell)((Object)cellFactory.call((Object)((YearMonthView)this.getSkinnable())));
                GridPane.setHgrow((Node)cell, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)cell, (Priority)Priority.ALWAYS);
                cell.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> this.handleMouseClick((MouseEvent)evt, (Node)cell, cell.getDate()));
                cell.getStyleClass().add((Object)"month-day");
                this.cellsMap.put(this.getKey(row, col), cell);
                this.gridPane.add((Node)cell, col + 1, row + 2);
                date = date.plusDays(1L);
            }
        }
        if (((YearMonthView)this.getSkinnable()).isShowTodayButton()) {
            Button button = new Button(Messages.getString("YearMonthViewSkin.TODAY"));
            this.gridPane.add((Node)button, 0, 9);
            GridPane.setColumnSpan((Node)button, (Integer)8);
            GridPane.setHalignment((Node)button, (HPos)HPos.CENTER);
            GridPane.setMargin((Node)button, (Insets)new Insets(6.0, 0.0, 0.0, 0.0));
            button.setOnAction(evt -> ((YearMonthView)this.getSkinnable()).setDate(((YearMonthView)this.getSkinnable()).getToday()));
        }
        this.updateView();
    }

    private String getKey(int row, int col) {
        return row + "/" + col;
    }

    private void updateView() {
        YearMonth yearMonth;
        this.lastSelectedDate = null;
        YearMonthView view = (YearMonthView)this.getSkinnable();
        this.displayedYearMonth = yearMonth = view.getYearMonth();
        boolean currentYearMonth = ((YearMonthView)this.getSkinnable()).getYearMonth().equals(YearMonth.from(((YearMonthView)this.getSkinnable()).getToday()));
        this.monthLabel.getStyleClass().remove((Object)CURRENT_DATE_LABEL);
        this.yearLabel.getStyleClass().remove((Object)CURRENT_DATE_LABEL);
        if (currentYearMonth && view.isShowToday()) {
            this.monthLabel.getStyleClass().add((Object)CURRENT_DATE_LABEL);
            this.yearLabel.getStyleClass().add((Object)CURRENT_DATE_LABEL);
        }
        this.monthLabel.setText(DateTimeFormatter.ofPattern(Messages.getString("YearMonthViewSkin.MONTH_FORMAT")).format(yearMonth));
        this.yearLabel.setText(DateTimeFormatter.ofPattern(Messages.getString("YearMonthViewSkin.YEAR_FORMAT")).format(yearMonth));
        DayOfWeek dayOfWeek = view.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            if (!view.isShowToday()) continue;
            if (currentYearMonth) {
                this.dayOfWeekLabels[i].getStyleClass().add((Object)CURRENT_DATE_BORDER);
            } else {
                this.dayOfWeekLabels[i].getStyleClass().removeAll((Object[])new String[]{CURRENT_DATE_BORDER});
            }
            if (!currentYearMonth || !view.getToday().getDayOfWeek().equals(dayOfWeek)) continue;
            this.dayOfWeekLabels[i].getStyleClass().add((Object)CURRENT_DATE_LABEL);
        }
        DayOfWeek firstDayOfWeek = ((YearMonthView)this.getSkinnable()).getFirstDayOfWeek();
        LocalDate date = Util.adjustToFirstDayOfWeek(this.getLoadStartDate(), firstDayOfWeek);
        if (((YearMonthView)this.getSkinnable()).isShowWeekNumbers()) {
            for (int i = 0; i < 6; ++i) {
                int weekOfYear = date.get(((YearMonthView)this.getSkinnable()).getWeekFields().weekOfYear());
                this.weekNumberLabels[i].setText(Integer.toString(weekOfYear));
                date = date.plusWeeks(1L);
            }
        }
        date = Util.adjustToFirstDayOfWeek(this.getLoadStartDate(), firstDayOfWeek);
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                LocalDate localDate = LocalDate.from(date);
                YearMonthView.DateCell cell = this.cellsMap.get(this.getKey(row, col));
                cell.setDate(localDate);
                cell.getStyleClass().removeAll((Object[])new String[]{TODAY, DAY_OF_MONTH_LABEL, DAY_NOT_OF_MONTH_LABEL, WEEKEND_DAY, SELECTED_MONTH_DATE});
                if (((YearMonthView)this.getSkinnable()).getSelectedDates().contains((Object)date)) {
                    cell.getStyleClass().add((Object)SELECTED_MONTH_DATE);
                }
                if (YearMonth.from(date).equals(YearMonth.from(((YearMonthView)this.getSkinnable()).getDate()))) {
                    if (((YearMonthView)this.getSkinnable()).isShowToday() && date.equals(((YearMonthView)this.getSkinnable()).getToday())) {
                        cell.getStyleClass().addAll((Object[])new String[]{DAY_OF_MONTH_LABEL, TODAY});
                    } else {
                        cell.getStyleClass().add((Object)DAY_OF_MONTH_LABEL);
                    }
                } else {
                    cell.getStyleClass().add((Object)DAY_NOT_OF_MONTH_LABEL);
                }
                if (view.getWeekendDays().contains((Object)date.getDayOfWeek())) {
                    cell.getStyleClass().add((Object)WEEKEND_DAY);
                }
                date = date.plusDays(1L);
            }
        }
    }

    private void handleMouseClick(MouseEvent evt, Node node, LocalDate date) {
        switch (evt.getClickCount()) {
            case 1: {
                this.handleSingleClick(evt, node, date);
                break;
            }
            case 2: {
                if (!((YearMonthView)this.getSkinnable()).isEnableHyperlinks()) break;
                this.handleDoubleClick(date);
                break;
            }
        }
    }

    private void handleSingleClick(MouseEvent evt, Node node, LocalDate date) {
        if (evt.getButton() != MouseButton.PRIMARY) {
            return;
        }
        YearMonthView view = (YearMonthView)this.getSkinnable();
        switch (view.getClickBehaviour()) {
            case NONE: {
                break;
            }
            case SHOW_DETAILS: {
                Callback<DateControl.DateDetailsParameter, Boolean> callback = view.getDateDetailsCallback();
                if (callback == null) break;
                callback.call((Object)new DateControl.DateDetailsParameter((InputEvent)evt, view, node, (Node)node.getScene().getRoot(), date, evt.getScreenX(), evt.getScreenY()));
                break;
            }
            case PERFORM_SELECTION: {
                boolean multiSelect;
                boolean bl = multiSelect = evt.isShiftDown() || evt.isShortcutDown();
                if (!multiSelect || view.getSelectionMode().equals((Object)SelectionMode.SINGLE) && !evt.isControlDown()) {
                    view.getSelectedDates().clear();
                }
                if (evt.isShiftDown()) {
                    if (this.lastSelectedDate != null) {
                        LocalDate st = this.lastSelectedDate;
                        LocalDate et = date;
                        if (date.isBefore(st)) {
                            st = date;
                            et = this.lastSelectedDate;
                        }
                        do {
                            view.getSelectedDates().add((Object)st);
                        } while (!et.isBefore(st = st.plusDays(1L)));
                    } else {
                        view.getSelectedDates().clear();
                        view.getSelectedDates().add((Object)date);
                    }
                } else if (view.getSelectedDates().contains((Object)date)) {
                    view.getSelectedDates().remove((Object)date);
                } else {
                    view.getSelectedDates().add((Object)date);
                }
                this.lastSelectedDate = date;
                if (date.getMonth().equals(view.getYearMonth().getMonth())) break;
                view.setDate(date);
                break;
            }
        }
    }

    private void handleDoubleClick(LocalDate date) {
        YearMonthView view = (YearMonthView)this.getSkinnable();
        view.fireEvent(new RequestEvent((Object)view, (EventTarget)view, date));
    }

    private void updateUsageColors(String reason) {
        this.cellsMap.values().forEach(control -> control.getStyleClass().removeAll((Object[])new String[]{USAGE_VERY_LOW, USAGE_LOW, USAGE_MEDIUM, USAGE_HIGH, USAGE_VERY_HIGH}));
        if (!((YearMonthView)this.getSkinnable()).isShowUsageColors()) {
            return;
        }
        LoggingDomain.VIEW.fine("updating colors: reason = " + reason + ", year month = " + ((YearMonthView)this.getSkinnable()).getYearMonth());
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        block7: for (String key : this.cellsMap.keySet()) {
            YearMonthView.DateCell cell = this.cellsMap.get(key);
            LocalDate date = cell.getDate();
            if (date.isEqual(((YearMonthView)this.getSkinnable()).getToday()) && ((YearMonthView)this.getSkinnable()).isShowToday()) continue;
            int entryCount = 0;
            List entries = (List)dataMap.get(date);
            if (entries != null) {
                entryCount = entries.size();
            }
            Callback<Integer, DateControl.Usage> usagePolicy = ((YearMonthView)this.getSkinnable()).getUsagePolicy();
            switch ((DateControl.Usage)((Object)usagePolicy.call((Object)entryCount))) {
                case NONE: {
                    continue block7;
                }
                case VERY_LOW: {
                    cell.getStyleClass().add((Object)USAGE_VERY_LOW);
                    continue block7;
                }
                case LOW: {
                    cell.getStyleClass().add((Object)USAGE_LOW);
                    continue block7;
                }
                case MEDIUM: {
                    cell.getStyleClass().add((Object)USAGE_MEDIUM);
                    continue block7;
                }
                case HIGH: {
                    cell.getStyleClass().add((Object)USAGE_HIGH);
                    continue block7;
                }
            }
            cell.getStyleClass().add((Object)USAGE_VERY_HIGH);
        }
    }

    @Override
    public String getLoaderName() {
        return "Year Month View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        return Util.adjustToFirstDayOfWeek(((YearMonthView)this.getSkinnable()).getDate().withDayOfMonth(1), ((YearMonthView)this.getSkinnable()).getFirstDayOfWeek());
    }

    @Override
    public LocalDate getLoadEndDate() {
        return this.getLoadStartDate().plusDays(41L);
    }

    @Override
    public ZoneId getZoneId() {
        return ((YearMonthView)this.getSkinnable()).getZoneId();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        YearMonthView view = (YearMonthView)this.getSkinnable();
        return view.getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((YearMonthView)this.getSkinnable()).isCalendarVisible(calendar);
    }
}

