/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.page;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.page.PageBase;
import impl.com.calendarfx.view.NavigateDateView;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;

public abstract class PageBaseSkin<C extends PageBase>
extends SkinBase<C> {
    private final Text dateText;
    private final BorderPane headerPane;
    private final BorderPane borderPane;

    public PageBaseSkin(C page) {
        super(page);
        NavigateDateView navigateDateButton = new NavigateDateView();
        navigateDateButton.getTodayButton().setText(Messages.getString("PageBaseSkin.TODAY"));
        navigateDateButton.setOnBackward(() -> page.goBack());
        navigateDateButton.setOnForward(() -> page.goForward());
        navigateDateButton.setOnToday(() -> page.goToday());
        navigateDateButton.visibleProperty().bind((ObservableValue)((PageBase)((Object)page)).showNavigationProperty());
        this.dateText = new Text("Date");
        this.dateText.getStyleClass().add((Object)"date-text");
        this.dateText.visibleProperty().bind((ObservableValue)((PageBase)((Object)page)).showDateProperty());
        ((DateControl)((Object)page)).dateProperty().addListener(evt -> this.updateDateText());
        BorderPane.setMargin((Node)navigateDateButton, (Insets)new Insets(10.0));
        BorderPane.setMargin((Node)this.dateText, (Insets)new Insets(10.0));
        BorderPane.setAlignment((Node)navigateDateButton, (Pos)Pos.CENTER_LEFT);
        BorderPane.setAlignment((Node)this.dateText, (Pos)Pos.CENTER_RIGHT);
        this.headerPane = new BorderPane();
        this.headerPane.getStyleClass().add((Object)"header");
        this.headerPane.setLeft((Node)navigateDateButton);
        this.headerPane.setRight((Node)this.dateText);
        Node content = this.createContent();
        content.getStyleClass().add((Object)"content");
        content.sceneProperty().addListener(it -> {
            if (content.getScene() != null) {
                content.applyCss();
            }
        });
        this.borderPane = new BorderPane();
        this.borderPane.getStyleClass().add((Object)"container");
        this.borderPane.setCenter(content);
        this.getChildren().add((Object)this.borderPane);
        this.updateDateText();
        this.updateHeaderVisibility();
        ((PageBase)((Object)page)).showDateProperty().addListener(it -> this.updateHeaderVisibility());
        ((PageBase)((Object)page)).showNavigationProperty().addListener(it -> this.updateHeaderVisibility());
    }

    private void updateHeaderVisibility() {
        if (((PageBase)this.getSkinnable()).isShowDate() || ((PageBase)this.getSkinnable()).isShowNavigation()) {
            this.borderPane.setTop((Node)this.headerPane);
        } else {
            this.borderPane.setTop(null);
        }
    }

    private void updateDateText() {
        DateTimeFormatter formatter = ((PageBase)this.getSkinnable()).getDateTimeFormatter();
        String text = formatter.format(((PageBase)this.getSkinnable()).getDate());
        this.dateText.setText(text);
    }

    protected abstract Node createContent();
}

