/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.print;

import com.calendarfx.view.Messages;
import com.calendarfx.view.print.PaperView;
import com.calendarfx.view.print.ViewType;
import impl.com.calendarfx.view.NumericTextField;
import javafx.beans.property.Property;
import javafx.print.Paper;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;

public class PaperViewSkin
extends SkinBase<PaperView> {
    private final GridPane gridPane;
    private GridPane marginsGridPane;

    public PaperViewSkin(final PaperView control) {
        super((Control)control);
        ComboBox viewTypeComboBox = new ComboBox();
        viewTypeComboBox.setMaxWidth(Double.MAX_VALUE);
        viewTypeComboBox.getItems().setAll((Object[])ViewType.values());
        viewTypeComboBox.valueProperty().bindBidirectional(control.viewTypeProperty());
        viewTypeComboBox.setConverter((StringConverter)new StringConverter<ViewType>(){

            public String toString(ViewType object) {
                return Messages.getString(object.getMessageKey());
            }

            public ViewType fromString(String string) {
                if (string != null) {
                    for (ViewType type : ViewType.values()) {
                        if (!string.equals(Messages.getString(type.getMessageKey()))) continue;
                        return type;
                    }
                }
                return null;
            }
        });
        ComboBox paperComboBox = new ComboBox();
        paperComboBox.setMaxWidth(Double.MAX_VALUE);
        paperComboBox.setItems(control.getAvailablePapers());
        paperComboBox.valueProperty().bindBidirectional(control.paperProperty());
        paperComboBox.setConverter((StringConverter)new StringConverter<Paper>(){

            public String toString(Paper object) {
                return object.getName();
            }

            public Paper fromString(String string) {
                if (string != null) {
                    for (Paper paper : control.getAvailablePapers()) {
                        if (!string.equals(paper.getName())) continue;
                        return paper;
                    }
                }
                return null;
            }
        });
        ComboBox marginTypeComboBox = new ComboBox();
        marginTypeComboBox.setMaxWidth(Double.MAX_VALUE);
        marginTypeComboBox.getItems().setAll((Object[])PaperView.MarginType.values());
        marginTypeComboBox.valueProperty().bindBidirectional(control.marginTypeProperty());
        marginTypeComboBox.setConverter((StringConverter)new StringConverter<PaperView.MarginType>(){

            public String toString(PaperView.MarginType type) {
                switch (type) {
                    case CUSTOM: {
                        return Messages.getString("Margin.CUSTOM");
                    }
                    case DEFAULT: {
                        return Messages.getString("Margin.DEFAULT");
                    }
                    case MINIMUM: {
                        return Messages.getString("Margin.MINIMUM");
                    }
                }
                return "Unknown margin type";
            }

            public PaperView.MarginType fromString(String string) {
                return null;
            }
        });
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"container");
        this.gridPane.add((Node)new Label(Messages.getString("PaperViewSkin.VIEW_TYPE_LABEL")), 0, 0);
        this.gridPane.add((Node)viewTypeComboBox, 1, 0);
        this.gridPane.add((Node)new Label(Messages.getString("PaperViewSkin.PAPER_LABEL")), 0, 1);
        this.gridPane.add((Node)paperComboBox, 1, 1);
        if (control.isShowMargin()) {
            this.gridPane.add((Node)new Label(Messages.getString("PaperViewSkin.MARGIN_LABEL")), 0, 2);
            this.gridPane.add((Node)marginTypeComboBox, 1, 2);
        }
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        GridPane.setFillWidth((Node)paperComboBox, (Boolean)true);
        GridPane.setFillWidth((Node)viewTypeComboBox, (Boolean)true);
        this.getChildren().add((Object)this.gridPane);
        control.marginTypeProperty().addListener(it -> this.updateVisibility());
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (((PaperView)this.getSkinnable()).getMarginType().equals((Object)PaperView.MarginType.CUSTOM)) {
            if (this.marginsGridPane == null) {
                this.createMarginFields();
            }
            this.gridPane.add((Node)this.marginsGridPane, 1, 3);
        } else if (this.marginsGridPane != null) {
            this.gridPane.getChildren().remove((Object)this.marginsGridPane);
        }
    }

    private void createMarginFields() {
        NumericTextField topField = new NumericTextField();
        NumericTextField rightField = new NumericTextField();
        NumericTextField bottomField = new NumericTextField();
        NumericTextField leftField = new NumericTextField();
        NumberStringConverter converter = new NumberStringConverter();
        leftField.textProperty().bindBidirectional((Property)((PaperView)this.getSkinnable()).leftMarginProperty(), (StringConverter)converter);
        rightField.textProperty().bindBidirectional((Property)((PaperView)this.getSkinnable()).rightMarginProperty(), (StringConverter)converter);
        topField.textProperty().bindBidirectional((Property)((PaperView)this.getSkinnable()).topMarginProperty(), (StringConverter)converter);
        bottomField.textProperty().bindBidirectional((Property)((PaperView)this.getSkinnable()).bottomMarginProperty(), (StringConverter)converter);
        this.marginsGridPane = new GridPane();
        this.marginsGridPane.getStyleClass().add((Object)"custom-fields");
        this.marginsGridPane.add((Node)new Label(Messages.getString("MarginSelector.TOP")), 0, 0);
        this.marginsGridPane.add((Node)topField, 1, 0);
        this.marginsGridPane.add((Node)new Label(Messages.getString("MarginSelector.RIGHT")), 2, 0);
        this.marginsGridPane.add((Node)rightField, 3, 0);
        this.marginsGridPane.add((Node)new Label(Messages.getString("MarginSelector.BOTTOM")), 0, 1);
        this.marginsGridPane.add((Node)bottomField, 1, 1);
        this.marginsGridPane.add((Node)new Label(Messages.getString("MarginSelector.LEFT")), 2, 1);
        this.marginsGridPane.add((Node)leftField, 3, 1);
    }
}

