/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.print;

import com.calendarfx.view.Messages;
import com.calendarfx.view.print.PreviewPane;
import com.calendarfx.view.print.PrintablePage;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome.FontAwesome;
import org.kordamp.ikonli.javafx.FontIcon;

public class PreviewPaneSkin
extends SkinBase<PreviewPane> {
    public PreviewPaneSkin(PreviewPane control) {
        super((Control)control);
        Slider slider = new Slider();
        slider.setMin(1.0);
        slider.setMax(5.0);
        slider.valueProperty().bindBidirectional((Property)control.getZoomPane().zoomProperty());
        BorderPane center = new BorderPane();
        center.setCenter((Node)control.getZoomPane());
        center.getStyleClass().add((Object)"center");
        PrintablePage page = control.getPrintablePage();
        FontIcon backIcon = new FontIcon((Ikon)FontAwesome.CHEVRON_LEFT);
        FontIcon forwardIcon = new FontIcon((Ikon)FontAwesome.CHEVRON_RIGHT);
        Button backBtn = new Button();
        backBtn.setGraphic((Node)backIcon);
        backBtn.setOnAction(evt -> page.back());
        backBtn.disableProperty().bind((ObservableValue)Bindings.equal((int)1, (ObservableNumberValue)page.pageNumberProperty()));
        Button nextBtn = new Button();
        nextBtn.setGraphic((Node)forwardIcon);
        nextBtn.setOnAction(evt -> page.next());
        nextBtn.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)page.pageNumberProperty(), (ObservableNumberValue)page.totalPagesProperty()));
        Label pagesLbl = new Label();
        pagesLbl.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> page.getPageNumber() + "/" + page.getTotalPages(), (Observable[])new Observable[]{page.pageNumberProperty(), page.totalPagesProperty()}));
        HBox bottom = new HBox(new Node[]{new Label(Messages.getString("PreviewPaneSkin.ZOOM_LABEL")), slider, backBtn, pagesLbl, nextBtn});
        bottom.setAlignment(Pos.CENTER_RIGHT);
        bottom.getStyleClass().add((Object)"footer");
        BorderPane container = new BorderPane();
        container.getStyleClass().add((Object)"container");
        container.setCenter((Node)center);
        container.setBottom((Node)bottom);
        this.getChildren().add((Object)container);
    }
}

