/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.print;

import com.calendarfx.view.print.ZoomPane;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class ZoomPaneSkin
extends SkinBase<ZoomPane> {
    private static final double INITIAL_SCALE_FACTOR = 0.98;
    private final DoubleProperty scale = new SimpleDoubleProperty();
    private final DoubleProperty scaleX = new SimpleDoubleProperty();
    private final DoubleProperty scaleY = new SimpleDoubleProperty();
    private double mouseX;
    private double mouseY;

    public ZoomPaneSkin(ZoomPane pane) {
        super((Control)pane);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)pane.widthProperty());
        clip.heightProperty().bind((ObservableValue)pane.heightProperty());
        pane.setClip((Node)clip);
        pane.contentProperty().addListener((obs, oldValue, newValue) -> this.updateView((Region)oldValue, (Region)newValue));
        pane.zoomProperty().addListener(obs -> ((ZoomPane)this.getSkinnable()).requestLayout());
        this.updateView(null, pane.getContent());
    }

    private void updateView(Region oldValue, Region newValue) {
        if (oldValue != null) {
            oldValue.scaleXProperty().unbind();
            oldValue.scaleYProperty().unbind();
            oldValue.setOnMousePressed(null);
            oldValue.setOnMouseDragged(null);
        }
        Objects.requireNonNull(newValue);
        newValue.setManaged(false);
        newValue.addEventFilter(MouseEvent.MOUSE_PRESSED, evt -> {
            this.mouseX = evt.getSceneX();
            this.mouseY = evt.getSceneY();
        });
        newValue.addEventFilter(MouseEvent.MOUSE_DRAGGED, evt -> {
            double deltaX = evt.getSceneX() - this.mouseX;
            double deltaY = evt.getSceneY() - this.mouseY;
            newValue.relocate(newValue.getLayoutX() + deltaX, newValue.getLayoutY() + deltaY);
            this.mouseX = evt.getSceneX();
            this.mouseY = evt.getSceneY();
        });
        this.scale.unbind();
        this.scale.bind((ObservableValue)Bindings.multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.scaleX, (ObservableNumberValue)this.scaleY), (ObservableNumberValue)((ZoomPane)this.getSkinnable()).zoomProperty()));
        this.scaleX.unbind();
        this.scaleX.bind((ObservableValue)Bindings.min((int)1, (ObservableNumberValue)Bindings.divide((ObservableNumberValue)Bindings.multiply((double)0.98, (ObservableNumberValue)((ZoomPane)this.getSkinnable()).widthProperty()), (ObservableNumberValue)newValue.widthProperty())));
        this.scaleY.unbind();
        this.scaleY.bind((ObservableValue)Bindings.min((int)1, (ObservableNumberValue)Bindings.divide((ObservableNumberValue)Bindings.multiply((double)0.98, (ObservableNumberValue)((ZoomPane)this.getSkinnable()).heightProperty()), (ObservableNumberValue)newValue.heightProperty())));
        newValue.scaleXProperty().bind((ObservableValue)this.scale);
        newValue.scaleYProperty().bind((ObservableValue)this.scale);
        this.getChildren().setAll((Object[])new Node[]{newValue});
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        Region content = Objects.requireNonNull(((ZoomPane)this.getSkinnable()).getContent());
        double w = content.getPrefWidth();
        double h = content.getPrefHeight();
        double mx = contentX + contentWidth / 2.0;
        double my = contentY + contentHeight / 2.0;
        content.resizeRelocate(mx - w / 2.0, my - h / 2.0, w, h);
    }
}

