/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.TimeBoundsCluster;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class TimeBoundsResolver {
    private static Comparator<EntryViewBase<?>> additionalComparator;

    public static Comparator<EntryViewBase<?>> getAdditionalComparator() {
        return additionalComparator;
    }

    public static void setAdditionalComparator(Comparator<EntryViewBase<?>> additionalComparator) {
        TimeBoundsResolver.additionalComparator = additionalComparator;
    }

    public static <T extends EntryViewBase> List<Placement> resolve(List<T> entryViews) {
        Comparator comparator = (o1, o2) -> {
            int result = o1.compareTo(o2);
            if (result == 0 && additionalComparator != null) {
                return additionalComparator.compare((EntryViewBase<?>)o1, (EntryViewBase<?>)o2);
            }
            return 0;
        };
        entryViews.sort(comparator);
        ArrayList<Placement> placements = new ArrayList<Placement>();
        ArrayList<TimeBoundsCluster> clusters = new ArrayList<TimeBoundsCluster>();
        TimeBoundsCluster cluster = null;
        for (EntryViewBase view : entryViews) {
            if (!view.isVisible()) continue;
            if (cluster == null || !cluster.intersects(view)) {
                cluster = new TimeBoundsCluster();
                clusters.add(cluster);
            }
            cluster.add(view);
        }
        for (TimeBoundsCluster c : new ArrayList(clusters)) {
            placements.addAll(c.resolve());
        }
        return placements;
    }
}

