/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import com.calendarfx.view.Messages;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.Pane;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.transform.recurrence.Frequency;

public final class Util {
    public static boolean removeChildren(Pane parent, Predicate<Node> predicate) {
        ArrayList<Node> list = new ArrayList<Node>(parent.getChildrenUnmodifiable().stream().filter(predicate.negate()).collect(Collectors.toList()));
        boolean childrenWereRemoved = list.removeIf(predicate);
        if (list.isEmpty()) {
            parent.getChildren().clear();
        } else {
            parent.getChildren().setAll(list);
        }
        return childrenWereRemoved;
    }

    public static boolean removeChildren(Group group, Predicate<Node> predicate) {
        ArrayList<Node> list = new ArrayList<Node>((Collection<Node>)group.getChildren());
        boolean childrenWereRemoved = list.removeIf(predicate);
        if (list.isEmpty()) {
            if (!group.getChildren().isEmpty()) {
                group.getChildren().clear();
            }
        } else {
            group.getChildren().setAll(list);
        }
        return childrenWereRemoved;
    }

    public static boolean intersect(LocalDate aStart, LocalDate aEnd, LocalDate bStart, LocalDate bEnd) {
        if (aStart.equals(bStart) || aEnd.equals(bEnd)) {
            return true;
        }
        return aStart.isBefore(bEnd) && aEnd.isAfter(bStart);
    }

    public static boolean intersect(LocalTime aStart, LocalTime aEnd, LocalTime bStart, LocalTime bEnd) {
        if (aStart.equals(bStart) || aEnd.equals(bEnd)) {
            return true;
        }
        return aStart.isBefore(bEnd) && aEnd.isAfter(bStart);
    }

    public static boolean intersect(ZonedDateTime aStart, ZonedDateTime aEnd, ZonedDateTime bStart, ZonedDateTime bEnd) {
        if (aStart.equals(bStart) || aEnd.equals(bEnd)) {
            return true;
        }
        return aStart.isBefore(bEnd) && aEnd.isAfter(bStart);
    }

    public static LocalDateTime truncate(LocalDateTime time, ChronoUnit unit, int stepRate, DayOfWeek firstDayOfWeek) {
        switch (unit) {
            case DAYS: {
                return Util.adjustField(time, ChronoField.DAY_OF_YEAR, stepRate).truncatedTo(unit);
            }
            case HALF_DAYS: {
                return time.truncatedTo(unit);
            }
            case HOURS: {
                return Util.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return Util.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return Util.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return Util.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return Util.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return Util.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MONTHS: {
                return time.with(ChronoField.MONTH_OF_YEAR, Math.max(1, time.get(ChronoField.MONTH_OF_YEAR) - time.get(ChronoField.MONTH_OF_YEAR) % stepRate)).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            case YEARS: {
                return Util.adjustField(time, ChronoField.YEAR, stepRate).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case WEEKS: {
                return time.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue()).truncatedTo(ChronoUnit.DAYS);
            }
            case DECADES: {
                int decade = time.getYear() / 10 * 10;
                return time.with(ChronoField.YEAR, decade).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case CENTURIES: {
                int century = time.getYear() / 100 * 100;
                return time.with(ChronoField.YEAR, century).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case MILLENNIA: {
                int millenium = time.getYear() / 1000 * 1000;
                return time.with(ChronoField.YEAR, millenium).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
        }
        return time;
    }

    public static ZonedDateTime truncate(ZonedDateTime time, ChronoUnit unit, int stepRate, DayOfWeek firstDayOfWeek) {
        switch (unit) {
            case DAYS: {
                return Util.adjustField(time, ChronoField.DAY_OF_YEAR, stepRate).truncatedTo(unit);
            }
            case HALF_DAYS: {
                return time.truncatedTo(unit);
            }
            case HOURS: {
                return Util.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return Util.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return Util.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return Util.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return Util.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return Util.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MONTHS: {
                return time.with(ChronoField.MONTH_OF_YEAR, Math.max(1, time.get(ChronoField.MONTH_OF_YEAR) - time.get(ChronoField.MONTH_OF_YEAR) % stepRate)).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            case YEARS: {
                return Util.adjustField(time, ChronoField.YEAR, stepRate).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case WEEKS: {
                return time.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue()).truncatedTo(ChronoUnit.DAYS);
            }
            case DECADES: {
                int decade = time.getYear() / 10 * 10;
                return time.with(ChronoField.YEAR, decade).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case CENTURIES: {
                int century = time.getYear() / 100 * 100;
                return time.with(ChronoField.YEAR, century).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case MILLENNIA: {
                int millenium = time.getYear() / 1000 * 1000;
                return time.with(ChronoField.YEAR, millenium).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
        }
        return time;
    }

    public static LocalTime truncate(LocalTime time, ChronoUnit unit, int stepRate) {
        switch (unit) {
            case HOURS: {
                return Util.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return Util.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return Util.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return Util.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return Util.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return Util.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
        }
        return time;
    }

    public static void runInFXThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    private static ZonedDateTime adjustField(ZonedDateTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    private static LocalDateTime adjustField(LocalDateTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    private static LocalTime adjustField(LocalTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    public static <T> MultipleSelectionModel<T> createEmptySelectionModel() {
        return new EmptySelectionModel();
    }

    public static String convertRFC2445ToText(String rrule, LocalDate startDate) {
        try {
            int count;
            List byDay;
            String granularities;
            String granularity;
            Recur rule = new Recur(rrule.replaceFirst("^RRULE:", ""));
            StringBuilder sb = new StringBuilder();
            switch (rule.getFrequency()) {
                case DAILY: {
                    granularity = Messages.getString("Util.DAY");
                    granularities = Messages.getString("Util.DAYS");
                    break;
                }
                case MONTHLY: {
                    granularity = Messages.getString("Util.MONTH");
                    granularities = Messages.getString("Util.MONTHS");
                    break;
                }
                case WEEKLY: {
                    granularity = Messages.getString("Util.WEEK");
                    granularities = Messages.getString("Util.WEEKS");
                    break;
                }
                case YEARLY: {
                    granularity = Messages.getString("Util.YEAR");
                    granularities = Messages.getString("Util.YEARS");
                    break;
                }
                case HOURLY: {
                    granularity = Messages.getString("Util.HOUR");
                    granularities = Messages.getString("Util.HOURS");
                    break;
                }
                case MINUTELY: {
                    granularity = Messages.getString("Util.MINUTE");
                    granularities = Messages.getString("Util.MINUTES");
                    break;
                }
                case SECONDLY: {
                    granularity = Messages.getString("Util.SECOND");
                    granularities = Messages.getString("Util.SECONDS");
                    break;
                }
                default: {
                    granularity = "";
                    granularities = "";
                }
            }
            int interval = rule.getInterval();
            if (interval > 1) {
                sb.append(MessageFormat.format(Messages.getString("Util.EVERY_PLURAL"), rule.getInterval(), granularities));
            } else {
                sb.append(MessageFormat.format(Messages.getString("Util.EVERY_SINGULAR"), granularity));
            }
            if (rule.getFrequency().equals((Object)Frequency.WEEKLY) && !(byDay = rule.getDayList()).isEmpty()) {
                sb.append(Messages.getString("Util.ON_WEEKDAY"));
                for (int i = 0; i < byDay.size(); ++i) {
                    WeekDay num = (WeekDay)byDay.get(i);
                    sb.append(Util.makeHuman(num.getDay()));
                    if (i >= byDay.size() - 1) continue;
                    sb.append(", ");
                }
            }
            if (rule.getFrequency().equals((Object)Frequency.MONTHLY)) {
                if (!rule.getMonthDayList().isEmpty()) {
                    int day = (Integer)rule.getMonthDayList().get(0);
                    sb.append(Messages.getString("Util.ON_MONTH_DAY"));
                    sb.append(day);
                } else if (!rule.getDayList().isEmpty()) {
                    WeekDay num = (WeekDay)rule.getDayList().get(0);
                    sb.append(MessageFormat.format(Messages.getString("Util.ON_MONTH_WEEKDAY"), Util.makeHuman(num.getOffset()), Util.makeHuman(num.getDay())));
                }
            }
            if (rule.getFrequency().equals((Object)Frequency.YEARLY)) {
                sb.append(MessageFormat.format(Messages.getString("Util.ON_DATE"), DateTimeFormatter.ofPattern(Messages.getString("Util.MONTH_AND_DAY_FORMAT")).format(startDate)));
            }
            if ((count = rule.getCount()) > 0) {
                if (count == 1) {
                    return Messages.getString("Util.ONCE");
                }
                sb.append(MessageFormat.format(Messages.getString("Util.TIMES"), count));
            } else {
                LocalDate until = (LocalDate)rule.getUntil();
                if (until != null) {
                    sb.append(MessageFormat.format(Messages.getString("Util.UNTIL_DATE"), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(until)));
                }
            }
            return sb.toString();
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            e.printStackTrace();
            return Messages.getString("Util.INVALID_RULE");
        }
    }

    private static String makeHuman(WeekDay.Day wday) {
        switch (wday) {
            case FR: {
                return Messages.getString("Util.FRIDAY");
            }
            case MO: {
                return Messages.getString("Util.MONDAY");
            }
            case SA: {
                return Messages.getString("Util.SATURDAY");
            }
            case SU: {
                return Messages.getString("Util.SUNDAY");
            }
            case TH: {
                return Messages.getString("Util.THURSDAY");
            }
            case TU: {
                return Messages.getString("Util.TUESDAY");
            }
            case WE: {
                return Messages.getString("Util.WEDNESDAY");
            }
        }
        throw new IllegalArgumentException("unknown weekday: " + wday);
    }

    private static String makeHuman(int num) {
        switch (num) {
            case 1: {
                return Messages.getString("Util.FIRST");
            }
            case 2: {
                return Messages.getString("Util.SECOND");
            }
            case 3: {
                return Messages.getString("Util.THIRD");
            }
            case 4: {
                return Messages.getString("Util.FOURTH");
            }
            case 5: {
                return Messages.getString("Util.FIFTH");
            }
        }
        return Integer.toString(num);
    }

    public static ScrollBar findScrollBar(Parent parent, Orientation orientation) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            ScrollBar b;
            if (node instanceof ScrollBar && (b = (ScrollBar)node).getOrientation().equals((Object)orientation)) {
                return b;
            }
            if (!(node instanceof Parent) || (b = Util.findScrollBar((Parent)node, orientation)) == null) continue;
            return b;
        }
        return null;
    }

    public static LocalDate adjustToFirstDayOfWeek(LocalDate date, DayOfWeek firstDayOfWeek) {
        LocalDate newDate = date.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue());
        if (newDate.isAfter(date)) {
            newDate = newDate.minusWeeks(1L);
        }
        return newDate;
    }

    public static LocalDate adjustToLastDayOfWeek(LocalDate date, DayOfWeek firstDayOfWeek) {
        LocalDate startOfWeek = Util.adjustToFirstDayOfWeek(date, firstDayOfWeek);
        return startOfWeek.plusDays(6L);
    }

    public static <L, R> void bindBidirectional(Property<L> leftProperty, Property<R> rightProperty, Converter<L, R> converter) {
        BidirectionalConversionBinding<L, R> binding = new BidirectionalConversionBinding<L, R>(leftProperty, rightProperty, converter);
        leftProperty.addListener(binding);
        rightProperty.addListener(binding);
        leftProperty.setValue(converter.toLeft(rightProperty.getValue()));
    }

    private static class EmptySelectionModel<T>
    extends MultipleSelectionModel<T> {
        private final ObservableList<T> selectedItems = FXCollections.observableArrayList();
        private final ObservableList<Integer> selectedIndices = FXCollections.observableArrayList();

        private EmptySelectionModel() {
        }

        public void selectPrevious() {
        }

        public void selectNext() {
        }

        public void select(int index) {
        }

        public void select(T obj) {
        }

        public boolean isSelected(int index) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public void clearSelection(int index) {
        }

        public void clearSelection() {
        }

        public void clearAndSelect(int index) {
        }

        public void selectLast() {
        }

        public void selectIndices(int index, int ... indices) {
        }

        public void selectFirst() {
        }

        public void selectAll() {
        }

        public ObservableList<T> getSelectedItems() {
            return this.selectedItems;
        }

        public ObservableList<Integer> getSelectedIndices() {
            return this.selectedIndices;
        }
    }

    private static class BidirectionalConversionBinding<L, R>
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<Property<L>> leftReference;
        private final WeakReference<Property<R>> rightReference;
        private final Converter<L, R> converter;
        private boolean updating;

        private BidirectionalConversionBinding(Property<L> leftProperty, Property<R> rightProperty, Converter<L, R> converter) {
            this.leftReference = new WeakReference<Property<L>>(Objects.requireNonNull(leftProperty));
            this.rightReference = new WeakReference<Property<R>>(Objects.requireNonNull(rightProperty));
            this.converter = Objects.requireNonNull(converter);
        }

        public Property<L> getLeftProperty() {
            return (Property)this.leftReference.get();
        }

        public Property<R> getRightProperty() {
            return (Property)this.rightReference.get();
        }

        public boolean wasGarbageCollected() {
            return this.getLeftProperty() == null || this.getRightProperty() == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidated(Observable observable) {
            if (this.updating) {
                return;
            }
            Property<L> leftProperty = this.getLeftProperty();
            Property<R> rightProperty = this.getRightProperty();
            if (this.wasGarbageCollected()) {
                if (leftProperty != null) {
                    leftProperty.removeListener((InvalidationListener)this);
                }
                if (rightProperty != null) {
                    rightProperty.removeListener((InvalidationListener)this);
                }
            } else {
                try {
                    this.updating = true;
                    if (observable == leftProperty) {
                        rightProperty.setValue(this.converter.toRight(leftProperty.getValue()));
                    } else {
                        leftProperty.setValue(this.converter.toLeft(rightProperty.getValue()));
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    public static interface Converter<L, R> {
        public L toLeft(R var1);

        public R toRight(L var1);
    }
}

