/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import com.calendarfx.model.Entry;
import com.calendarfx.view.DayView;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.VisualBoundsColumn;
import impl.com.calendarfx.view.util.VisualBoundsResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class VisualBoundsCluster {
    private List<EntryViewBase<?>> entryViews;
    private VisualBoundsResolver.Range clusterRange;
    private List<VisualBoundsColumn> columns;

    public int getColumnCount() {
        if (this.columns == null || this.columns.isEmpty()) {
            return -1;
        }
        return this.columns.size();
    }

    public void add(EntryViewBase<?> entryView, DayView dayView, double contentWidth) {
        if (this.entryViews == null) {
            this.entryViews = new ArrayList();
        }
        this.entryViews.add(entryView);
        Entry<?> entry = entryView.getEntry();
        VisualBoundsResolver.Range entryRange = VisualBoundsResolver.getRange(entryView, dayView, contentWidth);
        if (entry.isFullDay()) {
            entryRange.y1 = 0.0;
            entryRange.y2 = dayView.getHeight();
        }
        if (this.clusterRange == null) {
            this.clusterRange = new VisualBoundsResolver.Range();
            this.clusterRange.title = "Cluster Range";
            this.clusterRange.y1 = entryRange.y1;
            this.clusterRange.y2 = entryRange.y2;
        } else {
            this.clusterRange.y1 = Math.min(this.clusterRange.y1, entryRange.y1);
            this.clusterRange.y2 = Math.max(this.clusterRange.y2, entryRange.y2);
        }
    }

    public boolean intersects(EntryViewBase<?> entryView, DayView dayView, double contentWidth) {
        if (this.clusterRange == null) {
            return true;
        }
        Entry<?> entry = entryView.getEntry();
        VisualBoundsResolver.Range entryRange = VisualBoundsResolver.getRange(entryView, dayView, contentWidth);
        if (entry.isFullDay()) {
            entryRange.y1 = 0.0;
            entryRange.y2 = dayView.getHeight();
        }
        return entryRange.y1 < this.clusterRange.y2 && entryRange.y2 > this.clusterRange.y1;
    }

    public List<Placement> resolve(DayView dayView, double contentWidth) {
        VisualBoundsColumn column;
        if (this.entryViews == null || this.entryViews.isEmpty()) {
            return Collections.emptyList();
        }
        this.columns = new ArrayList<VisualBoundsColumn>();
        this.columns.add(new VisualBoundsColumn());
        for (EntryViewBase<?> entryView : this.entryViews) {
            boolean added = false;
            for (VisualBoundsColumn column2 : this.columns) {
                if (!column2.hasRoomFor(entryView, dayView, contentWidth)) continue;
                column2.add(entryView);
                added = true;
                break;
            }
            if (added) continue;
            column = new VisualBoundsColumn();
            this.columns.add(column);
            column.add(entryView);
        }
        ArrayList<Placement> placements = new ArrayList<Placement>();
        int colCount = this.columns.size();
        for (int col = 0; col < this.columns.size(); ++col) {
            column = this.columns.get(col);
            for (EntryViewBase<?> view : column.getEntryViews()) {
                placements.add(new Placement(view, col, colCount));
            }
        }
        return placements;
    }

    public List<VisualBoundsColumn> getColumns() {
        return this.columns;
    }
}

