/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import com.calendarfx.model.Entry;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.util.VisualBoundsResolver;
import java.util.ArrayList;
import java.util.List;

public final class VisualBoundsColumn {
    private List<EntryViewBase<?>> entryViewBases;

    public void add(EntryViewBase<?> view) {
        if (this.entryViewBases == null) {
            this.entryViewBases = new ArrayList();
        }
        this.entryViewBases.add(view);
    }

    public boolean hasRoomFor(EntryViewBase<?> entryView, DayView dayView, double contentWidth) {
        if (this.entryViewBases == null) {
            return true;
        }
        Entry<?> entry = entryView.getEntry();
        VisualBoundsResolver.Range entryRange = VisualBoundsResolver.getRange(entryView, dayView, contentWidth);
        if (entry.isFullDay()) {
            entryRange.y1 = 0.0;
            entryRange.y2 = dayView.getHeight();
        }
        for (EntryViewBase<?> otherView : this.entryViewBases) {
            if (this.isSameEntry(entryView, otherView)) continue;
            VisualBoundsResolver.Range otherRange = VisualBoundsResolver.getRange(otherView, dayView, contentWidth);
            if (entry.isFullDay()) {
                otherRange.y1 = 0.0;
                otherRange.y2 = dayView.getHeight();
            }
            if (!(entryRange.y1 < otherRange.y2) || !(entryRange.y2 > otherRange.y1)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameEntry(EntryViewBase<?> viewA, EntryViewBase<?> viewB) {
        Entry<?> entryA = viewA.getEntry();
        Entry<?> entryB = viewB.getEntry();
        if (entryA instanceof DraggedEntry) {
            return this.isSameEntry((DraggedEntry)entryA, entryB);
        }
        if (entryB instanceof DraggedEntry) {
            return this.isSameEntry((DraggedEntry)entryB, entryA);
        }
        return false;
    }

    private boolean isSameEntry(DraggedEntry draggedEntry, Entry<?> entry) {
        if (entry.isRecurrence()) {
            return draggedEntry.getOriginalEntry().getRecurrenceSourceEntry() == entry.getRecurrenceSourceEntry();
        }
        return draggedEntry.getOriginalEntry() == entry;
    }

    public List<EntryViewBase<?>> getEntryViews() {
        return this.entryViewBases;
    }
}

