/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import com.calendarfx.model.Entry;
import com.calendarfx.view.DayView;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.VisualBoundsCluster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class VisualBoundsResolver {
    private static Comparator<EntryViewBase<?>> additionalComparator;

    public static Range getRange(EntryViewBase entryView, DayView dayView, double contentWidth) {
        Entry<?> entry = entryView.getEntry();
        Range range = new Range();
        range.y1 = dayView.getLocation(entry.getStartAsZonedDateTime());
        range.y2 = dayView.getLocation(entry.getEndAsZonedDateTime());
        if (entryView.getHeightLayoutStrategy().equals((Object)EntryViewBase.HeightLayoutStrategy.COMPUTE_PREF_SIZE)) {
            range.y2 = range.y1 + entryView.prefHeight(contentWidth);
        }
        range.title = entry.getTitle();
        return range;
    }

    public static Comparator<EntryViewBase<?>> getAdditionalComparator() {
        return additionalComparator;
    }

    public static void setAdditionalComparator(Comparator<EntryViewBase<?>> additionalComparator) {
        VisualBoundsResolver.additionalComparator = additionalComparator;
    }

    public static <T extends EntryViewBase> List<Placement> resolve(List<T> entryViews, DayView dayView, double contentWidth) {
        Comparator comparator = (o1, o2) -> {
            Range range1 = VisualBoundsResolver.getRange(o1, dayView, contentWidth);
            Range range2 = VisualBoundsResolver.getRange(o2, dayView, contentWidth);
            if (range1.y1 < range2.y1) {
                return -1;
            }
            if (range1.y1 > range2.y1) {
                return 1;
            }
            if (additionalComparator != null) {
                return additionalComparator.compare((EntryViewBase<?>)o1, (EntryViewBase<?>)o2);
            }
            return 0;
        };
        Collections.sort(entryViews, comparator);
        ArrayList<Placement> placements = new ArrayList<Placement>();
        ArrayList<VisualBoundsCluster> clusters = new ArrayList<VisualBoundsCluster>();
        VisualBoundsCluster cluster = null;
        for (EntryViewBase entryView : entryViews) {
            if (!entryView.isVisible()) continue;
            if (cluster == null || !cluster.intersects(entryView, dayView, contentWidth)) {
                cluster = new VisualBoundsCluster();
                clusters.add(cluster);
            }
            cluster.add(entryView, dayView, contentWidth);
        }
        for (VisualBoundsCluster c : new ArrayList(clusters)) {
            placements.addAll(c.resolve(dayView, contentWidth));
        }
        return placements;
    }

    static class Range {
        String title;
        double y1;
        double y2;

        Range() {
        }

        public String toString() {
            return "title = " + this.title + ", y1 = " + this.y1 + ", y2 = " + this.y2;
        }
    }
}

