/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseFontHelper;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.ColorEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class DocxRunHelper
extends BaseHelper {
    private final BaseFontHelper docxFontHelper;

    public DocxRunHelper(JasperReportsContext jasperReportsContext, Writer writer, BaseFontHelper docxFontHelper) {
        super(jasperReportsContext, writer);
        this.docxFontHelper = docxFontHelper;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, boolean hiddenText, String invalidCharReplacement, Color backcolor, boolean isNewLineAsParagraph, boolean rtl) {
        if (text != null) {
            this.write("      <w:r>\n");
            boolean highlightText = backcolor == null || !backcolor.equals(attributes.get(TextAttribute.BACKGROUND));
            this.exportProps(this.getAttributes(style), attributes, locale, hiddenText, highlightText, rtl);
            StringTokenizer tkzer = new StringTokenizer(text, "\n", true);
            while (tkzer.hasMoreTokens()) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    if (isNewLineAsParagraph) {
                        this.write("<w:t xml:space=\"preserve\"><w:p/></w:t>\n");
                        continue;
                    }
                    this.write("<w:br/>");
                    continue;
                }
                this.write("<w:t xml:space=\"preserve\">");
                this.write(JRStringUtil.xmlEncode(token, invalidCharReplacement));
                this.write("</w:t>\n");
            }
            this.write("      </w:r>\n");
        }
    }

    public void exportProps(JRDefaultStyleProvider defaultStyleProvider, JRStyle style, Locale locale) {
        JRStyle baseStyle = defaultStyleProvider.getStyleResolver().getBaseStyle(style);
        this.exportProps(this.getAttributes(baseStyle), this.getAttributes(style), locale, false, false, false);
    }

    public void exportProps(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale, boolean hiddenText, boolean highlightText, boolean rtl) {
        this.write("       <w:rPr>\n");
        Object valueWeight = attrs.get(TextAttribute.WEIGHT);
        Object oldValueWeight = parentAttrs.get(TextAttribute.WEIGHT);
        Object valuePosture = attrs.get(TextAttribute.POSTURE);
        Object oldValuePosture = parentAttrs.get(TextAttribute.POSTURE);
        String fontFamily = this.docxFontHelper.resolveFontFamily(attrs, locale);
        this.write("        <w:rFonts w:ascii=\"" + fontFamily + "\" w:hAnsi=\"" + fontFamily + "\" w:eastAsia=\"" + fontFamily + "\" w:cs=\"" + fontFamily + "\" />\n");
        Object value = attrs.get(TextAttribute.FOREGROUND);
        Object oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <w:color w:val=\"" + JRColorUtil.getColorHexa((Color)value) + "\" />\n");
        }
        if (highlightText && (value = attrs.get(TextAttribute.BACKGROUND)) != null && ColorEnum.getByColor((Color)value) != null) {
            this.write("        <w:highlight w:val=\"" + ColorEnum.getByColor((Color)value).getName() + "\" />\n");
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            float fontSize = ((Float)value).floatValue();
            fontSize = fontSize == 0.0f ? 0.5f : fontSize;
            this.write("        <w:sz w:val=\"" + (int)(2.0f * fontSize) + "\" />\n");
        }
        if (valueWeight != null && !valueWeight.equals(oldValueWeight)) {
            this.write("        <w:b w:val=\"" + valueWeight.equals(TextAttribute.WEIGHT_BOLD) + "\"/>\n");
        }
        if (valuePosture != null && !valuePosture.equals(oldValuePosture)) {
            this.write("        <w:i w:val=\"" + valuePosture.equals(TextAttribute.POSTURE_OBLIQUE) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write("        <w:u w:val=\"" + (value == null ? "none" : "single") + "\"/>\n");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write("        <w:strike w:val=\"" + (value != null) + "\"/>\n");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            this.write("        <w:vertAlign w:val=\"superscript\" />\n");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            this.write("        <w:vertAlign w:val=\"subscript\" />\n");
        }
        if (hiddenText) {
            this.write("        <w:vanish/>\n");
        }
        if (rtl) {
            this.write("        <w:rtl/>\n");
        }
        this.write("       </w:rPr>\n");
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if (style != null) {
            JRBasePrintText text = new JRBasePrintText(null);
            text.setStyle(style);
            this.fontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
            styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
            if (text.getModeValue() == ModeEnum.OPAQUE) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
            }
        }
        return styledTextAttributes;
    }
}

