/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.AvroDataFormat;
import org.apache.camel.model.dataformat.AvroLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class AvroDataFormatReifier
extends DataFormatReifier<AvroDataFormat> {
    public AvroDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (AvroDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        if (((AvroDataFormat)this.definition).getLibrary() == AvroLibrary.ApacheAvro) {
            if (((AvroDataFormat)this.definition).getInstanceClassName() == null) {
                if (((AvroDataFormat)this.definition).getUnmarshalType() != null) {
                    properties.put("instanceClassName", ((AvroDataFormat)this.definition).getUnmarshalType().getName());
                } else if (((AvroDataFormat)this.definition).getUnmarshalTypeName() != null) {
                    properties.put("instanceClassName", ((AvroDataFormat)this.definition).getUnmarshalTypeName());
                }
            } else {
                properties.put("instanceClassName", ((AvroDataFormat)this.definition).getInstanceClassName());
            }
            properties.put("schema", ((AvroDataFormat)this.definition).getSchema());
        } else if (((AvroDataFormat)this.definition).getLibrary() == AvroLibrary.Jackson) {
            properties.put("objectMapper", this.asRef(((AvroDataFormat)this.definition).getObjectMapper()));
            if (((AvroDataFormat)this.definition).getUseDefaultObjectMapper() == null) {
                properties.put("useDefaultObjectMapper", "true");
            } else {
                properties.put("useDefaultObjectMapper", ((AvroDataFormat)this.definition).getUseDefaultObjectMapper());
            }
            properties.put("autoDiscoverObjectMapper", ((AvroDataFormat)this.definition).getAutoDiscoverObjectMapper());
            if (((AvroDataFormat)this.definition).getJsonView() != null) {
                properties.put("jsonViewTypeName", this.asTypeName(((AvroDataFormat)this.definition).getJsonView()));
            } else {
                properties.put("jsonViewTypeName", ((AvroDataFormat)this.definition).getJsonViewTypeName());
            }
            if (((AvroDataFormat)this.definition).getUnmarshalType() != null) {
                properties.put("unmarshalTypeName", this.asTypeName(((AvroDataFormat)this.definition).getUnmarshalType()));
            } else if (((AvroDataFormat)this.definition).getUnmarshalTypeName() != null) {
                properties.put("unmarshalTypeName", ((AvroDataFormat)this.definition).getUnmarshalTypeName());
            } else {
                properties.put("unmarshalTypeName", ((AvroDataFormat)this.definition).getInstanceClassName());
            }
            properties.put("jsonView", ((AvroDataFormat)this.definition).getJsonView());
            properties.put("include", ((AvroDataFormat)this.definition).getInclude());
            properties.put("allowJmsType", ((AvroDataFormat)this.definition).getAllowJmsType());
            if (((AvroDataFormat)this.definition).getCollectionType() != null) {
                properties.put("collectionTypeName", this.asTypeName(((AvroDataFormat)this.definition).getCollectionType()));
            } else {
                properties.put("collectionTypeName", ((AvroDataFormat)this.definition).getCollectionTypeName());
            }
            properties.put("useList", ((AvroDataFormat)this.definition).getUseList());
            properties.put("moduleClassNames", ((AvroDataFormat)this.definition).getModuleClassNames());
            properties.put("moduleRefs", ((AvroDataFormat)this.definition).getModuleRefs());
            properties.put("enableFeatures", ((AvroDataFormat)this.definition).getEnableFeatures());
            properties.put("disableFeatures", ((AvroDataFormat)this.definition).getDisableFeatures());
            properties.put("allowUnmarshallType", ((AvroDataFormat)this.definition).getAllowUnmarshallType());
            properties.put("schemaResolver", this.asRef(((AvroDataFormat)this.definition).getSchemaResolver()));
            properties.put("autoDiscoverSchemaResolver", ((AvroDataFormat)this.definition).getAutoDiscoverSchemaResolver());
        }
    }
}

