/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import com.carrotsearch.sizeof.RamUsageEstimator;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.converter.ConverterFactory;

public final class StateReporter {
    public static final String DIVIDER = "\n-------------------------------------------------------------";

    private StateReporter() {
    }

    public static void reportCurrentState(StringBuilder out, MapperFactory mapperFactory) {
        MapperFacade mapperFacade;
        ConverterFactory converterFactory = mapperFactory.getConverterFactory();
        if (converterFactory instanceof Reportable) {
            ((Reportable)((Object)converterFactory)).reportCurrentState(out);
        }
        if (mapperFactory instanceof Reportable) {
            ((Reportable)((Object)mapperFactory)).reportCurrentState(out);
        }
        if ((mapperFacade = mapperFactory.getMapperFacade()) instanceof Reportable) {
            ((Reportable)((Object)mapperFacade)).reportCurrentState(out);
        }
    }

    public static String humanReadableSizeInMemory(Object ... objects) {
        long size = RamUsageEstimator.sizeOfAll((Object[])objects);
        return String.format("%,.1f kB", (double)size / 1000.0);
    }

    public static interface Reportable {
        public void reportCurrentState(StringBuilder var1);
    }
}

