/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.constructor;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.impl.Specifications;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class SimpleConstructorResolverStrategy
implements ConstructorResolverStrategy {
    private final Paranamer paranamer = new CachingParanamer((Paranamer)new AdaptiveParanamer(new Paranamer[]{new BytecodeReadingParanamer(), new AnnotationParanamer()}));

    @Override
    public <T, A, B> ConstructorResolverStrategy.ConstructorMapping<T> resolve(ClassMap<A, B> classMap, Type<T> sourceType) {
        boolean aToB = classMap.getBType().equals(sourceType);
        Type<Object> targetClass = aToB ? classMap.getBType() : classMap.getAType();
        Type<Object> sourceClass = aToB ? classMap.getAType() : classMap.getBType();
        String[] declaredParameterNames = aToB ? classMap.getConstructorB() : classMap.getConstructorA();
        Map<String, FieldMap> targetParameters = this.getTargetParams(classMap.getFieldsMapping(), aToB, declaredParameterNames);
        boolean byDefault = declaredParameterNames == null;
        boolean foundDeclaredConstructor = false;
        Constructor<?>[] constructors = ((Class)targetClass.getRawType()).getDeclaredConstructors();
        TreeMap<Integer, ConstructorResolverStrategy.ConstructorMapping<T>> constructorsByMatchedParams = new TreeMap<Integer, ConstructorResolverStrategy.ConstructorMapping<T>>();
        for (Constructor<?> constructor : constructors) {
            ConstructorResolverStrategy.ConstructorMapping constructorMapping = new ConstructorResolverStrategy.ConstructorMapping();
            constructorMapping.setDeclaredParameters(declaredParameterNames);
            java.lang.reflect.Type[] genericParamTypes = constructor.getGenericParameterTypes();
            try {
                String[] parameterNames = this.mapTargetParamNames(this.paranamer.lookupParameterNames(constructor));
                constructorMapping.setParameterNameInfoAvailable(true);
                if (!targetParameters.keySet().containsAll(Arrays.asList(parameterNames))) continue;
                foundDeclaredConstructor = true;
                constructorMapping.setConstructor(constructor);
                this.mapConstructorArgs(constructorMapping, targetParameters, parameterNames, genericParamTypes, byDefault);
                constructorsByMatchedParams.put(parameterNames.length * 1000, constructorMapping);
            }
            catch (ParameterNamesNotFoundException e) {
                if (targetParameters.size() < genericParamTypes.length) continue;
                this.matchByDestParamTypes(constructorMapping, targetParameters, genericParamTypes, byDefault, constructorsByMatchedParams);
                constructorMapping.setConstructor(constructor);
            }
        }
        return this.prepareMatchedConstructorMapping(constructorsByMatchedParams, targetClass, sourceClass, declaredParameterNames, foundDeclaredConstructor, constructors);
    }

    protected String[] mapTargetParamNames(String[] parameterNames) {
        return parameterNames;
    }

    private <T> ConstructorResolverStrategy.ConstructorMapping<T> prepareMatchedConstructorMapping(TreeMap<Integer, ConstructorResolverStrategy.ConstructorMapping<T>> constructorsByMatchedParams, Type<?> targetClass, Type<?> sourceClass, String[] declaredParameterNames, boolean foundDeclaredConstructor, Constructor<T>[] constructors) {
        if (constructorsByMatchedParams.size() > 0) {
            return constructorsByMatchedParams.get(constructorsByMatchedParams.lastKey());
        }
        if (declaredParameterNames != null) {
            return this.throwNotMatchedTargetConstructorEx(targetClass, sourceClass, declaredParameterNames, foundDeclaredConstructor);
        }
        ConstructorResolverStrategy.ConstructorMapping<T> defaultMapping = new ConstructorResolverStrategy.ConstructorMapping<T>();
        defaultMapping.setConstructor(constructors.length == 0 ? null : constructors[0]);
        return defaultMapping;
    }

    private <T> ConstructorResolverStrategy.ConstructorMapping<T> throwNotMatchedTargetConstructorEx(Type<?> targetClass, Type<?> sourceClass, String[] declaredParameterNames, boolean foundDeclaredConstructor) {
        String declaredParamNamesTxt = Arrays.toString(declaredParameterNames);
        String errMsg = foundDeclaredConstructor ? "Declared constructor for " + targetClass + "(" + declaredParamNamesTxt + ") could not be matched to the source fields of " + sourceClass : "No constructors found for " + targetClass + " matching the specified constructor parameters " + (declaredParameterNames.length == 0 ? "(no-arg constructor)" : "(" + declaredParamNamesTxt + ")");
        throw new IllegalStateException(errMsg);
    }

    private <T> void matchByDestParamTypes(ConstructorResolverStrategy.ConstructorMapping<T> constructorMapping, Map<String, FieldMap> targetParameters, java.lang.reflect.Type[] genericParamTypes, boolean byDefault, TreeMap<Integer, ConstructorResolverStrategy.ConstructorMapping<T>> constructorsByMatchedParams) {
        ArrayList<FieldMap> targetTypes = new ArrayList<FieldMap>(targetParameters.values());
        int matchScore = 0;
        int exactMatches = 0;
        Type[] parameterTypes = new Type[genericParamTypes.length];
        block0: for (int i = 0; i < genericParamTypes.length; ++i) {
            java.lang.reflect.Type param = genericParamTypes[i];
            parameterTypes[i] = TypeFactory.valueOf(param);
            Iterator iter = targetTypes.iterator();
            while (iter.hasNext()) {
                FieldMap fieldMap = (FieldMap)iter.next();
                Type<?> targetType = fieldMap.getDestination().getType();
                if ((!parameterTypes[i].equals(targetType) || ++exactMatches == 0) && !parameterTypes[i].isAssignableFrom(targetType)) continue;
                ++matchScore;
                String parameterName = fieldMap.getDestination().getName();
                FieldMap existingField = targetParameters.get(parameterName);
                FieldMap argumentMap = this.mapConstructorArgument(existingField, parameterTypes[i], byDefault);
                constructorMapping.getMappedFields().add(argumentMap);
                iter.remove();
                continue block0;
            }
        }
        constructorMapping.setParameterTypes(parameterTypes);
        constructorsByMatchedParams.put(matchScore * 1000 + exactMatches, constructorMapping);
    }

    private <T> void mapConstructorArgs(ConstructorResolverStrategy.ConstructorMapping<T> constructorMapping, Map<String, FieldMap> targetParameters, String[] parameterNames, java.lang.reflect.Type[] genericParameterTypes, boolean byDefault) {
        Type[] parameterTypes = new Type[genericParameterTypes.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            parameterTypes[i] = TypeFactory.valueOf(genericParameterTypes[i]);
            FieldMap existingField = targetParameters.get(parameterName);
            FieldMap argumentMap = this.mapConstructorArgument(existingField, parameterTypes[i], byDefault);
            constructorMapping.getMappedFields().add(argumentMap);
        }
        constructorMapping.setParameterTypes(parameterTypes);
    }

    private Map<String, FieldMap> getTargetParams(Set<FieldMap> fieldMaps, boolean aToB, String[] declaredParameterNames) {
        LinkedHashMap<String, FieldMap> targetParameters = new LinkedHashMap<String, FieldMap>();
        if (declaredParameterNames != null) {
            HashSet<FieldMap> fields = new HashSet<FieldMap>(fieldMaps);
            for (String arg : declaredParameterNames) {
                Iterator iter = fields.iterator();
                while (iter.hasNext()) {
                    FieldMap fieldMap = (FieldMap)iter.next();
                    if (fieldMap.is(Specifications.aMappingOfTheRequiredClassProperty())) continue;
                    if (!aToB) {
                        fieldMap = fieldMap.flip();
                    }
                    if (!fieldMap.getDestination().getName().equals(arg)) continue;
                    targetParameters.put(arg, fieldMap);
                    iter.remove();
                }
            }
        } else {
            for (FieldMap fieldMap : fieldMaps) {
                if (fieldMap.is(Specifications.aMappingOfTheRequiredClassProperty())) continue;
                if (!aToB) {
                    fieldMap = fieldMap.flip();
                }
                targetParameters.put(fieldMap.getDestination().getName(), fieldMap);
            }
        }
        return targetParameters;
    }

    private FieldMap mapConstructorArgument(FieldMap existing, Type<?> argumentType, boolean byDefault) {
        Property destProp = new Property.Builder().name(existing.getDestination().getName()).getter(existing.getDestination().getName()).type(argumentType).build();
        return new FieldMap(existing.getSource(), destProp, null, null, MappingDirection.A_TO_B, false, existing.getConverterId(), byDefault, null, null);
    }
}

