/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.util.HashSet;
import java.util.Set;
import ma.glasnost.orika.CustomConverter;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class PassThroughConverter
extends CustomConverter<Object, Object> {
    private final Set<Type<?>> passThroughTypes = new HashSet();
    private final String description;

    public PassThroughConverter(java.lang.reflect.Type ... types) {
        StringBuilder desc = new StringBuilder(PassThroughConverter.class.getSimpleName() + "(Copy by reference:");
        String separator = "";
        for (java.lang.reflect.Type type : types) {
            Type theType = TypeFactory.valueOf(type);
            this.passThroughTypes.add(theType);
            desc.append(separator).append(theType);
            separator = ", ";
        }
        desc.append(")");
        this.description = desc.toString();
    }

    private boolean shouldPassThrough(Type<?> type) {
        for (Type<?> registeredType : this.passThroughTypes) {
            if (!registeredType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return this.shouldPassThrough(sourceType) && sourceType.equals(destinationType);
    }

    @Override
    public Object convert(Object source, Type<? extends Object> destinationType, MappingContext context) {
        return source;
    }

    @Override
    public String toString() {
        return this.description;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.passThroughTypes == null ? 0 : this.passThroughTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PassThroughConverter other = (PassThroughConverter)obj;
        return !(this.passThroughTypes == null ? other.passThroughTypes != null : !this.passThroughTypes.equals(other.passThroughTypes));
    }

    static class Builtin
    extends PassThroughConverter {
        private final String description = "builtin:" + super.toString();

        Builtin(java.lang.reflect.Type ... types) {
            super(types);
        }

        @Override
        public String toString() {
            return this.description;
        }
    }
}

