/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import ma.glasnost.orika.metadata.FieldMap;

public final class Specifications {
    private static final Specification IS_IMMUTABLE = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().getType().isImmutable() && fieldMap.getDestination().isAssignableFrom(fieldMap.getSource());
        }
    };
    private static final Specification IS_TO_ENUMERATION = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getDestination().getType().isEnum() && (fieldMap.getSource().getType().getRawType().equals(String.class) || fieldMap.getSource().getType().isEnum());
        }
    };
    private static final Specification IS_ARRAY = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getDestination().isArray() && (fieldMap.getSource().isArray() || fieldMap.getSource().isCollection());
        }
    };
    private static final Specification IS_COLLECTION = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return (fieldMap.getSource().isArray() || fieldMap.getSource().isCollection()) && fieldMap.getDestination().isCollection();
        }
    };
    private static final Specification IS_PRIMITIVE = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().getType().isPrimitive() || fieldMap.getDestination().getType().isPrimitive();
        }
    };
    private static final Specification WRAPPER_TO_PRIMITIVE = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getDestination().isPrimitive() && fieldMap.getSource().getType().isPrimitiveWrapper();
        }
    };
    private static final Specification PRIMITIVE_TO_WRAPPER = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getDestination().getType().isPrimitiveWrapper() && fieldMap.getSource().isPrimitive();
        }
    };
    private static final Specification STRING_TO_PRIMITIVE_OR_WRAPPER = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return String.class.equals((Object)fieldMap.getSource().getType().getRawType()) && (fieldMap.getDestination().getType().isPrimitive() || fieldMap.getDestination().getType().isPrimitiveWrapper());
        }
    };
    private static final Specification CONVERSION_TO_STRING = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return String.class.equals((Object)fieldMap.getDestination().getType().getRawType());
        }
    };
    private static final Specification MAP_TO_MAP = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().isMap() && fieldMap.getDestination().isMap();
        }
    };
    private static final Specification MAP_TO_ARRAY_OR_COLLECTION = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().isMap() && (fieldMap.getDestination().isCollection() || fieldMap.getDestination().isArray());
        }
    };
    private static final Specification MAP_TO_ARRAY = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().isMap() && fieldMap.getDestination().isArray();
        }
    };
    private static final Specification MAP_TO_COLLECTION = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().isMap() && fieldMap.getDestination().isCollection();
        }
    };
    private static final Specification MAP_TO_BEAN = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().isMapKey() && (fieldMap.getDestination().getType().isImmutable() || !fieldMap.getDestination().isCollection() && !fieldMap.getDestination().isArray() && !fieldMap.getDestination().isMap() && !fieldMap.getDestination().isEnum());
        }
    };
    private static final Specification ARRAY_OR_LIST_TO_BEAN = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return (fieldMap.getSource().isListElement() || fieldMap.getSource().isArrayElement()) && (fieldMap.getDestination().getType().isImmutable() || !fieldMap.getDestination().isCollection() && !fieldMap.getDestination().isArray() && !fieldMap.getDestination().isMap() && !fieldMap.getDestination().isEnum());
        }
    };
    private static final Specification ARRAY_OR_COLLECTION_TO_MAP = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getDestination().isMap() && (fieldMap.getSource().isCollection() || fieldMap.getSource().isArray());
        }
    };
    private static final Specification BEAN_TO_MAP = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getDestination().isMapKey() && (fieldMap.getSource().getType().isImmutable() || !fieldMap.getSource().isCollection() && !fieldMap.getSource().isArray() && !fieldMap.getSource().isMap() && !fieldMap.getSource().isEnum());
        }
    };
    private static final Specification BEAN_TO_ARRAY_OR_LIST = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return (fieldMap.getDestination().isListElement() || fieldMap.getDestination().isArrayElement()) && (fieldMap.getSource().getType().isImmutable() || !fieldMap.getSource().isCollection() && !fieldMap.getSource().isArray() && !fieldMap.getSource().isMap() && !fieldMap.getSource().isEnum());
        }
    };
    private static final Specification OBJECT_CLASS_PROPERTY = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return "class".equals(fieldMap.getSource().getName()) && "class".equals(fieldMap.getDestination().getName()) && Class.class.equals(fieldMap.getSource().getRawType());
        }
    };
    private static final Specification MANY_TO_ONE = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().getContainer() != null && fieldMap.getDestination().getContainer() == null;
        }
    };
    private static final Specification ONE_TO_MANY = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().getContainer() == null && fieldMap.getDestination().getContainer() != null;
        }
    };
    private static final Specification MULTI_OCCURRENCE_ELEMENT = new Specification(){

        @Override
        public boolean apply(FieldMap fieldMap) {
            return fieldMap.getSource().getContainer() != null && fieldMap.getDestination().getContainer() != null;
        }
    };

    private Specifications() {
    }

    public static Specification immutable() {
        return IS_IMMUTABLE;
    }

    public static Specification toAnEnumeration() {
        return IS_TO_ENUMERATION;
    }

    public static Specification anArray() {
        return IS_ARRAY;
    }

    public static Specification aCollection() {
        return IS_COLLECTION;
    }

    public static Specification aPrimitive() {
        return IS_PRIMITIVE;
    }

    public static Specification aPrimitiveToWrapper() {
        return PRIMITIVE_TO_WRAPPER;
    }

    public static Specification aWrapperToPrimitive() {
        return WRAPPER_TO_PRIMITIVE;
    }

    public static Specification aMapToMap() {
        return MAP_TO_MAP;
    }

    public static Specification aMapToArrayOrCollection() {
        return MAP_TO_ARRAY_OR_COLLECTION;
    }

    public static Specification aMapToArray() {
        return MAP_TO_ARRAY;
    }

    public static Specification aMapToCollection() {
        return MAP_TO_COLLECTION;
    }

    public static Specification anArrayOrCollectionToMap() {
        return ARRAY_OR_COLLECTION_TO_MAP;
    }

    public static Specification aBeanToMap() {
        return BEAN_TO_MAP;
    }

    public static Specification aBeanToArrayOrList() {
        return BEAN_TO_ARRAY_OR_LIST;
    }

    public static Specification aMapToBean() {
        return MAP_TO_BEAN;
    }

    public static Specification anArrayOrListToBean() {
        return ARRAY_OR_LIST_TO_BEAN;
    }

    public static Specification aMappingOfTheRequiredClassProperty() {
        return OBJECT_CLASS_PROPERTY;
    }

    public static Specification aOneToManyElementMap() {
        return ONE_TO_MANY;
    }

    public static Specification aManyToOneElementMap() {
        return MANY_TO_ONE;
    }

    public static Specification aMultiOccurrenceElementMap() {
        return MULTI_OCCURRENCE_ELEMENT;
    }

    public static Specification aStringToPrimitiveOrWrapper() {
        return STRING_TO_PRIMITIVE_OR_WRAPPER;
    }

    public static Specification aConversionToString() {
        return CONVERSION_TO_STRING;
    }

    public static interface Specification {
        public boolean apply(FieldMap var1);
    }
}

