/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ArrayElementProperty;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.ClassMapBuilderForLists;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolverStrategy;

public class ClassMapBuilderForArrays<A, B>
extends ClassMapBuilderForLists<A, B> {
    protected ClassMapBuilderForArrays(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper ... defaults) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
    }

    @Override
    protected ClassMapBuilderForArrays<A, B> self() {
        return this;
    }

    @Override
    protected boolean isATypeBean() {
        return !this.getAType().isArray();
    }

    @Override
    protected boolean isSpecialCaseType(Type<?> type) {
        return type.isArray();
    }

    @Override
    protected Property resolveCustomProperty(String expr, Type<?> propertyType) {
        int index = Integer.valueOf(expr.replaceAll("[\\[\\]]", ""));
        return new ArrayElementProperty(index, propertyType.getComponentType(), null);
    }

    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> boolean appliesTo(Type<A> aType, Type<B> bType) {
            return aType.isArray() && !bType.isArray() || bType.isArray() && !aType.isArray();
        }

        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new ClassMapBuilderForArrays<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

