@echo off

set DATA_WIPE_WARNING=false
set INFINITE_LOOP=false
set SN=


echo.
echo ** Fairphone OS 19.02.1 Manual Flashing Script **
echo.
echo.

call :validate_checksums

if '%INFINITE_LOOP%' == 'true' (
  call :flash_and_loop
) else (
  call :flash_and_exit
)

exit /b


rem Flash only one device and exit.
:flash_and_exit
  if '%DATA_WIPE_WARNING%' == 'true' (
    echo WARNING: Flashing this image wipes all user data and settings on the phone.
    echo.
  )

  call :wait_for_a_device

  if '%DATA_WIPE_WARNING%' == 'true' (
    call :warn_about_wipe
  )

  echo.
  echo Proceeding to flash the device.
  echo.

  call :flash_device

  echo.
  echo Flashing successful!
  echo Your Fairphone 2 will now run **Fairphone OS 19.02.1**.
  echo.
  echo Press Enter to reboot the device and complete the installation
  pause

  bin-msys\fastboot.exe -s %SN% reboot
exit /b

rem Flash devices in a sequential loop (never exit).
:flash_and_loop
  echo.
  echo ********** Waiting for a device accessible via fastboot.
  echo.

  :get_one_sn
  set SN=
  for /F %%i in ('bin-msys\fastboot.exe devices') do (
    if not defined SN (
      set SN=%%i
    )
  )
  if not defined SN (
    rem Since there is no well-known "sleep" utility deployed on older Windows
    rem versions, rely on the nifty ping hack.
    ping -n 5 127.0.0.1 >nul

    goto :get_one_sn
  )

  echo [%SN%] Proceeding to flash the device.

  call :flash_device

  echo [%SN%] Flashing successful!
  echo [%SN%] The Fairphone 2 will now run **Fairphone OS 19.02.1**.
  echo [%SN%] Rebooting device.

  bin-msys\fastboot.exe -s %SN% reboot

  rem Give some time to fastboot to recover
  ping -n 5 127.0.0.1 >nul

  goto :flash_and_loop
exit /b

rem Flash a device.
:flash_device
call :flash_image_or_abort %SN% rpm "images\rpm.mbn"
call :flash_image_or_abort %SN% sbl1 "images\sbl1.mbn"
call :flash_image_or_abort %SN% tz "images\tz.mbn"
call :flash_image_or_abort %SN% modem "images\NON-HLOS.bin"
call :flash_image_or_abort %SN% splash "images\splash.img"
call :flash_image_or_abort %SN% aboot "images\emmc_appsboot.mbn"
call :flash_image_or_abort %SN% boot "images\boot.img"
call :flash_image_or_abort %SN% recovery "images\recovery.img"
call :flash_image_or_abort %SN% system "images\system.img"
exit /b

rem Abort the script (and wait for a key to be pressed).
:abort_now
  echo.
  echo Aborting now (press Enter to terminate).
  pause
exit 1

rem Validate checksums. Abort on failure.
rem Arguments: <validation command>
:validate_checksums
  echo Validating files...

  (cd images && ..\bin-msys\md5sum.exe --status --check MD5SUMS && cd ..) ^
  || (
    echo ERROR: Checksums do not match, try to download the manual update again.
    call :abort_now
  )

  echo All files are valid, let's go!
exit /b

rem Wait for a device in fastboot mode.
:wait_for_a_device
  set nb_devices=0
  set SN=

  for /F %%i in ('bin-msys\fastboot.exe devices') do (
    set /a nb_devices+=1
    if not defined SN (
      set SN=%%i
    )
  )

  if %nb_devices% equ 0 (
    echo.
    echo WARNING: No device found in fastboot mode.
    echo WARNING: Make sure that a Fairphone 2 is connected.
    echo WARNING: To check for devices, type 'bin-msys\fastboot.exe devices'.
  ) else if %nb_devices% neq 1 (
    echo.
    echo WARNING: Several devices in fastboot mode connected.
    echo WARNING: Please connect only one device.
  ) else (
    echo.
    echo One device in fastboot mode is connected.

    exit /b
  )

  echo.
  :ask_to_retry
  set a=
  set /p a=Do you want to look for a device again? [(Y)es/(n)o]:

  if '%a%' == '' (
    goto :wait_for_a_device
  ) else if /i '%a%' == 'y' (
    goto :wait_for_a_device
  ) else if /i '%a%' == 'n' (
    exit 0
  ) else (
    goto :ask_to_retry
  )
exit /b

rem Warn about userdata wipe. Abort if consent is not given.
:warn_about_wipe
  echo.
  echo Are you sure you want to wipe all user data and settings on the phone?

  set a=
  set /p a="  Type "Yes" to continue: "
  if not '%a%' == 'Yes' (
    call :abort_now
  )
exit /b

rem Flash an image to a partition. Abort on failure.
rem Arguments: <device serial number> <partition name> <image file>
:flash_image_or_abort
  (bin-msys\fastboot.exe -s %1 flash %2 %3) ^
  || (
    echo.
    echo ERROR: Could not flash the %2 partition on device %1.
    echo.
    echo ERROR: Please unplug the phone, take the battery out, boot the device into
    echo ERROR: fastboot mode, plug in the phone, and start this script again.
    echo ERROR: ^(To get to fastboot mode, press Volume-Down and Power until the^)
    echo ERROR: ^(Fairphone logo appears.^)
    call :abort_now
  )
exit /b
