(function() {
    function waitForConfig() {
        return new Promise((resolve) => {
            if (window.FansUnitedCore) {
                resolve(window.FansUnitedCore);
                return;
            }

            const checkInterval = setInterval(() => {
                if (window.FansUnitedCore) {
                    clearInterval(checkInterval);
                    resolve(window.FansUnitedCore);
                }
            }, 100);
        });
    }

    async function initialize() {
        try {
            const config = await waitForConfig();
            initializeSDK(config, "");
            // Initialize Firebase
            // const app = firebase.initializeApp(config.firebaseConfig);
            // const auth = app.auth();

            // // Set up auth state listener
            // auth.onAuthStateChanged(async (user) => {
            //     if (user) {
            //         const idToken = await user.getIdToken();
            //         localStorage.setItem('fans_united_anon_token', idToken);
            //         initializeSDK(config, idToken);
            //     } else {
            //         try {
            //             await auth.signInAnonymously();
            //         } catch (error) {
            //             console.error('Anonymous auth failed:', error);
            //             initializeSDK(config, "");
            //         }
            //     }
            // });

        } catch (error) {
            console.error('Initialization failed:', error);
        }
    }

    function initializeSDK(config, idToken) {
        try {
            const sdkConfig = {
                ...config.fansUnitedConfig,
                errorHandlingMode: "standard",
                authProvider: {
                    // getIdToken: () => idToken || localStorage.getItem('fans_united_anon_token') || "",
                    getIdToken: () => "",
                    logout: () => {
                        localStorage.removeItem('fans_united_anon_token');
                    }
                }
            };

            window.fuAnonSDK = FansUnitedSDK.FansUnitedSDK(sdkConfig);
            console.log('SDK initialized successfully');
        } catch (error) {
            console.error('SDK initialization failed:', error);
        }
    }

    initialize();
})();