<?php

class FansUnitedAssets {
    private $settings;
    private $miniGamesSettings = null;

    public function __construct($settings) {
        $this->settings = $settings;

        add_action('plugins_loaded', array($this, 'maybeLoadMiniGamesSettings'));
        
        $this->initHooks();
    }

    public function maybeLoadMiniGamesSettings() {
        if (class_exists('FansUnitedMiniGamesSettings')) {
            $this->miniGamesSettings = FansUnitedMiniGamesSettings::getInstance();;
        }
    }

    private function initHooks() {
        add_action('wp_enqueue_scripts', array($this, 'enqueueScripts'), 10);
        add_action('wp_enqueue_scripts', array($this, 'enqueueStyles'), 10);
        add_action('admin_enqueue_scripts', array($this, 'enqueueScripts'), 10);
    }

    public function enqueueStyles() {
        // Register a dummy stylesheet handle for our inline styles
        wp_register_style('fans-united-core-inline', false);
        wp_enqueue_style('fans-united-core-inline');

        // Add inline styles
        $styles = "
            div[data-component=\"fu-widget\"] {
                width: 100%;
                max-width: var(--wp--style--global--content-size, '1000px');
                margin-left: auto;
                margin-right: auto;
                display: block;
                box-sizing: border-box;
            }
        ";
        
        wp_add_inline_style('fans-united-core-inline', $styles);
    }

    private function getMiniGamesOption($optionName) {
        if ($this->miniGamesSettings) {
            return $this->miniGamesSettings->getOption($optionName);
        }
        return null;
    }

    public function enqueueScripts() {
        // Config first
        $settings_array = array(
            'firebaseConfig' => array(
                'apiKey' => $this->settings->getOption('firebase_api_key'),
                'authDomain' => $this->settings->getOption('firebase_auth_domain'),
                'projectId' => $this->settings->getOption('firebase_project_id'),
                'appId' => $this->settings->getOption('firebase_app_id'),
            ),
            'fansUnitedConfig' => array(
                'apiKey' => $this->settings->getOption('api_key'),
                'clientId' => $this->settings->getOption('client_id'),
                'environment' => $this->settings->getOption('env', 'prod'),
                'lang' => $this->settings->getOption('lang', 'en'),
                'idSchema' => $this->settings->getOption('id_provider', 'native')
            ),
            'language' => $this->settings->getOption('misc_language', 'en'),
            'showAnswerExplanations' => (bool) $this->settings->getOption('misc_show_answer_explanations', 1),
            'imagePosition' => $this->settings->getOption('misc_image_position', 'left'),
            'defaultImagePlaceholderUrl' => $this->settings->getOption('misc_default_image_placeholder_url', null),
            'playerOfTheMatch' => array(
                'authRequirement' => $this->settings->getOption('misc_potm_auth_requirement') ?: null,
            ),
        );

        wp_register_script('fans-united-core-config', '', array(), FANS_UNITED_CORE_VERSION, true);
        wp_localize_script('fans-united-core-config', 'FansUnitedCore', $settings_array);
        wp_enqueue_script('fans-united-core-config');

        // Add theme options to window object
        $theme_options = $this->settings->getThemeOptions();
        wp_register_script('fans-united-theme-options', '', array(), FANS_UNITED_CORE_VERSION, true);
        wp_localize_script('fans-united-theme-options', 'fansUnitedThemeOptions', $theme_options);
        wp_enqueue_script('fans-united-theme-options');
        // wp_enqueue_script(
        //     'fans-united-firebase-app',
        //     'https://www.gstatic.com/firebasejs/11.1.0/firebase-app-compat.js',
        //     array('fans-united-core-config'),
        //     '11.1.0',
        //     true
        // );

        wp_enqueue_script(
            'fans-united-widgets',
            'https://cdn.jsdelivr.net/npm/fansunited-widgets-cdn@latest/fu-widgets.iife.js',
            [],
            "latest",
            true
        );

        // wp_enqueue_script(
        //     'fans-united-firebase-auth',
        //     'https://www.gstatic.com/firebasejs/11.1.0/firebase-auth-compat.js',
        //     array('fans-united-firebase-app'),
        //     '11.1.0',
        //     true
        // );
    
        // SDK
        wp_enqueue_script(
            'fans-united-sdk',
            'https://cdn.jsdelivr.net/npm/fansunited-sdk-umd@1.89.0/index.min.js',
            [],
            '1.88.0',
            true
        );

        // SDK Initialization script
        wp_enqueue_script(
            'fans-united-sdk-init',
            FANS_UNITED_CORE_PLUGIN_URL . 'assets/js/init.js',
            array('fans-united-sdk'),
            FANS_UNITED_CORE_VERSION,
            true
        );

        // Set initialization flag before React components load
        wp_add_inline_script('fans-united-sdk-init', '
            window.fuSDKInitialized = false;
            document.addEventListener("FUSDKInitialized", function() {
                window.fuSDKInitialized = true;
            });
        ', 'before');
    
        // React components initialization
        wp_enqueue_script(
            'fans-united-core-init',
            FANS_UNITED_CORE_PLUGIN_URL . 'dist/fans-united-core.umd.js',
            array('fans-united-sdk-init'),
            FANS_UNITED_CORE_VERSION,
            true
        );

        wp_add_inline_script('fans-united-widgets', '
        document.addEventListener("DOMContentLoaded", function () {
                    try {
                        if (window.FuWidget) {
                            FuWidget.init({
                                language: "'.$this->settings->getOption('misc_language', 'en').'",
                                showAnswerExplanations: '.($this->settings->getOption('misc_show_answer_explanations', 1) ? 'true' : 'false').',
                                imagePosition: "'.$this->settings->getOption('misc_image_position', 'left').'",
                                defaultImagePlaceholderUrl: '.($this->settings->getOption('misc_default_image_placeholder_url') ? '"'.$this->settings->getOption('misc_default_image_placeholder_url').'"' : 'null').',
                                playerOfTheMatch: {
                                    authRequirement: '.($this->settings->getOption('misc_potm_auth_requirement') ? '"'.$this->settings->getOption('misc_potm_auth_requirement').'"' : 'null').',
                                },
                                fansUnited: {
                                    apiKey: "'.$this->settings->getOption('api_key').'",
                                    environment: "'.$this->settings->getOption('env', 'prod').'",
                                    clientId: "'.$this->settings->getOption('client_id').'",
                                    lang: "'.$this->settings->getOption('lang', 'en').'",
                                    idSchema: "'. $this->settings->getOption('id_provider', 'native').'",
                                    errorHandlingMode: "default",
                                },
                                firebase: {
                                    projectId: "'.$this->settings->getOption('firebase_project_id').'",
                                    appId: "'.$this->settings->getOption('firebase_app_id').'",
                                    apiKey: "'.$this->settings->getOption('firebase_api_key').'",
                                    authDomain: "'.$this->settings->getOption('firebase_auth_domain').'",
                                },
                                themeOptions: window.fansUnitedThemeOptions || {},
                                theme: {
                                    mode: "'.$this->settings->getOption('theme', 'light').'",
                                    primaryColor: {
                                        50: "'.$this->settings->getOption('primary_50', '#f0f7ff').'",
                                        100: "'.$this->settings->getOption('primary_100', '#c2e0ff').'",
                                        200: "'.$this->settings->getOption('primary_200', '#99ccff').'",
                                        300: "'.$this->settings->getOption('primary_300', '#66b2ff').'",
                                        400: "'.$this->settings->getOption('primary_400', '#3399ff').'",
                                        500: "'.$this->settings->getOption('primary_500', '#007fff').'",
                                        600: "'.$this->settings->getOption('primary_600', '#0066cc').'",
                                        700: "'.$this->settings->getOption('primary_700', '#0052a3').'",
                                        800: "'.$this->settings->getOption('primary_800', '#003d7a').'",
                                        900: "'.$this->settings->getOption('primary_900', '#002952').'",
                                    },
                                },
                                leads: {
                                    defaultFields: '.json_encode($this->settings->getOption('leads_default_fields', array('email', 'fullName'))).',
                                    position: "'.$this->settings->getOption('leads_position', 'before').'",
                                    campaignId: "'.$this->settings->getOption('leads_campaign_id', '').'",
                                    campaignName: "'.$this->settings->getOption('leads_campaign_name', '').'",
                                },
                                urls: {
                                    eitherOrUrl: "'.$this->getMiniGamesOption('either_or_url').'",
                                    classicQuizUrl: "'.$this->getMiniGamesOption('classic_quiz_url').'",
                                    pollUrl: "'.$this->getMiniGamesOption('poll_url').'",
                                    matchQuizUrl: "'.$this->getMiniGamesOption('match_quiz_url').'",
                                },
                            });
                        }
                    } catch (error) {
                        console.error("Error initializing FuWidget:", error);
                    }
                });
        ', 'after');
    }
}