<?php
/**
 * The main plugin class
 */
class FansUnitedCore {
    private static $instance = null;
    private $settings;
    private $assets;

    public static function getInstance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->initializeComponents();
    }

    private function initializeComponents() {
        $this->settings = new FansUnitedSettings();
        $this->assets = new FansUnitedAssets($this->settings);

        // Add test shortcode for theme options
        add_shortcode('fu_theme_options_test', array($this, 'renderThemeOptionsTest'));
    }

    public static function isActive() {
        return true;
    }

    public static function getOption($key, $default = null) {
        $instance = self::getInstance();
        return $instance->settings->getOption($key, $default);
    }

    public static function getAllOptions() {
        $instance = self::getInstance();
        return $instance->settings->getAllOptions();
    }

    /**
     * Test shortcode to display theme options in browser console
     */
    public function renderThemeOptionsTest($atts) {
        $theme_options = $this->settings->getThemeOptions();

        ob_start();
        ?>
        <div id="fu-theme-options-test">
            <p><strong>Theme Options Test</strong></p>
            <p>Check browser console for <code>window.fansUnitedThemeOptions</code></p>
            <script>
                console.log('Theme Options:', window.fansUnitedThemeOptions);
                console.log('Theme Options JSON:', JSON.stringify(window.fansUnitedThemeOptions, null, 2));
            </script>
        </div>
        <?php
        return ob_get_clean();
    }
}