<?php
/**
 * API Configuration Settings Partial
 */
class FansUnitedApiSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // API Tab
        add_settings_section(
            'config_api_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-config-api'
        );
        $this->addApiFields();
    }

    private function addApiFields() {
        $this->addField('client_id', __('Client ID', 'fans-united-core'), 'config_api_section', array(
            'type' => 'text',
            'description' => __('Your Fans United client identifier', 'fans-united-core'),
            'page' => 'fans-united-config-api'
        ));

        $this->addField('api_key', __('API Key', 'fans-united-core'), 'config_api_section', array(
            'type' => 'text',
            'description' => __('Your Fans United API key', 'fans-united-core'),
            'page' => 'fans-united-config-api'
        ));

        $this->addField('env', __('Environment', 'fans-united-core'), 'config_api_section', array(
            'type' => 'select',
            'options' => array(
                'prod' => 'Production',
                'dev' => 'Development',
                'staging' => 'Staging',
                'watg' => 'WATG',
                'yolo' => 'YOLO'
            ),
            'description' => __('Select the Fans United environment to use', 'fans-united-core'),
            'page' => 'fans-united-config-api'
        ));

        $this->addField('id_provider', __('ID Provider', 'fans-united-core'), 'config_api_section', array(
            'type' => 'select',
            'options' => array(
                'native' => 'Native',
                'sportal365' => 'Sportal365',
                'enetpulse' => 'Enetpulse',
                'sportradar' => 'Sportradar'
            ),
            'description' => __('Select the ID provider for sports data', 'fans-united-core'),
            'page' => 'fans-united-config-api'
        ));
    }
}
