<?php
/**
 * Firebase Configuration Settings Partial
 */
class FansUnitedFirebaseSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Firebase Tab
        add_settings_section(
            'config_firebase_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-config-firebase'
        );
        $this->addFirebaseFields();
    }

    private function addFirebaseFields() {
        $firebase_fields = array(
            'firebase_api_key' => __('Firebase API Key', 'fans-united-core'),
            'firebase_auth_domain' => __('Auth Domain', 'fans-united-core'),
            'firebase_project_id' => __('Project ID', 'fans-united-core'),
            'firebase_app_id' => __('Firebase App ID', 'fans-united-core'),
        );

        foreach ($firebase_fields as $key => $label) {
            $this->addField($key, $label, 'config_firebase_section', array(
                'type' => 'text',
                'page' => 'fans-united-config-firebase'
            ));
        }
    }
}
