<?php
/**
 * Languages Configuration Settings Partial
 */
class FansUnitedLanguagesSettings extends FansUnitedSettingsPartialBase {

    private $languages = array(
        'en' => 'English',
        'es' => 'Spanish',
        'fr' => 'French',
        'de' => 'German',
        'it' => 'Italian',
        'pt' => 'Portuguese',
        'sv' => 'Swedish',
        'da' => 'Danish',
        'fi' => 'Finnish',
        'bg' => 'Bulgarian',
        'ro' => 'Romanian',
        'el' => 'Greek',
        'pl' => 'Polish',
        'uk' => 'Ukrainian',
        'ru' => 'Russian',
        'ar' => 'Arabic',
        'ja' => 'Japanese',
        'sw' => 'Swahili'
    );

    public function registerSettings() {
        // Languages Tab
        add_settings_section(
            'config_languages_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-config-languages'
        );
        $this->addLanguageFields();
    }

    private function addLanguageFields() {
        $this->addField('lang', __('Default Language', 'fans-united-core'), 'config_languages_section', array(
            'type' => 'select',
            'options' => $this->languages,
            'description' => __('Select the default language for content', 'fans-united-core'),
            'page' => 'fans-united-config-languages'
        ));
    }
}
