<?php
/**
 * Leads Configuration Settings Partial
 */
class FansUnitedLeadsSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Leads Tab
        add_settings_section(
            'config_leads_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-config-leads'
        );
        $this->addLeadsFields();
    }

    private function addLeadsFields() {
        $this->addField('leads_position', __('Form Position', 'fans-united-core'), 'config_leads_section', array(
            'type' => 'select',
            'options' => array(
                'before' => 'Before Content',
                'after' => 'After Content'
            ),
            'default' => 'before',
            'description' => __('Select where the leads form should appear relative to content', 'fans-united-core'),
            'page' => 'fans-united-config-leads'
        ));

        $lead_fields = array(
            'fullName' => __('Full Name', 'fans-united-core'),
            'firstName' => __('First Name', 'fans-united-core'),
            'lastName' => __('Last Name', 'fans-united-core'),
            'email' => __('Email', 'fans-united-core'),
            'gender' => __('Gender', 'fans-united-core'),
            'country' => __('Country', 'fans-united-core'),
            'phoneCountryCode' => __('Phone Country Code', 'fans-united-core'),
            'phoneNumber' => __('Phone Number', 'fans-united-core')
        );

        $this->addField('leads_default_fields', __('Available Lead Fields', 'fans-united-core'), 'config_leads_section', array(
            'type' => 'multicheck',
            'options' => $lead_fields,
            'default' => array('email', 'fullName'),
            'description' => __('Select which fields should be shown in the leads form by default', 'fans-united-core'),
            'page' => 'fans-united-config-leads'
        ));

        $this->addField('leads_campaign_id', __('Campaign ID', 'fans-united-core'), 'config_leads_section', array(
            'type' => 'text',
            'description' => __('Enter the default campaign ID for leads collection', 'fans-united-core'),
            'page' => 'fans-united-config-leads'
        ));

        $this->addField('leads_campaign_name', __('Campaign Name', 'fans-united-core'), 'config_leads_section', array(
            'type' => 'text',
            'description' => __('Enter the default campaign name for leads collection', 'fans-united-core'),
            'page' => 'fans-united-config-leads'
        ));
    }
}
