<?php
/**
 * Miscellaneous Configuration Settings Partial
 */
class FansUnitedMiscSettings extends FansUnitedSettingsPartialBase {

    private $languages = array(
        'en' => 'English',
        'es' => 'Spanish',
        'fr' => 'French',
        'de' => 'German',
        'it' => 'Italian',
        'pt' => 'Portuguese',
        'sv' => 'Swedish',
        'da' => 'Danish',
        'fi' => 'Finnish',
        'bg' => 'Bulgarian',
        'ro' => 'Romanian',
        'el' => 'Greek',
        'pl' => 'Polish',
        'uk' => 'Ukrainian',
        'ru' => 'Russian',
        'ar' => 'Arabic',
        'ja' => 'Japanese',
        'sw' => 'Swahili'
    );

    public function registerSettings() {
        // Misc Tab
        add_settings_section(
            'config_misc_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-config-misc'
        );
        $this->addMiscFields();
    }

    private function addMiscFields() {
        $this->addField('misc_language', __('Language', 'fans-united-core'), 'config_misc_section', array(
            'type' => 'select',
            'options' => $this->languages,
            'default' => 'en',
            'description' => __('Default language for widgets', 'fans-united-core'),
            'page' => 'fans-united-config-misc'
        ));

        $this->addField('misc_show_answer_explanations', __('Show Answer Explanations', 'fans-united-core'), 'config_misc_section', array(
            'type' => 'checkbox',
            'default' => 1,
            'description' => __('Enable answer explanations in quiz widgets', 'fans-united-core'),
            'page' => 'fans-united-config-misc'
        ));

        $this->addField('misc_image_position', __('Image Position', 'fans-united-core'), 'config_misc_section', array(
            'type' => 'select',
            'options' => array(
                'left' => 'Left',
                'right' => 'Right'
            ),
            'default' => 'left',
            'description' => __('Default position for images in widgets', 'fans-united-core'),
            'page' => 'fans-united-config-misc'
        ));

        $this->addField('misc_default_image_placeholder_url', __('Default Image Placeholder URL', 'fans-united-core'), 'config_misc_section', array(
            'type' => 'text',
            'default' => '',
            'description' => __('URL to use as default image placeholder (leave empty for none)', 'fans-united-core'),
            'page' => 'fans-united-config-misc'
        ));

        $this->addField('misc_potm_auth_requirement', __('Player of the Match Auth Requirement', 'fans-united-core'), 'config_misc_section', array(
            'type' => 'select',
            'options' => array(
                '' => 'None',
                'FREE' => 'Free',
                'REGISTERED' => 'Registered'
            ),
            'default' => '',
            'description' => __('Authentication requirement for Player of the Match voting', 'fans-united-core'),
            'page' => 'fans-united-config-misc'
        ));
    }

    public function renderEmptySection() {
        // Empty section callback
    }
}

