<?php
/**
 * Theme Colors Settings Partial
 */
class FansUnitedThemeColorsSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Colors Tab
        add_settings_section(
            'theme_colors_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-theme-colors'
        );
        $this->addColorFields();
    }

    private function addColorFields() {
        // Light mode colors
        $this->addField('light_colors_subheader', '', 'theme_colors_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Light Mode Colors', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-colors'
        ));

        $this->addThemeColorFields('light', 'fans-united-theme-colors');

        // Dark mode colors
        $this->addField('dark_colors_subheader', '', 'theme_colors_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Dark Mode Colors', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-colors'
        ));

        $this->addThemeColorFields('dark', 'fans-united-theme-colors');
    }

    private function addThemeColorFields($mode, $page) {
        $mode_label = ucfirst($mode);

        // Palette colors
        $palette_colors = array(
            'success_plain_color' => array('label' => 'Success Plain Color', 'default' => '#4CAF50'),
            'success_outlined_border' => array('label' => 'Success Outlined Border', 'default' => '#4CAF50'),
            'danger_soft_bg' => array('label' => 'Danger Soft Background', 'default' => '#FEE4E2'),
            'danger_plain_color' => array('label' => 'Danger Plain Color', 'default' => '#F44336'),
            'danger_outlined_border' => array('label' => 'Danger Outlined Border', 'default' => '#F44336'),
            'primary_plain_color' => array('label' => 'Primary Plain Color', 'default' => '#1A77D2'),
            'primary_outlined_border' => array('label' => 'Primary Outlined Border', 'default' => '#1A77D2'),
            'primary_on_primary' => array('label' => 'Primary On Primary', 'default' => $mode === 'light' ? '#FAFAFA' : '#FAFAFA'),
            'primary_container' => array('label' => 'Primary Container', 'default' => '#2397F3'),
            'warning_soft_bg' => array('label' => 'Warning Soft Background', 'default' => '#FEF0C7'),
            'warning_plain_color' => array('label' => 'Warning Plain Color', 'default' => '#DC6803'),
        );

        foreach ($palette_colors as $key => $config) {
            $this->addField(
                "theme_{$mode}_{$key}",
                $config['label'],
                'theme_colors_section',
                array(
                    'type' => 'text',
                    'default' => $config['default'],
                    'description' => sprintf(__('%s mode %s', 'fans-united-core'), $mode_label, strtolower($config['label'])),
                    'page' => $page
                )
            );
        }

        // Text and surface colors
        $surface_colors = array(
            'text_primary' => array('label' => 'Text Primary', 'default' => $mode === 'light' ? '#212121' : '#FAFAFA'),
            'text_secondary' => array('label' => 'Text Secondary', 'default' => $mode === 'light' ? '#212121' : '#FAFAFA'),
            'text_color' => array('label' => 'Text Color', 'default' => $mode === 'light' ? '#212121' : '#FAFAFA'),
            'text_disabled' => array('label' => 'Text Disabled', 'default' => $mode === 'light' ? '#212121' : '#FAFAFA'),
            'surface' => array('label' => 'Surface', 'default' => $mode === 'light' ? '#FFFFFF' : '#424242'),
            'on_surface' => array('label' => 'On Surface', 'default' => $mode === 'light' ? '#F5F5F5' : '#212121'),
            'surface_variant' => array('label' => 'Surface Variant', 'default' => $mode === 'light' ? '#EEEEEE' : '#616161'),
            'surface_tint_dim' => array('label' => 'Surface Tint Dim', 'default' => $mode === 'light' ? '#212121' : '#FAFAFA'),
            'surface_inverse' => array('label' => 'Surface Inverse', 'default' => $mode === 'light' ? '#F5F5F5' : '#FAFAFA'),
            'outline_enabled_border' => array('label' => 'Outline Enabled Border', 'default' => $mode === 'light' ? '#E0E0E0' : '#757575'),
            'secondary_container' => array('label' => 'Secondary Container', 'default' => $mode === 'light' ? '#BDBDBD' : '#757575'),
        );

        foreach ($surface_colors as $key => $config) {
            $this->addField(
                "theme_{$mode}_{$key}",
                $config['label'],
                'theme_colors_section',
                array(
                    'type' => 'text',
                    'default' => $config['default'],
                    'description' => sprintf(__('%s mode %s', 'fans-united-core'), $mode_label, strtolower($config['label'])),
                    'page' => $page
                )
            );
        }
    }
}
