<?php
/**
 * Theme Effects Settings Partial
 */
class FansUnitedThemeEffectsSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Effects Tab
        add_settings_section(
            'theme_effects_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-theme-effects'
        );
        $this->addEffectsFields();
    }

    private function addEffectsFields() {
        $this->addGradientFields('fans-united-theme-effects');
    }

    private function addGradientFields($page) {
        $gradients = array(
            'light' => array(
                'standard' => array(
                    'label' => 'Standard Gradient',
                    'default' => 'linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, rgba(18, 18, 18, 0.8) 100%)',
                    'description' => 'Standard overlay gradient for light mode'
                ),
                'split' => array(
                    'label' => 'Split Gradient',
                    'default' => 'linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, rgba(18, 18, 18, 0.8) 100%)',
                    'description' => 'Split layout gradient for light mode'
                ),
            ),
            'dark' => array(
                'standard' => array(
                    'label' => 'Standard Gradient',
                    'default' => 'linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, rgba(18, 18, 18, 0.8) 100%)',
                    'description' => 'Standard overlay gradient for dark mode'
                ),
                'split' => array(
                    'label' => 'Split Gradient',
                    'default' => 'linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, rgba(18, 18, 18, 0.8) 100%)',
                    'description' => 'Split layout gradient for dark mode'
                ),
                'overlay' => array(
                    'label' => 'Overlay Gradient',
                    'default' => 'linear-gradient(270deg, rgba(255, 255, 255, 0) 0%, rgba(18, 18, 18, 0.8) 100%)',
                    'description' => 'Special overlay gradient for dark mode'
                ),
            ),
        );

        foreach ($gradients as $mode => $mode_gradients) {
            $mode_label = ucfirst($mode);

            $this->addField('gradient_mode_header_' . $mode, '', 'theme_effects_section', array(
                'type' => 'html',
                'content' => '<h4 class="section-divider">' . sprintf(__('%s Mode Gradients', 'fans-united-core'), $mode_label) . '</h4>',
                'page' => $page
            ));

            foreach ($mode_gradients as $type => $config) {
                $this->addField(
                    "theme_gradient_{$mode}_{$type}",
                    $config['label'],
                    'theme_effects_section',
                    array(
                        'type' => 'textarea',
                        'default' => $config['default'],
                        'description' => $config['description'] . ' (CSS gradient syntax)',
                        'page' => $page
                    )
                );
            }
        }
    }
}
