<?php
/**
 * Theme General Settings Partial
 */
class FansUnitedThemeGeneralSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // General Theme Tab
        add_settings_section(
            'theme_general_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-theme-general'
        );
        $this->addGeneralThemeFields();
    }

    private function addGeneralThemeFields() {
        $this->addField('theme_mode', __('Theme Mode', 'fans-united-core'), 'theme_general_section', array(
            'type' => 'select',
            'options' => array(
                'light' => 'Light',
                'dark' => 'Dark'
            ),
            'default' => 'light',
            'description' => __('Select the default theme mode for your Fans United widgets', 'fans-united-core'),
            'page' => 'fans-united-theme-general'
        ));
    }
}
