<?php
/**
 * Theme Layout Settings Partial
 */
class FansUnitedThemeLayoutSettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Layout Tab
        add_settings_section(
            'theme_layout_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-theme-layout'
        );
        $this->addLayoutFields();
    }

    private function addLayoutFields() {
        // Spacing scale
        $this->addField('spacing_header', '', 'theme_layout_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Spacing Scale', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-layout'
        ));

        $this->addSpacingFields('fans-united-theme-layout');

        // Breakpoints
        $this->addField('breakpoints_header', '', 'theme_layout_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Responsive Breakpoints', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-layout'
        ));

        $this->addBreakpointFields('fans-united-theme-layout');

        // Border settings
        $this->addField('border_header', '', 'theme_layout_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Border Settings', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-layout'
        ));

        $this->addBorderFields('fans-united-theme-layout');
    }

    private function addSpacingFields($page) {
        $spacing_values = array(
            '3xs' => array('label' => '3XS (Extra Extra Extra Small)', 'default' => '2px'),
            '2xs' => array('label' => '2XS (Extra Extra Small)', 'default' => '4px'),
            'xs' => array('label' => 'XS (Extra Small)', 'default' => '8px'),
            'sm' => array('label' => 'SM (Small)', 'default' => '12px'),
            'md' => array('label' => 'MD (Medium)', 'default' => '16px'),
            'lg' => array('label' => 'LG (Large)', 'default' => '24px'),
            'xl' => array('label' => 'XL (Extra Large)', 'default' => '32px'),
            '2xl' => array('label' => '2XL (Extra Extra Large)', 'default' => '40px'),
            '3xl' => array('label' => '3XL (Extra Extra Extra Large)', 'default' => '48px'),
        );

        foreach ($spacing_values as $key => $config) {
            $this->addField(
                "theme_spacing_{$key}",
                $config['label'],
                'theme_layout_section',
                array(
                    'type' => 'text',
                    'default' => $config['default'],
                    'description' => sprintf(__('Spacing value for %s (e.g., 16px, 1rem, 0.5em)', 'fans-united-core'), $key),
                    'page' => $page
                )
            );
        }
    }

    private function addBreakpointFields($page) {
        $breakpoints = array(
            'xs' => array('label' => 'XS (Extra Small)', 'default' => '0'),
            'sm' => array('label' => 'SM (Small)', 'default' => '444'),
            'md' => array('label' => 'MD (Medium)', 'default' => '600'),
            'lg' => array('label' => 'LG (Large)', 'default' => '900'),
            'xl' => array('label' => 'XL (Extra Large)', 'default' => '1200'),
            'xxl' => array('label' => 'XXL (Extra Extra Large)', 'default' => '1536'),
        );

        foreach ($breakpoints as $key => $config) {
            $this->addField(
                "theme_breakpoint_{$key}",
                $config['label'],
                'theme_layout_section',
                array(
                    'type' => 'text',
                    'default' => $config['default'],
                    'description' => sprintf(__('Breakpoint value for %s screens (pixels)', 'fans-united-core'), $key),
                    'page' => $page
                )
            );
        }
    }

    private function addBorderFields($page) {
        // Border sizes for each mode
        $this->addField('border_sizes_header', '', 'theme_layout_section', array(
            'type' => 'html',
            'content' => '<h5 class="section-divider">' . __('Border Sizes', 'fans-united-core') . '</h5>',
            'page' => $page
        ));

        foreach (array('light', 'dark') as $mode) {
            $mode_label = ucfirst($mode);
            $default_size = $mode === 'light' ? '1px' : '2px';

            $this->addField(
                "theme_border_{$mode}_size",
                sprintf(__('%s Mode Border Size', 'fans-united-core'), $mode_label),
                'theme_layout_section',
                array(
                    'type' => 'text',
                    'default' => $default_size,
                    'description' => sprintf(__('%s mode default border thickness (e.g., 1px, 2px)', 'fans-united-core'), $mode_label),
                    'page' => $page
                )
            );
        }

        // Border radius values
        $this->addField('border_radius_header', '', 'theme_layout_section', array(
            'type' => 'html',
            'content' => '<h5 class="section-divider">' . __('Border Radius Scale', 'fans-united-core') . '</h5>',
            'page' => $page
        ));

        $radius_values = array(
            'none' => array('label' => 'None (Sharp Corners)', 'default' => '0px'),
            '2xs' => array('label' => '2XS (Very Subtle)', 'default' => '2px'),
            'xs' => array('label' => 'XS (Subtle)', 'default' => '4px'),
            'sm' => array('label' => 'SM (Small)', 'default' => '8px'),
            'md' => array('label' => 'MD (Medium)', 'default' => '12px'),
            'lg' => array('label' => 'LG (Large)', 'default' => '16px'),
            'xl' => array('label' => 'XL (Extra Large)', 'default' => '24px'),
            '2xl' => array('label' => '2XL (Very Large)', 'default' => '232px'),
            'full' => array('label' => 'Full (Pill Shape)', 'default' => '1000px'),
        );

        foreach (array('light', 'dark') as $mode) {
            $mode_label = ucfirst($mode);

            $this->addField('radius_mode_header_' . $mode, '', 'theme_layout_section', array(
                'type' => 'html',
                'content' => '<h6 class="section-divider">' . sprintf(__('%s Mode Border Radius', 'fans-united-core'), $mode_label) . '</h6>',
                'page' => $page
            ));

            foreach ($radius_values as $key => $config) {
                $this->addField(
                    "theme_radius_{$mode}_{$key}",
                    $config['label'],
                    'theme_layout_section',
                    array(
                        'type' => 'text',
                        'default' => $config['default'],
                        'description' => sprintf(__('%s mode %s border radius (e.g., 8px, 0.5rem)', 'fans-united-core'), $mode_label, strtolower($config['label'])),
                        'page' => $page
                    )
                );
            }
        }
    }
}
