<?php
/**
 * Theme Legacy Settings Partial
 */
class FansUnitedThemeLegacySettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Legacy Tab
        add_settings_section(
            'theme_legacy_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-theme-legacy'
        );
        $this->addLegacyFields();
    }

    private function addLegacyFields() {
        $this->addField('legacy_warning', '', 'theme_legacy_section', array(
            'type' => 'html',
            'content' => '<div class="deprecated-notice">
                <h4>' . __('Legacy Color Palette', 'fans-united-core') . '<span class="warning-badge">' . __('DEPRECATED', 'fans-united-core') . '</span></h4>
                <p><strong>' . __('Important:', 'fans-united-core') . '</strong> ' . __('This legacy color palette system is deprecated and will be removed in a future version. Please use the new theme system for all new widgets and consider migrating existing widgets.', 'fans-united-core') . '</p>
                <p>' . __('These settings are maintained for backward compatibility with existing widgets only.', 'fans-united-core') . '</p>
            </div>',
            'page' => 'fans-united-theme-legacy'
        ));

        // Legacy theme selector
        $this->addField('theme', __('Legacy Theme', 'fans-united-core'), 'theme_legacy_section', array(
            'type' => 'select',
            'options' => array(
                'light' => 'Light',
                'dark' => 'Dark'
            ),
            'default' => 'light',
            'description' => __('(Deprecated) Legacy theme selector - use Theme Mode in General tab instead', 'fans-united-core'),
            'page' => 'fans-united-theme-legacy'
        ));

        // Legacy primary colors
        $primary_shades = array(
            50 => 'Lightest - for backgrounds',
            100 => 'Very light - for hover states',
            200 => 'Light - for disabled states',
            300 => 'Medium light - for secondary actions',
            400 => 'Medium - for active states',
            500 => 'Base color - for primary actions',
            600 => 'Medium dark - for hover states',
            700 => 'Dark - for active states',
            800 => 'Very dark - for text',
            900 => 'Darkest - for emphasis'
        );

        $default_colors = array(
            50 => '#e6f0f9',
            100 => '#cce1f3',
            200 => '#99c2e7',
            300 => '#66a3db',
            400 => '#3385cf',
            500 => '#0066cc',
            600 => '#0052a3',
            700 => '#003d7a',
            800 => '#002952',
            900 => '#001429'
        );

        foreach ($primary_shades as $shade => $description) {
            $this->addField(
                "primary_{$shade}",
                sprintf(__('(Deprecated) Primary %d', 'fans-united-core'), $shade),
                'theme_legacy_section',
                array(
                    'type' => 'text',
                    'default' => $default_colors[$shade],
                    'description' => $description,
                    'placeholder' => $default_colors[$shade],
                    'page' => 'fans-united-theme-legacy'
                )
            );
        }
    }
}
