<?php
/**
 * Theme Typography Settings Partial
 */
class FansUnitedThemeTypographySettings extends FansUnitedSettingsPartialBase {

    public function registerSettings() {
        // Typography Tab
        add_settings_section(
            'theme_typography_section',
            '',
            array($this, 'renderEmptySection'),
            'fans-united-theme-typography'
        );
        $this->addTypographyFields();
    }

    private function addTypographyFields() {
        // Light mode fonts
        $this->addField('typography_light_header', '', 'theme_typography_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Light Mode Typography', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-typography'
        ));

        $font_families = array(
            'primary' => array('label' => 'Primary Font', 'default' => 'Ubuntu, sans-serif'),
            'secondary' => array('label' => 'Secondary Font', 'default' => 'Roboto, sans-serif'),
        );

        foreach ($font_families as $key => $config) {
            $this->addField(
                "theme_font_light_{$key}",
                $config['label'],
                'theme_typography_section',
                array(
                    'type' => 'text',
                    'default' => $config['default'],
                    'description' => sprintf(__('Light mode %s font family (e.g., "Arial, sans-serif")', 'fans-united-core'), strtolower($config['label'])),
                    'page' => 'fans-united-theme-typography'
                )
            );
        }

        // Dark mode fonts
        $this->addField('typography_dark_header', '', 'theme_typography_section', array(
            'type' => 'html',
            'content' => '<h4 class="section-divider">' . __('Dark Mode Typography', 'fans-united-core') . '</h4>',
            'page' => 'fans-united-theme-typography'
        ));

        foreach ($font_families as $key => $config) {
            $this->addField(
                "theme_font_dark_{$key}",
                $config['label'],
                'theme_typography_section',
                array(
                    'type' => 'text',
                    'default' => $config['default'],
                    'description' => sprintf(__('Dark mode %s font family (e.g., "Arial, sans-serif")', 'fans-united-core'), strtolower($config['label'])),
                    'page' => 'fans-united-theme-typography'
                )
            );
        }
    }
}
