/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.errorprone.BugPattern;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneError;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ErrorPronePlugins;
import com.google.errorprone.ErrorProneVersion;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.JavacErrorDescriptionListener;
import com.google.errorprone.SubContext;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.PropagatedException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;

@ClientCodeWrapper.Trusted
public class ErrorProneAnalyzer
implements TaskListener {
    private final Set<Tree> seen = new HashSet<Tree>();
    private final Supplier<CodeTransformer> transformer;
    private final ErrorProneOptions errorProneOptions;
    private final Context context;
    private final DescriptionListener.Factory descriptionListenerFactory;
    private int errorProneErrors = 0;

    public static ErrorProneAnalyzer createByScanningForPlugins(ScannerSupplier scannerSupplier, ErrorProneOptions errorProneOptions, Context context) {
        return new ErrorProneAnalyzer(ErrorProneAnalyzer.scansPlugins(scannerSupplier, errorProneOptions, context), errorProneOptions, context, JavacErrorDescriptionListener.provider(context));
    }

    private static Supplier<CodeTransformer> scansPlugins(ScannerSupplier scannerSupplier, ErrorProneOptions errorProneOptions, Context context) {
        return Suppliers.memoize(() -> {
            try {
                return ErrorProneScannerTransformer.create((Scanner)ErrorPronePlugins.loadPlugins(scannerSupplier, context).applyOverrides(errorProneOptions).get());
            }
            catch (InvalidCommandLineOptionException e) {
                throw new PropagatedException(e);
            }
        });
    }

    static ErrorProneAnalyzer createWithCustomDescriptionListener(CodeTransformer codeTransformer, ErrorProneOptions errorProneOptions, Context context, DescriptionListener.Factory descriptionListenerFactory) {
        return new ErrorProneAnalyzer(Suppliers.ofInstance(codeTransformer), errorProneOptions, context, descriptionListenerFactory);
    }

    private ErrorProneAnalyzer(Supplier<CodeTransformer> transformer, ErrorProneOptions errorProneOptions, Context context, DescriptionListener.Factory descriptionListenerFactory) {
        this.transformer = Preconditions.checkNotNull(transformer);
        this.errorProneOptions = Preconditions.checkNotNull(errorProneOptions);
        this.context = Preconditions.checkNotNull(context);
        this.descriptionListenerFactory = Preconditions.checkNotNull(descriptionListenerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        if (JavaCompiler.instance(this.context).errorCount() > this.errorProneErrors) {
            return;
        }
        TreePath path = JavacTrees.instance(this.context).getPath(taskEvent.getTypeElement());
        if (path == null) {
            path = new TreePath(taskEvent.getCompilationUnit());
        }
        Verify.verify(this.seen.add(path.getLeaf()), "Duplicate FLOW event for: %s", (Object)taskEvent.getTypeElement());
        SubContext subContext = new SubContext(this.context);
        subContext.put(ErrorProneOptions.class, this.errorProneOptions);
        Log log = Log.instance(this.context);
        JCTree.JCCompilationUnit compilation = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        DescriptionListener descriptionListener = this.descriptionListenerFactory.getDescriptionListener(log, compilation);
        DescriptionListener countingDescriptionListener = d -> {
            if (d.severity == BugPattern.SeverityLevel.ERROR) {
                ++this.errorProneErrors;
            }
            descriptionListener.onDescribed(d);
        };
        JavaFileObject originalSource = log.useSource(compilation.getSourceFile());
        try {
            if (this.shouldExcludeSourceFile(compilation.getSourceFile())) {
                return;
            }
            if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                this.transformer.get().apply(path, subContext, countingDescriptionListener);
            } else if (this.finishedCompilation(path.getCompilationUnit())) {
                this.transformer.get().apply(new TreePath(compilation), subContext, countingDescriptionListener);
            }
        }
        catch (ErrorProneError e) {
            e.logFatalError(log, this.context);
            throw e;
        }
        catch (LinkageError e) {
            String version2 = ErrorProneVersion.loadVersionFromPom().or("unknown version");
            log.error("error.prone.crash", Throwables.getStackTraceAsString(e), version2, "(see stack trace)");
            throw e;
        }
        catch (Symbol.CompletionFailure e) {
            log.error("proc.cant.access", e.sym, e.getDetailValue(), Throwables.getStackTraceAsString(e));
        }
        finally {
            log.useSource(originalSource);
        }
    }

    private boolean shouldExcludeSourceFile(JavaFileObject sourceFile) {
        Pattern excludedPattern = this.errorProneOptions.getExcludedPattern();
        return excludedPattern != null && excludedPattern.matcher(ASTHelpers.getFileNameFromUri(sourceFile.toUri())).matches();
    }

    private boolean finishedCompilation(CompilationUnitTree tree) {
        block4: for (Tree tree2 : tree.getTypeDecls()) {
            switch (tree2.getKind()) {
                case EMPTY_STATEMENT: {
                    continue block4;
                }
                case IMPORT: {
                    continue block4;
                }
            }
            if (this.seen.contains(tree2)) continue;
            return false;
        }
        return true;
    }
}

