/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SuppressionHelper {
    private static final ImmutableSet<String> GENERATED_ANNOTATIONS = ImmutableSet.of("javax.annotation.Generated", "javax.annotation.processing.Generated");
    private final Set<Class<? extends Annotation>> customSuppressionAnnotations;

    public SuppressionHelper(Set<Class<? extends Annotation>> customSuppressionAnnotations) {
        if (customSuppressionAnnotations == null) {
            throw new IllegalArgumentException("customSuppressionAnnotations must be non-null");
        }
        this.customSuppressionAnnotations = customSuppressionAnnotations;
    }

    public SuppressionInfo extendSuppressionSets(Symbol sym, Type suppressWarningsType, Set<String> suppressionsOnCurrentPath, Set<Class<? extends Annotation>> customSuppressionsOnCurrentPath, boolean inGeneratedCode, VisitorState state) {
        boolean newInGeneratedCode = inGeneratedCode || SuppressionHelper.isGenerated(sym, state);
        HashSet<Class<? extends Annotation>> newCustomSuppressions = null;
        for (Class<? extends Annotation> annotationType : this.customSuppressionAnnotations) {
            if (!ASTHelpers.hasAnnotation(sym, annotationType, state)) continue;
            if (newCustomSuppressions == null) {
                newCustomSuppressions = new HashSet<Class<? extends Annotation>>(customSuppressionsOnCurrentPath);
            }
            newCustomSuppressions.add(annotationType);
        }
        HashSet<String> newSuppressions = null;
        for (Attribute.Compound attr : sym.getAnnotationMirrors()) {
            if (attr.type.tsym != suppressWarningsType.tsym && !attr.type.tsym.getQualifiedName().contentEquals("android.annotation.SuppressLint")) continue;
            for (Pair<Symbol.MethodSymbol, Attribute> value : attr.values) {
                if (!((Symbol.MethodSymbol)value.fst).name.contentEquals("value")) continue;
                if (value.snd instanceof Attribute.Array) {
                    for (Attribute suppress : ((Attribute.Array)value.snd).values) {
                        if (newSuppressions == null) {
                            newSuppressions = new HashSet<String>(suppressionsOnCurrentPath);
                        }
                        newSuppressions.add((String)suppress.getValue());
                    }
                    continue;
                }
                throw new RuntimeException("Expected SuppressWarnings/SuppressLint annotation to take array type");
            }
        }
        return new SuppressionInfo(newSuppressions, (Set<Class<? extends Annotation>>)newCustomSuppressions, newInGeneratedCode);
    }

    public static boolean isSuppressed(Suppressible suppressible, Set<String> suppressionsOnCurrentPath, Set<Class<? extends Annotation>> customSuppressionsOnCurrentPath, BugPattern.SeverityLevel severityLevel, boolean inGeneratedCode, boolean disableWarningsInGeneratedCode) {
        if (inGeneratedCode && disableWarningsInGeneratedCode && severityLevel != BugPattern.SeverityLevel.ERROR) {
            return true;
        }
        if (suppressible.supportsSuppressWarnings() && !Collections.disjoint(suppressible.allNames(), suppressionsOnCurrentPath)) {
            return true;
        }
        return !Collections.disjoint(suppressible.customSuppressionAnnotations(), customSuppressionsOnCurrentPath);
    }

    private static boolean isGenerated(Symbol sym, VisitorState state) {
        for (String annotation2 : GENERATED_ANNOTATIONS) {
            if (!ASTHelpers.hasAnnotation(sym, annotation2, state)) continue;
            return true;
        }
        return false;
    }

    public static class SuppressionInfo {
        public Set<String> suppressWarningsStrings;
        public Set<Class<? extends Annotation>> customSuppressions;
        public boolean inGeneratedCode;

        public SuppressionInfo(Set<String> suppressWarningsStrings, Set<Class<? extends Annotation>> customSuppressions, boolean inGeneratedCode) {
            this.suppressWarningsStrings = suppressWarningsStrings;
            this.customSuppressions = customSuppressions;
            this.inGeneratedCode = inGeneratedCode;
        }
    }
}

