/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.apply.ImportOrganizer;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ImportStatements {
    private final ImportOrganizer importOrganizer;
    private int startPos = Integer.MAX_VALUE;
    private int endPos = -1;
    private final Set<String> importStrings;
    private boolean hasExistingImports;
    private final ImmutableSet<String> originalImports;

    public static ImportStatements create(JCTree.JCCompilationUnit compilationUnit) {
        return ImportStatements.create(compilationUnit, ImportOrganizer.STATIC_FIRST_ORGANIZER);
    }

    public static ImportStatements create(JCTree.JCCompilationUnit compilationUnit, ImportOrganizer importOrganizer) {
        return new ImportStatements((JCTree.JCExpression)compilationUnit.getPackageName(), compilationUnit.getImports(), compilationUnit.endPositions, importOrganizer);
    }

    ImportStatements(JCTree.JCExpression packageTree, List<JCTree.JCImport> importTrees, EndPosTable endPositions, ImportOrganizer importOrganizer) {
        if (importTrees.isEmpty()) {
            this.hasExistingImports = false;
            this.endPos = this.startPos = packageTree != null ? packageTree.getEndPosition(endPositions) + 2 : 0;
        } else {
            this.hasExistingImports = true;
            for (JCTree.JCImport importTree : importTrees) {
                int currStartPos = importTree.getStartPosition();
                int currEndPos = importTree.getEndPosition(endPositions);
                this.startPos = Math.min(this.startPos, currStartPos);
                this.endPos = Math.max(this.endPos, currEndPos);
            }
        }
        Preconditions.checkState(this.startPos <= this.endPos);
        this.importOrganizer = importOrganizer;
        this.importStrings = new LinkedHashSet<String>();
        this.importStrings.addAll(Lists.transform(importTrees, new Function<JCTree.JCImport, String>(){

            @Override
            public String apply(JCTree.JCImport input) {
                String importExpr = input.toString();
                return CharMatcher.whitespace().or(CharMatcher.is(';')).trimTrailingFrom(importExpr);
            }
        }));
        this.originalImports = ImmutableSet.copyOf(this.importStrings);
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public boolean add(String importToAdd) {
        return this.importStrings.add(importToAdd);
    }

    public boolean addAll(Collection<String> importsToAdd) {
        return this.importStrings.addAll(importsToAdd);
    }

    public boolean remove(String importToRemove) {
        return this.importStrings.remove(importToRemove);
    }

    public boolean removeAll(Collection<String> importsToRemove) {
        return this.importStrings.removeAll(importsToRemove);
    }

    public boolean importsHaveChanged() {
        return !this.importStrings.equals(this.originalImports);
    }

    public String toString() {
        if (this.importStrings.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!this.hasExistingImports) {
            result.append('\n');
        }
        List<ImportOrganizer.Import> imports = this.importStrings.stream().map(ImportOrganizer.Import::importOf).collect(Collectors.toList());
        ImportOrganizer.OrganizedImports organizedImports = this.importOrganizer.organizeImports(imports);
        int expectedImportCount = imports.size();
        int importCount = organizedImports.getImportCount();
        if (importCount != expectedImportCount) {
            throw new IllegalStateException(String.format("Expected %d import(s) in the organized imports but it contained %d", expectedImportCount, importCount));
        }
        result.append(organizedImports.asImportBlock());
        String replacementString = result.toString();
        if (!this.hasExistingImports) {
            return replacementString;
        }
        return CharMatcher.whitespace().trimTrailingFrom(replacementString);
    }
}

